/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.IIORegistry;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.SwingUtilities;
import org.weasis.launcher.WeasisLauncher;

public class WebstartLauncher
extends WeasisLauncher
implements SingleInstanceListener {
    private static final WebstartLauncher instance = new WebstartLauncher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newActivation(final String[] argv) {
        WebstartLauncher webstartLauncher = this;
        synchronized (webstartLauncher) {
            int loop = 0;
            boolean runLoop = true;
            while (runLoop && !frameworkLoaded) {
                try {
                    Thread.sleep(500L);
                    if (++loop <= 100) continue;
                    throw new InterruptedException();
                }
                catch (InterruptedException e) {
                    runLoop = false;
                }
            }
        }
        if (m_tracker != null && argv.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WeasisLauncher.m_tracker.open();
                    Object commandSession = WeasisLauncher.getCommandSession(WeasisLauncher.m_tracker.getService());
                    if (commandSession != null) {
                        List<StringBuilder> commandList = WeasisLauncher.splitCommand(argv);
                        WeasisLauncher.commandSession_execute(commandSession, "weasis:ui -v");
                        for (StringBuilder command : commandList) {
                            WeasisLauncher.commandSession_execute(commandSession, command);
                        }
                        WeasisLauncher.commandSession_close(commandSession);
                    }
                    WeasisLauncher.m_tracker.close();
                }
            });
        }
    }

    public static void launch(String[] argv) throws Exception {
        WeasisLauncher.launch(argv);
    }

    public static void main(String[] argv) throws Exception {
        WebstartLauncher.launch(argv);
    }

    static {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener((SingleInstanceListener)instance);
        }
        catch (UnavailableServiceException singleInstanceService) {
            // empty catch block
        }
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<Class<?>> categories = registry.getCategories();
        ArrayList toRemove = new ArrayList();
        while (categories.hasNext()) {
            Class<?> class1 = categories.next();
            Iterator<?> providers = registry.getServiceProviders(class1, false);
            while (providers.hasNext()) {
                Object provider = providers.next();
                if (!provider.getClass().getPackage().getName().startsWith("com.sun.media")) continue;
                toRemove.add(provider);
            }
        }
        for (Object provider : toRemove) {
            registry.deregisterServiceProvider(provider);
        }
    }
}

