/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;
import org.weasis.launcher.FileUtil;
import org.weasis.launcher.HostActivator;
import org.weasis.launcher.LookAndFeels;
import org.weasis.launcher.Messages;
import org.weasis.launcher.RemotePreferences;
import org.weasis.launcher.SwingResources;
import org.weasis.launcher.WeasisLoader;
import org.weasis.launcher.applet.WeasisFrame;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class WeasisLauncher {
    public static final String BUNDLE_DIR_SWITCH = "-b";
    public static final String SHUTDOWN_HOOK_PROP = "felix.shutdown.hook";
    public static final String CONFIG_PROPERTIES_PROP = "felix.config.properties";
    public static final String CONFIG_PROPERTIES_FILE_VALUE = "config.properties";
    public static final String EXTENDED_PROPERTIES_PROP = "felix.extended.config.properties";
    public static final String EXTENDED_PROPERTIES_FILE_VALUE = "ext-config.properties";
    public static final String CONFIG_DIRECTORY = "conf";
    private static HostActivator m_activator = null;
    static volatile Felix m_felix = null;
    static volatile ServiceTracker m_tracker = null;
    static volatile boolean frameworkLoaded = false;
    private static String APP_PROPERTY_FILE = "weasis.properties";
    public static final String P_WEASIS_VERSION = "weasis.version";
    public static final String P_WEASIS_PROFILE = "weasis.profile";
    public static final String P_WEASIS_NAME = "weasis.name";
    public static final String P_WEASIS_PATH = "weasis.path";
    private static final String P_WEASIS_RES_DATE = "weasis.resources.date";
    static Properties modulesi18n = null;
    private static String look = null;
    private static RemotePreferences REMOTE_PREFS;
    private static File prefDir;

    public static void main(String[] argv) throws Exception {
        WeasisLauncher.launch(argv);
    }

    public static void setJnlpSystemProperties() {
        String PREFIX = "jnlp.weasis.";
        int PREFIX_LENGTH = "jnlp.weasis.".length();
        Properties properties = System.getProperties();
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith("jnlp.weasis.")) continue;
            String value = properties.getProperty(propertyName);
            System.setProperty(propertyName.substring(PREFIX_LENGTH), value);
            properties.remove(propertyName);
        }
        System.setProperty("felix.extensions.disable", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launch(String[] argv) throws Exception {
        String portable;
        WeasisLauncher.setSystemSpecification();
        WeasisLauncher.setJnlpSystemProperties();
        for (int i = 0; i < argv.length; ++i) {
            String[] vmarg;
            if (!argv[i].startsWith("-VMP") || argv[i].length() <= 4 || (vmarg = argv[i].substring(4).split("=", 2)).length != 2) continue;
            if (vmarg[1].startsWith("\"") && vmarg[1].endsWith("\"")) {
                vmarg[1] = vmarg[1].substring(1, vmarg[1].length() - 1);
            }
            System.setProperty(vmarg[0], Util.substVars((String)vmarg[1], (String)vmarg[0], null, null));
        }
        List<StringBuilder> commandList = WeasisLauncher.splitCommand(argv);
        String bundleDir = null;
        String cacheDir = null;
        for (StringBuilder c : commandList) {
            String command = c.toString();
            if (!command.startsWith("felix")) continue;
            String[] params = command.split(" ");
            if (params.length < 3 || params.length > 4) {
                System.err.println("Usage: [$felix -b <bundle-deploy-dir>] [<bundle-cache-dir>]");
            } else {
                bundleDir = params[2];
                if (params.length > 3) {
                    cacheDir = params[3];
                }
            }
            commandList.remove(c);
            break;
        }
        if ((portable = System.getProperty("weasis.portable.dir")) != null) {
            File basePortableDir = new File(portable);
            String baseURL = "";
            try {
                baseURL = basePortableDir.toURI().toURL().toString() + "weasis";
                System.setProperty("weasis.codebase.url", baseURL);
                baseURL = baseURL + "/conf/";
                if (System.getProperty(CONFIG_PROPERTIES_PROP) == null) {
                    System.setProperty(CONFIG_PROPERTIES_PROP, baseURL + CONFIG_PROPERTIES_FILE_VALUE);
                }
                if (System.getProperty(EXTENDED_PROPERTIES_PROP) == null) {
                    System.setProperty(EXTENDED_PROPERTIES_PROP, baseURL + EXTENDED_PROPERTIES_FILE_VALUE);
                }
                System.setProperty("weasis.export.dicom", "true");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println();
        System.out.println("***** Starting Configuration *****");
        Properties serverProp = WeasisLauncher.loadConfigProperties();
        if (serverProp == null) {
            System.err.println("Cannot start, no config.properties found.");
            serverProp = new Properties();
        }
        if (bundleDir != null) {
            serverProp.setProperty("felix.auto.deploy.dir", bundleDir);
        }
        String profileName = serverProp.getProperty(P_WEASIS_PROFILE, "default");
        serverProp.setProperty(P_WEASIS_PROFILE, profileName);
        String sourceID = WeasisLauncher.toHex((portable == null ? System.getProperty("weasis.codebase.url", "unknown") + profileName : "portable").hashCode());
        System.setProperty("weasis.source.id", sourceID);
        cacheDir = serverProp.getProperty("org.osgi.framework.storage") + "-" + sourceID;
        serverProp.setProperty("org.osgi.framework.storage", cacheDir);
        WeasisLoader loader = WeasisLauncher.loadProperties(serverProp);
        WeasisFrame mainFrame = loader.getMainFrame();
        Properties localProp = loader.getLocalProperties();
        JVMShutdownHook shutdownHook = new JVMShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        WeasisLauncher.registerAdditionalShutdownHook();
        System.out.println("");
        System.out.println("Starting...");
        System.out.println("");
        System.out.println("| | /| / /__ ___ ____ (_)__");
        System.out.println("| |/ |/ / -_) _ `(_-</ (_-<");
        System.out.println("|__/|__/\\__/\\_,_/___/_/___/");
        System.out.println("");
        int exitStatus = 0;
        m_activator = new HostActivator();
        ArrayList<HostActivator> list = new ArrayList<HostActivator>();
        list.add(m_activator);
        serverProp.put("felix.systembundle.activators", list);
        try {
            m_felix = new Felix((Map)serverProp);
            m_felix.init();
            loader.setFelix(serverProp, m_activator.getBundleContext());
            loader.writeLabel(String.format(Messages.getString("WeasisLauncher.starting"), System.getProperty(P_WEASIS_NAME)));
            m_tracker = new ServiceTracker(m_activator.getBundleContext(), "org.apache.felix.service.command.CommandProcessor", null);
            m_tracker.open();
            m_felix.start();
            loader.close();
            loader = null;
            for (Bundle b : m_felix.getBundleContext().getBundles()) {
                if (!b.getSymbolicName().equals("org.apache.felix.gogo.shell") || b.getState() != 2) continue;
                b.start();
                break;
            }
            SwingUtilities.invokeLater(() -> {
                m_tracker.open();
                Object commandSession = WeasisLauncher.getCommandSession(m_tracker.getService());
                if (commandSession != null) {
                    for (StringBuilder command : commandList) {
                        WeasisLauncher.commandSession_execute(commandSession, command);
                    }
                    WeasisLauncher.commandSession_close(commandSession);
                }
                m_tracker.close();
            });
            String mainUI = serverProp.getProperty("weasis.main.ui", "");
            mainUI = mainUI.trim();
            if (!"".equals(mainUI)) {
                boolean uiStarted = false;
                for (Bundle b : m_felix.getBundleContext().getBundles()) {
                    if (!b.getSymbolicName().equals(mainUI) || b.getState() != 32) continue;
                    uiStarted = true;
                    break;
                }
                if (!uiStarted) {
                    throw new IllegalStateException("Main User Interface bundle cannot be started");
                }
            }
            frameworkLoaded = true;
            WeasisLauncher.showMessage(mainFrame, serverProp, localProp);
            m_felix.waitForStop(0L);
            System.exit(0);
        }
        catch (Throwable ex) {
            exitStatus = -1;
            System.err.println("Cannot not start framework: " + ex);
            System.err.println("Weasis cache will be cleaned at next launch.");
            System.err.println("State of the framework:");
            for (Bundle b : m_felix.getBundleContext().getBundles()) {
                System.err.println(" * " + b.getSymbolicName() + "-" + b.getVersion().toString() + " " + STATE.valueOf(b.getState()));
            }
            WeasisLauncher.resetBundleCache();
        }
        finally {
            Runtime.getRuntime().halt(exitStatus);
        }
    }

    private static void resetBundleCache() {
        File sourceIdProps = new File(System.getProperty(P_WEASIS_PATH, ""), System.getProperty("weasis.source.id") + ".properties");
        Properties localSourceProp = WeasisLauncher.readProperties(sourceIdProps);
        localSourceProp.setProperty("weasis.clean.cache", "true");
        FileUtil.storeProperties(sourceIdProps, localSourceProp, null);
    }

    private static void showMessage(WeasisFrame mainFrame, Properties s_prop, Properties l_prop) {
        String val;
        String versionOld = s_prop.getProperty("prev.weasis.version");
        String versionNew = s_prop.getProperty(P_WEASIS_VERSION);
        if (versionOld == null) {
            String val2 = WeasisLauncher.getGeneralProperty("weasis.show.disclaimer", "true", s_prop, l_prop, false, false);
            if (Boolean.valueOf(val2).booleanValue()) {
                EventQueue.invokeLater(() -> {
                    Object[] options = new Object[]{Messages.getString("WeasisLauncher.ok"), Messages.getString("WeasisLauncher.no")};
                    String appName = System.getProperty(P_WEASIS_NAME);
                    int response = JOptionPane.showOptionDialog(mainFrame.getRootPaneContainer() == null ? null : mainFrame.getRootPaneContainer().getContentPane(), String.format(Messages.getString("WeasisLauncher.msg"), appName), String.format(Messages.getString("WeasisLauncher.first"), appName), 0, 2, null, options, null);
                    if (response == 0) {
                        l_prop.setProperty("weasis.show.disclaimer", Boolean.FALSE.toString());
                        if (prefDir != null) {
                            FileUtil.storeProperties(new File(prefDir, APP_PROPERTY_FILE), l_prop, null);
                        }
                    } else {
                        File sourceID_props = new File(System.getProperty(P_WEASIS_PATH, ""), System.getProperty("weasis.source.id") + ".properties");
                        sourceID_props.delete();
                        System.err.println("Refusing the disclaimer");
                        System.exit(-1);
                    }
                });
            }
        } else if (versionNew != null && !versionNew.equals(versionOld) && Boolean.valueOf(val = WeasisLauncher.getGeneralProperty("weasis.show.release", "true", s_prop, l_prop, false, false)).booleanValue()) {
            Version vOld = WeasisLauncher.getVersion(versionOld);
            Version vNew = WeasisLauncher.getVersion(versionNew);
            if (vNew.compareTo(vOld) > 0) {
                String lastTag = l_prop.getProperty("weasis.version.release", null);
                if (lastTag != null && vNew.compareTo(vOld = WeasisLauncher.getVersion(lastTag)) <= 0) {
                    return;
                }
                l_prop.setProperty("weasis.version.release", vNew.toString());
                if (prefDir != null) {
                    FileUtil.storeProperties(new File(prefDir, APP_PROPERTY_FILE), l_prop, null);
                }
            }
            String releaseNotesUrl = s_prop.getProperty("weasis.releasenotes");
            StringBuilder message = new StringBuilder("<P>");
            message.append(String.format(Messages.getString("WeasisLauncher.change.version"), System.getProperty(P_WEASIS_NAME), versionOld, versionNew));
            EventQueue.invokeLater(() -> {
                JTextPane jTextPane1 = new JTextPane();
                jTextPane1.setContentType("text/html");
                jTextPane1.setEditable(false);
                jTextPane1.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        JTextPane pane = (JTextPane)e.getSource();
                        if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                            pane.setToolTipText(e.getDescription());
                        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                            pane.setToolTipText(null);
                        } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            Desktop desktop;
                            if (System.getProperty("os.name", "unknown").toLowerCase().startsWith("linux")) {
                                try {
                                    String cmd = String.format("xdg-open %s", e.getURL());
                                    Runtime.getRuntime().exec(cmd);
                                }
                                catch (IOException e1) {
                                    System.err.println("Unable to launch the WEB browser");
                                    e1.printStackTrace();
                                }
                            } else if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                                try {
                                    desktop.browse(e.getURL().toURI());
                                }
                                catch (Exception ex) {
                                    System.err.println("Unable to launch the WEB browser");
                                }
                            }
                        }
                    }
                });
                StyleSheet ss = ((HTMLEditorKit)jTextPane1.getEditorKit()).getStyleSheet();
                ss.addRule("body {font-family:sans-serif;font-size:12pt;background-color:#" + Integer.toHexString(jTextPane1.getBackground().getRGB() & 0xFFFFFF | 0x1000000).substring(1) + ";color:#" + Integer.toHexString(jTextPane1.getForeground().getRGB() & 0xFFFFFF | 0x1000000).substring(1) + ";margin:3;font-weight:normal;}");
                message.append("<BR>");
                String rn = Messages.getString("WeasisLauncher.release");
                message.append(String.format("<a href=\"%s", releaseNotesUrl));
                message.append("\" style=\"color:#FF9900\">");
                message.append(rn);
                message.append("</a>");
                message.append("</P>");
                jTextPane1.setText(message.toString());
                JOptionPane.showMessageDialog(mainFrame.getRootPaneContainer() == null ? null : mainFrame.getRootPaneContainer().getContentPane(), jTextPane1, Messages.getString("WeasisLauncher.News"), -1);
            });
        }
    }

    private static Version getVersion(String version) {
        String v = "";
        if (version != null) {
            int index = version.indexOf("-");
            v = index > 0 ? version.substring(0, index) : version;
        }
        return new Version(v);
    }

    private static String toHex(int val) {
        char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] ch8 = new char[8];
        int i = 8;
        while (--i >= 0) {
            ch8[i] = HEX_DIGIT[val & 0xF];
            val >>= 4;
        }
        return String.valueOf(ch8);
    }

    public static List<StringBuilder> splitCommand(String[] args) {
        int length = args.length;
        ArrayList<StringBuilder> list = new ArrayList<StringBuilder>(5);
        for (int i = 0; i < length; ++i) {
            if (!args[i].startsWith("$") || args[i].length() <= 1) continue;
            StringBuilder command = new StringBuilder(args[i].substring(1));
            while (i + 1 < length && !args[i + 1].startsWith("$") && !args[i + 1].startsWith("-VMP")) {
                command.append(" ");
                if (args[++i].indexOf(" ") != -1) {
                    command.append("\"");
                    command.append(args[i]);
                    command.append("\"");
                    continue;
                }
                command.append(args[i]);
            }
            list.add(command);
        }
        return list;
    }

    public static Object getCommandSession(Object commandProcessor) {
        if (commandProcessor == null) {
            return null;
        }
        Class[] parameterTypes = new Class[]{InputStream.class, PrintStream.class, PrintStream.class};
        Object[] arguments = new Object[]{System.in, System.out, System.err};
        try {
            Method nameMethod = commandProcessor.getClass().getMethod("createSession", parameterTypes);
            Object commandSession = nameMethod.invoke(commandProcessor, arguments);
            return commandSession;
        }
        catch (Exception ex) {
            System.err.println(ex);
            return null;
        }
    }

    public static boolean commandSession_close(Object commandSession) {
        if (commandSession == null) {
            return false;
        }
        try {
            Method nameMethod = commandSession.getClass().getMethod("close", new Class[0]);
            nameMethod.invoke(commandSession, new Object[0]);
            return true;
        }
        catch (Exception ex) {
            System.err.println(ex);
            return false;
        }
    }

    public static boolean commandSession_execute(Object commandSession, CharSequence charSequence) {
        if (commandSession == null) {
            return false;
        }
        Class[] parameterTypes = new Class[]{CharSequence.class};
        Object[] arguments = new Object[]{charSequence};
        try {
            Method nameMethod = commandSession.getClass().getMethod("execute", parameterTypes);
            nameMethod.invoke(commandSession, arguments);
            return true;
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
            return false;
        }
    }

    public static Properties loadConfigProperties() {
        URI propURI = WeasisLauncher.getPropertiesURI(CONFIG_PROPERTIES_PROP, CONFIG_PROPERTIES_FILE_VALUE);
        Properties props = null;
        if (propURI != null) {
            System.out.println("felix.config.properties: " + propURI);
            props = WeasisLauncher.readProperties(propURI, null);
        } else {
            System.err.println("No config.properties path found, Weasis cannot start!");
        }
        propURI = WeasisLauncher.getPropertiesURI(EXTENDED_PROPERTIES_PROP, EXTENDED_PROPERTIES_FILE_VALUE);
        if (propURI != null) {
            System.out.println("felix.extended.config.properties: " + propURI);
            props = WeasisLauncher.readProperties(propURI, props);
        }
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                props.setProperty(name, Util.substVars((String)props.getProperty(name), (String)name, null, (Properties)props));
            }
        }
        return props;
    }

    public static URI getPropertiesURI(String configProp, String configFile) {
        File confDir;
        int start;
        URI propURL;
        String custom = System.getProperty(configProp);
        if (custom != null) {
            try {
                propURL = new URI(custom);
            }
            catch (URISyntaxException e) {
                System.err.print(configProp + ": " + e);
                return null;
            }
        }
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            confDir = new File(new File(new File(jarLocation).getAbsolutePath()).getParent(), CONFIG_DIRECTORY);
        } else {
            confDir = new File(System.getProperty("user.dir"), CONFIG_DIRECTORY);
        }
        try {
            propURL = new File(confDir, configFile).toURI();
        }
        catch (Exception ex) {
            System.err.print(configFile + ": " + ex);
            return null;
        }
        return propURL;
    }

    public static Properties readProperties(URI propURI, Properties props) {
        if (props == null) {
            props = new Properties();
        }
        InputStream is = null;
        try {
            is = FileUtil.getAdaptedConnection(propURI.toURL()).getInputStream();
            props.load(is);
            is.close();
        }
        catch (Exception ex) {
            System.err.println("Cannot read properties file: " + propURI);
            FileUtil.safeClose(is);
            return props;
        }
        return props;
    }

    private static String getGeneralProperty(String key, String defaultValue, Properties serverProp, Properties localProp, boolean storeInLocalPref, boolean serviceProperty) {
        String value = localProp.getProperty(key, null);
        String defaultVal = System.getProperty(key, null);
        if (defaultVal == null) {
            defaultVal = serverProp.getProperty(key, defaultValue);
        }
        if (value == null) {
            value = defaultVal;
            if (storeInLocalPref && value != null) {
                localProp.setProperty(key, value);
            }
        }
        if (serviceProperty) {
            serverProp.setProperty(key, value);
            serverProp.setProperty("def." + key, defaultVal);
        }
        System.out.println(key + ": " + value);
        return value;
    }

    public static void setSystemSpecification() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName != null && !osName.trim().equals("") && osArch != null && !osArch.trim().equals("")) {
            osName = osName.toLowerCase().startsWith("win") ? "windows" : (osName.equals("Mac OS X") ? "macosx" : (osName.equals("SymbianOS") ? "epoc32" : (osName.equals("hp-ux") ? "hpux" : (osName.equals("Mac OS") ? "macos" : (osName.equals("OS/2") ? "os2" : (osName.equals("procnto") ? "qnx" : osName.toLowerCase()))))));
            osArch = osArch.equals("pentium") || osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686") ? "x86" : (osArch.equals("amd64") || osArch.equals("em64t") || osArch.equals("x86_64") ? "x86-64" : (osArch.equals("power ppc") ? "powerpc" : (osArch.equals("psc1k") ? "ignite" : osArch.toLowerCase())));
            System.setProperty("native.library.spec", osName + "-" + osArch);
        }
    }

    public static WeasisLoader loadProperties(Properties s_prop) {
        String nativeLook;
        Locale locale;
        String portable;
        ServiceLoader<RemotePreferences> prefs;
        Iterator<RemotePreferences> commandsIterator;
        boolean localSessionUser;
        System.out.println("Operating system: " + System.getProperty("native.library.spec"));
        String dir = new File(s_prop.getProperty("org.osgi.framework.storage")).getParent();
        System.setProperty(P_WEASIS_PATH, dir);
        String weasisName = s_prop.getProperty(P_WEASIS_NAME, "Weasis");
        System.setProperty(P_WEASIS_NAME, weasisName);
        String profileName = s_prop.getProperty(P_WEASIS_PROFILE, "default");
        System.setProperty(P_WEASIS_PROFILE, profileName);
        String user = System.getProperty("weasis.user", null);
        boolean bl = localSessionUser = user == null;
        if (user == null) {
            user = System.getProperty("user.name", "local");
        }
        System.setProperty("weasis.user", user);
        StringBuilder bufDir = new StringBuilder(dir);
        bufDir.append(File.separator);
        bufDir.append("preferences");
        bufDir.append(File.separator);
        bufDir.append(user);
        bufDir.append(File.separator);
        bufDir.append(profileName);
        prefDir = new File(bufDir.toString());
        try {
            prefDir.mkdirs();
        }
        catch (Exception e) {
            prefDir = new File(dir);
            e.printStackTrace();
        }
        System.out.println("Preferences directory: " + prefDir.getPath());
        if (REMOTE_PREFS == null && user != null && (commandsIterator = (prefs = ServiceLoader.load(RemotePreferences.class)).iterator()).hasNext()) {
            REMOTE_PREFS = commandsIterator.next();
            REMOTE_PREFS.initialize(user, localSessionUser, profileName, bufDir.toString());
            System.out.println("Loading remote preferences for : " + user);
        }
        if (REMOTE_PREFS != null) {
            try {
                REMOTE_PREFS.read();
            }
            catch (Exception e) {
                System.out.println("Cannot read preferences remotely: " + e.getMessage());
            }
        }
        if ((portable = System.getProperty("weasis.portable.dir")) != null) {
            System.out.println("Starting portable version");
            System.setProperty("weasis.portable.dicom.directory", s_prop.getProperty("weasis.portable.dicom.directory"));
        }
        File profileProps = new File(prefDir, APP_PROPERTY_FILE);
        Properties lProp = WeasisLauncher.readProperties(profileProps);
        String lang = WeasisLauncher.getGeneralProperty("locale.lang.code", "en", s_prop, lProp, true, false);
        WeasisLauncher.getGeneralProperty("locale.format.code", "system", s_prop, lProp, true, false);
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.level", "INFO", s_prop, lProp, true, true);
        String logActivatation = WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.file.activate", "false", s_prop, lProp, true, true);
        if ("true".equalsIgnoreCase(logActivatation)) {
            String logFile = dir + File.separator + "log" + File.separator + "default.log";
            s_prop.setProperty("org.apache.sling.commons.log.file", logFile);
            lProp.remove("org.apache.sling.commons.log.file");
        }
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.file.number", "5", s_prop, lProp, true, true);
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.file.size", "10MB", s_prop, lProp, true, true);
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.stack.limit", "3", s_prop, lProp, true, true);
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.pattern", "{0,date,dd.MM.yyyy HH:mm:ss.SSS} *{4}* [{2}] {3}: {5}", s_prop, lProp, false, true);
        URI translationModules = null;
        if (portable != null) {
            File file = new File(portable, "weasis/bundle-i18n/buildNumber.properties");
            if (file.canRead()) {
                translationModules = file.toURI();
                String path = file.getParentFile().toURI().toString();
                System.setProperty("weasis.i18n", path);
                System.out.println("i18n path: " + path);
            }
        } else {
            String path = System.getProperty("weasis.i18n", null);
            if (path != null) {
                path = path + (path.endsWith("/") ? "buildNumber.properties" : "/buildNumber.properties");
                try {
                    translationModules = new URI(path);
                }
                catch (URISyntaxException e) {
                    System.err.println("Cannot find translation modules: " + e);
                }
            }
        }
        if (translationModules != null && (modulesi18n = WeasisLauncher.readProperties(translationModules, null)) != null) {
            System.setProperty("weasis.languages", modulesi18n.getProperty("languages", ""));
        }
        if (Locale.ENGLISH.equals(locale = WeasisLauncher.textToLocale(lang))) {
            modulesi18n = null;
        } else {
            String suffix = locale.toString();
            SwingResources.loadResources("/swing/basic_" + suffix + ".properties");
            SwingResources.loadResources("/swing/synth_" + suffix + ".properties");
        }
        Locale.setDefault(locale);
        UIManager.getDefaults().setDefaultLocale(locale);
        JComponent.setDefaultLocale(locale);
        String sysSpec = System.getProperty("native.library.spec", "unknown");
        int index = sysSpec.indexOf("-");
        if (index > 0 && (look = System.getProperty(nativeLook = "weasis.look." + sysSpec.substring(0, index), null)) == null) {
            look = s_prop.getProperty(nativeLook, null);
        }
        if (look == null && (look = System.getProperty("weasis.look", null)) == null) {
            look = s_prop.getProperty("weasis.look", null);
        }
        String localLook = lProp.getProperty("weasis.look", null);
        if (LookAndFeels.installSubstanceLookAndFeels() && look == null) {
            look = "Mac OS X".equals(System.getProperty("os.name")) ? "com.apple.laf.AquaLookAndFeel" : "org.pushingpixels.substance.api.skin.SubstanceTwilightLookAndFeel";
        }
        if (look == null) {
            look = WeasisLauncher.getAvailableLookAndFeel(look);
        }
        s_prop.setProperty("weasis.look", look);
        if (localLook != null) {
            look = localLook;
        }
        WeasisFrame mainFrame = new WeasisFrame();
        try {
            SwingUtilities.invokeAndWait(() -> {
                boolean substance = look.startsWith("org.pushingpixels");
                if (substance) {
                    JFrame.setDefaultLookAndFeelDecorated(false);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                }
                look = WeasisLauncher.setLookAndFeel(look);
                Object instance = null;
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                try {
                    ObjectName objectName1 = ObjectName.getInstance("weasis:name=MainWindow");
                    instance = server.getAttribute(objectName1, "RootPaneContainer");
                    if (instance instanceof RootPaneContainer) {
                        mainFrame.setRootPaneContainer((RootPaneContainer)instance);
                    }
                }
                catch (InstanceNotFoundException e1) {
                }
                catch (Exception e1) {
                }
                finally {
                    try {
                        if (instance == null) {
                            ObjectName objectName2 = new ObjectName("weasis:name=MainWindow");
                            mainFrame.setRootPaneContainer(new JFrame());
                            server.registerMBean(mainFrame, objectName2);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            System.err.println("WARNING : Unable to set the Look&Feel " + look);
            e.printStackTrace();
        }
        lProp.put("weasis.look", look);
        System.out.println("weasis.look: " + look);
        File sourceID_props = new File(dir, System.getProperty("weasis.source.id") + ".properties");
        Properties localSourceProp = WeasisLauncher.readProperties(sourceID_props);
        String versionOld = localSourceProp.getProperty(P_WEASIS_VERSION);
        System.out.println("Last running version: " + versionOld);
        if (versionOld != null) {
            s_prop.setProperty("prev.weasis.version", versionOld);
        }
        String versionNew = s_prop.getProperty(P_WEASIS_VERSION);
        System.out.println("Current version: " + versionNew);
        String cleanCacheAfterCrash = localSourceProp.getProperty("weasis.clean.cache");
        boolean update = false;
        String resPath = s_prop.getProperty("weasis.resources.url", System.getProperty("weasis.codebase.url", "") + "/resources.zip");
        File cacheDir = null;
        try {
            String date;
            if (resPath.endsWith(".zip") && (date = FileUtil.writeResources(resPath, cacheDir = new File(dir + File.separator + "data" + File.separator + System.getProperty("weasis.source.id"), "resources"), localSourceProp.getProperty(P_WEASIS_RES_DATE))) != null) {
                update = true;
                localSourceProp.put(P_WEASIS_RES_DATE, date);
            }
        }
        catch (Exception e) {
            cacheDir = null;
            System.err.println(e.getMessage() + "\n");
        }
        if (cacheDir == null) {
            if (portable != null) {
                cacheDir = new File(portable, "weasis" + File.separator + "resources");
            } else {
                File f = new File(System.getProperty("user.dir"));
                cacheDir = new File(f.getParent(), "weasis-distributions" + File.separator + "resources");
            }
        }
        System.out.println("weasis.resources.path: " + cacheDir.getPath());
        s_prop.setProperty("weasis.resources.path", cacheDir.getPath());
        WeasisLoader loader = new WeasisLoader(cacheDir, mainFrame, lProp);
        loader.open();
        if (versionNew != null) {
            System.setProperty(P_WEASIS_VERSION, versionNew);
            localSourceProp.put(P_WEASIS_VERSION, versionNew);
            if (versionOld == null || !versionOld.equals(versionNew)) {
                update = true;
            }
        }
        FileUtil.storeProperties(profileProps, lProp, null);
        boolean cleanCache = Boolean.parseBoolean(s_prop.getProperty("weasis.clean.previous.version"));
        if (cleanCacheAfterCrash != null && "true".equals(cleanCacheAfterCrash)) {
            s_prop.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
            localSourceProp.remove("weasis.clean.cache");
            update = true;
            System.out.println("Clean plug-in cache because Weasis has crashed during the previous launch");
        } else if (cleanCache && versionNew != null && !versionNew.equals(versionOld)) {
            System.out.println(String.format("Clean previous Weasis version: %s", versionOld));
            s_prop.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
            System.out.println("Clean plug-in cache because the version has changed");
        }
        if (update) {
            FileUtil.storeProperties(sourceID_props, localSourceProp, null);
        }
        System.out.println("***** End of Configuration *****");
        return loader;
    }

    private static Properties readProperties(File propsFile) {
        Properties properties = new Properties();
        if (propsFile.canRead()) {
            try (FileInputStream fis2 = new FileInputStream(propsFile);){
                properties.load(fis2);
            }
            catch (Exception fis2) {}
        } else {
            File appFoler = new File(System.getProperty(P_WEASIS_PATH, ""));
            appFoler.mkdirs();
        }
        return properties;
    }

    public static String setLookAndFeel(String look) {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        UIManager.put("Slider.paintValue", Boolean.FALSE);
        String laf = WeasisLauncher.getAvailableLookAndFeel(look);
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println("WARNING : Unable to set the Look&Feel");
            laf = UIManager.getSystemLookAndFeelClassName();
        }
        LookAndFeels.setUIFont(new FontUIResource("SansSerif", 0, 12));
        return laf;
    }

    public static String getAvailableLookAndFeel(String look) {
        int i;
        int n;
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        String laf = null;
        if (look != null) {
            n = lafs.length;
            for (i = 0; i < n; ++i) {
                if (!lafs[i].getClassName().equals(look)) continue;
                laf = look;
                break;
            }
        }
        if (laf == null) {
            if ("Mac OS X".equals(System.getProperty("os.name"))) {
                laf = "com.apple.laf.AquaLookAndFeel";
            } else {
                n = lafs.length;
                for (i = 0; i < n; ++i) {
                    if (!lafs[i].getName().equals("Nimbus")) continue;
                    laf = lafs[i].getClassName();
                    break;
                }
            }
            if (laf == null) {
                laf = UIManager.getSystemLookAndFeelClassName();
            }
        }
        return laf;
    }

    public static Locale textToLocale(String value) {
        if (value == null || value.trim().equals("")) {
            return Locale.ENGLISH;
        }
        if ("system".equals(value)) {
            String language = System.getProperty("user.language", "en");
            String country = System.getProperty("user.country", "");
            String variant = System.getProperty("user.variant", "");
            return new Locale(language, country, variant);
        }
        String[] val = value.split("_", 3);
        String language = val.length > 0 ? val[0] : "";
        String country = val.length > 1 ? val[1] : "";
        String variant = val.length > 2 ? val[2] : "";
        return new Locale(language, country, variant);
    }

    private static void registerAdditionalShutdownHook() {
        try {
            Class.forName("sun.misc.Signal");
            Class.forName("sun.misc.SignalHandler");
            Signal.handle(new Signal("TERM"), new SignalHandler(){

                @Override
                public void handle(Signal arg0) {
                    WeasisLauncher.shutdownHook();
                }
            });
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cannot find sun.misc.Signal for shutdown hook exstension");
        }
    }

    private static void shutdownHook() {
        try {
            if (m_felix != null) {
                m_felix.stop();
                m_felix.waitForStop(30000L);
            }
        }
        catch (Exception ex) {
            System.err.println("Error stopping framework: " + ex);
        }
        finally {
            WeasisLauncher.cleanImageCache();
            Timer timer = new Timer();
            timer.schedule((TimerTask)new HaltTask(), 7000L);
        }
    }

    static void storeRemotePreferences() {
        if (REMOTE_PREFS != null) {
            try {
                REMOTE_PREFS.store();
                System.out.println("End of storing remote preferences.");
            }
            catch (Exception e) {
                System.out.println("Cannot store preferences remotely: " + e.getMessage());
            }
        }
    }

    static void cleanImageCache() {
        String dir = System.getProperty("weasis.tmp.dir");
        if (dir != null) {
            FileUtil.deleteDirectoryContents(new File(dir), 3, 0);
        }
    }

    private static class JVMShutdownHook
    extends Thread {
        private JVMShutdownHook() {
        }

        @Override
        public void run() {
            WeasisLauncher.shutdownHook();
        }
    }

    static class HaltTask
    extends TimerTask {
        HaltTask() {
        }

        @Override
        public void run() {
            System.out.println("Force to close the application");
            Runtime.getRuntime().halt(1);
        }
    }

    public static enum STATE {
        UNINSTALLED(1),
        INSTALLED(2),
        RESOLVED(4),
        STARTING(8),
        STOPPING(16),
        ACTIVE(32);

        private int state;

        private STATE(int state) {
            this.state = state;
        }

        public static String valueOf(int state) {
            for (STATE s : STATE.values()) {
                if (s.state != state) continue;
                return s.name();
            }
            return "UNKNOWN";
        }
    }
}

