/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.File;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;
import org.weasis.launcher.FileUtil;
import org.weasis.launcher.Messages;
import org.weasis.launcher.WeasisLauncher;
import org.weasis.launcher.WeasisLoader;

public class AutoProcessor {
    public static final String AUTO_DEPLOY_DIR_PROPERY = "felix.auto.deploy.dir";
    public static final String AUTO_DEPLOY_DIR_VALUE = "bundle";
    public static final String AUTO_DEPLOY_ACTION_PROPERY = "felix.auto.deploy.action";
    public static final String AUTO_DEPLOY_STARTLEVEL_PROPERY = "felix.auto.deploy.startlevel";
    public static final String AUTO_DEPLOY_INSTALL_VALUE = "install";
    public static final String AUTO_DEPLOY_START_VALUE = "start";
    public static final String AUTO_DEPLOY_UPDATE_VALUE = "update";
    public static final String AUTO_DEPLOY_UNINSTALL_VALUE = "uninstall";
    public static final String AUTO_INSTALL_PROP = "felix.auto.install";
    public static final String AUTO_START_PROP = "felix.auto.start";
    public static final String PACK200_COMPRESSION = ".pack.gz";

    public static void process(Map configMap, BundleContext context, WeasisLoader weasisLoader) {
        configMap = configMap == null ? new HashMap() : configMap;
        AutoProcessor.processAutoDeploy(configMap, context, weasisLoader);
        AutoProcessor.processAutoProperties(configMap, context, weasisLoader);
    }

    private static void processAutoDeploy(Map configMap, BundleContext context, WeasisLoader weasisLoader) {
        String action = (String)configMap.get(AUTO_DEPLOY_ACTION_PROPERY);
        action = action == null ? "" : action;
        ArrayList<String> actionList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(action, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim().toLowerCase();
            if (!s.equals(AUTO_DEPLOY_INSTALL_VALUE) && !s.equals(AUTO_DEPLOY_START_VALUE) && !s.equals(AUTO_DEPLOY_UPDATE_VALUE) && !s.equals(AUTO_DEPLOY_UNINSTALL_VALUE)) continue;
            actionList.add(s);
        }
        if (actionList.size() > 0) {
            Bundle b;
            int i;
            StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
            int startLevel = sl.getInitialBundleStartLevel();
            if (configMap.get(AUTO_DEPLOY_STARTLEVEL_PROPERY) != null) {
                try {
                    startLevel = Integer.parseInt(configMap.get(AUTO_DEPLOY_STARTLEVEL_PROPERY).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            HashMap<String, Bundle> installedBundleMap = new HashMap<String, Bundle>();
            Bundle[] bundles = context.getBundles();
            for (int i2 = 0; i2 < bundles.length; ++i2) {
                installedBundleMap.put(bundles[i2].getLocation(), bundles[i2]);
            }
            String autoDir = (String)configMap.get(AUTO_DEPLOY_DIR_PROPERY);
            autoDir = autoDir == null ? AUTO_DEPLOY_DIR_VALUE : autoDir;
            Object[] files = new File(autoDir).listFiles();
            ArrayList<Object> jarList = new ArrayList<Object>();
            if (files != null) {
                Arrays.sort(files);
                for (int i3 = 0; i3 < files.length; ++i3) {
                    if (!((File)files[i3]).getName().endsWith(".jar")) continue;
                    jarList.add(files[i3]);
                }
            }
            weasisLoader.setMax(jarList.size());
            ArrayList<Bundle> startBundleList = new ArrayList<Bundle>();
            for (i = 0; i < jarList.size(); ++i) {
                File jar = (File)jarList.get(i);
                b = (Bundle)installedBundleMap.remove(jar.toURI().toString());
                try {
                    weasisLoader.writeLabel(WeasisLoader.LBL_DOWNLOADING + " " + jar.getName());
                    if (b == null && actionList.contains(AUTO_DEPLOY_INSTALL_VALUE)) {
                        b = AutoProcessor.installBundle(context, ((File)jarList.get(i)).toURI().toString());
                    } else if (b != null && actionList.contains(AUTO_DEPLOY_UPDATE_VALUE)) {
                        b.update();
                    }
                    if (b == null) continue;
                    weasisLoader.setValue(i + 1);
                    if (AutoProcessor.isFragment(b)) continue;
                    startBundleList.add(b);
                    sl.setBundleStartLevel(b, startLevel);
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("Auto-deploy install: " + ex + (ex.getCause() != null ? " - " + ex.getCause() : ""));
                }
            }
            if (actionList.contains(AUTO_DEPLOY_UNINSTALL_VALUE)) {
                for (Map.Entry entry : installedBundleMap.entrySet()) {
                    b = (Bundle)entry.getValue();
                    if (b.getBundleId() == 0L) continue;
                    try {
                        b.uninstall();
                    }
                    catch (BundleException ex) {
                        AutoProcessor.printError((Exception)((Object)ex), "Auto-deploy uninstall: ");
                    }
                }
            }
            if (actionList.contains(AUTO_DEPLOY_START_VALUE)) {
                for (i = 0; i < startBundleList.size(); ++i) {
                    try {
                        ((Bundle)startBundleList.get(i)).start();
                        continue;
                    }
                    catch (BundleException ex) {
                        AutoProcessor.printError((Exception)((Object)ex), "Auto-deploy start: ");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAutoProperties(Map configMap, BundleContext context, WeasisLoader weasisLoader) {
        BundleElement bundle;
        String bundleName;
        BundleElement b;
        StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
        HashMap<String, BundleElement> bundleList = new HashMap<String, BundleElement>();
        Set set = configMap.keySet();
        Iterator item = set.iterator();
        while (item.hasNext()) {
            String key = ((String)item.next()).toLowerCase();
            if (!key.startsWith(AUTO_INSTALL_PROP) && !key.startsWith(AUTO_START_PROP)) continue;
            int startLevel = sl.getInitialBundleStartLevel();
            try {
                startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
            }
            catch (NumberFormatException ex) {
                System.err.println("Invalid start level: " + key);
            }
            boolean canBeStarted = key.startsWith(AUTO_START_PROP);
            StringTokenizer st = new StringTokenizer((String)configMap.get(key), "\" ", true);
            String location = AutoProcessor.nextLocation(st);
            while (location != null) {
                String bundleName2 = AutoProcessor.getBundleNameFromLocation(location);
                if (!"System Bundle".equals(bundleName2)) {
                    b = new BundleElement(startLevel, location, canBeStarted);
                    bundleList.put(bundleName2, b);
                }
                location = AutoProcessor.nextLocation(st);
            }
        }
        weasisLoader.setMax(bundleList.size());
        HashMap<String, Bundle> installedBundleMap = new HashMap<String, Bundle>();
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            String bundleName3 = AutoProcessor.getBundleNameFromLocation(bundles[i].getLocation());
            if (bundleName3 == null) continue;
            try {
                BundleElement b2 = (BundleElement)bundleList.get(bundleName3);
                if (b2 == null) {
                    if ("System Bundle".equals(bundleName3)) continue;
                    bundles[i].uninstall();
                    System.out.println("Uninstall not used: " + bundleName3);
                    continue;
                }
                if (bundles[i].getVersion().getQualifier().endsWith("SNAPSHOT")) {
                    bundles[i].uninstall();
                    System.out.println("Uninstall SNAPSHOT: " + bundleName3);
                    continue;
                }
                installedBundleMap.put(bundleName3, bundles[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Cannot remove from OSGI cache: " + bundleName3);
            }
        }
        int bundleIter = 0;
        for (Map.Entry element : bundleList.entrySet()) {
            bundleName = (String)element.getKey();
            bundle = (BundleElement)element.getValue();
            if (bundle == null) continue;
            try {
                weasisLoader.writeLabel(WeasisLoader.LBL_DOWNLOADING + " " + bundleName);
                b = (Bundle)installedBundleMap.get(bundleName);
                if (b == null) {
                    b = AutoProcessor.installBundle(context, bundle.getLocation());
                    installedBundleMap.put(bundleName, (Bundle)b);
                }
                sl.setBundleStartLevel((Bundle)b, bundle.getStartLevel());
                AutoProcessor.loadTranslationBundle(context, (Bundle)b, installedBundleMap);
            }
            catch (Exception ex) {
                if (bundleName.contains(System.getProperty("native.library.spec"))) {
                    System.err.println("Cannot install native bundle: " + bundleName);
                    continue;
                }
                AutoProcessor.printError(ex, "Cannot install bundle: " + bundleName);
                if (ex.getCause() == null) continue;
                ex.printStackTrace();
            }
            finally {
                weasisLoader.setValue(++bundleIter);
            }
        }
        weasisLoader.writeLabel(Messages.getString("AutoProcessor.start"));
        for (Map.Entry element : bundleList.entrySet()) {
            bundleName = (String)element.getKey();
            bundle = (BundleElement)element.getValue();
            if (bundle == null || !bundle.isCanBeStarted()) continue;
            try {
                b = (Bundle)installedBundleMap.get(bundleName);
                if (b == null) {
                    b = AutoProcessor.installBundle(context, bundle.getLocation());
                }
                if (b == null) continue;
                b.start();
            }
            catch (Exception ex) {
                AutoProcessor.printError(ex, "Cannot start bundle: " + bundleName);
            }
        }
    }

    private static String getBundleNameFromLocation(String location) {
        if (location != null) {
            int index = location.lastIndexOf("/");
            String name = index >= 0 ? location.substring(index + 1) : location;
            index = name.lastIndexOf(".jar");
            return index >= 0 ? name.substring(0, index) : name;
        }
        return null;
    }

    private static void loadTranslationBundle(BundleContext context, Bundle b, Map<String, Bundle> installedBundleMap) {
        if (WeasisLauncher.modulesi18n != null && b != null) {
            String baseURL;
            StringBuilder p = new StringBuilder(b.getSymbolicName());
            p.append("-i18n-");
            p.append("2.0.0");
            p.append(".jar");
            String filename = p.toString();
            String value = WeasisLauncher.modulesi18n.getProperty(filename);
            if (value != null && (baseURL = System.getProperty("weasis.i18n")) != null) {
                String uri = baseURL + (baseURL.endsWith("/") ? filename : "/" + filename);
                String bundleName = AutoProcessor.getBundleNameFromLocation(filename);
                try {
                    Bundle b2 = installedBundleMap.get(bundleName);
                    if (b2 == null) {
                        b2 = context.installBundle(uri, FileUtil.getAdaptedConnection(new URI(uri).toURL()).getInputStream());
                        installedBundleMap.put(bundleName, b);
                    }
                    if (b2 != null && !value.equals(b2.getVersion().getQualifier())) {
                        if (b2.getLocation().startsWith(baseURL)) {
                            b2.update();
                        } else {
                            try {
                                b2.uninstall();
                                context.installBundle(uri, FileUtil.getAdaptedConnection(new URI(uri).toURL()).getInputStream());
                                installedBundleMap.put(bundleName, b);
                            }
                            catch (Exception exc) {
                                System.err.println("Cannot install translation pack: " + uri);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Cannot install translation pack: " + uri);
                }
            }
        }
    }

    private static void printError(Exception ex, String prefix) {
        System.err.println(prefix + " (" + ex + (ex.getCause() != null ? " - " + ex.getCause() : "") + ")");
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuilder tokBuf = new StringBuilder(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuilder(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }

    private static Bundle installBundle(BundleContext context, String location) throws Exception {
        boolean pack = location.endsWith(PACK200_COMPRESSION);
        if (pack) {
            boolean bl = pack = context.getBundle(location = location.substring(0, location.length() - 8)) == null;
        }
        if (pack) {
            URL url = new URL(location + PACK200_COMPRESSION);
            PipedInputStream in = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(in);
            new Thread(() -> {
                JarOutputStream jarStream = null;
                try {
                    InputStream is = FileUtil.getAdaptedConnection(url).getInputStream();
                    Pack200.Unpacker unpacker = Pack200.newUnpacker();
                    jarStream = new JarOutputStream(out);
                    unpacker.unpack((InputStream)new GZIPInputStream(is), jarStream);
                }
                catch (Exception e1) {
                    try {
                        System.err.println("Cannot install pack bundle: " + url);
                        e1.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        FileUtil.safeClose(jarStream);
                        throw throwable;
                    }
                    FileUtil.safeClose(jarStream);
                }
                FileUtil.safeClose(jarStream);
            }).start();
            return context.installBundle(location, (InputStream)in);
        }
        return context.installBundle(location, FileUtil.getAdaptedConnection(new URI(location).toURL()).getInputStream());
    }

    static class BundleElement {
        private final int startLevel;
        private final String location;
        private final boolean canBeStarted;

        public BundleElement(int startLevel, String location, boolean canBeStarted) {
            this.startLevel = startLevel;
            this.location = location;
            this.canBeStarted = canBeStarted;
        }

        public int getStartLevel() {
            return this.startLevel;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isCanBeStarted() {
            return this.canBeStarted;
        }
    }
}

