const fresca = {
    initialized: false,
    init(aspecte) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        const dom = {
            mainTable: document.getElementById("main"),
            headerTable: document.getElementById("header"),
            domRows: null,
            rows: [],
            cells: [],
            headers: [],
            $details: document.getElementById("details"),
            $l1quote: document.getElementById("level1-quote"),
            $l1author: document.getElementById("level1-author"),
            $l1aspect: document.getElementById("level1-aspect"),
            $l2quote: document.getElementById("level2-quote"),
            $l2author: document.getElementById("level2-author"),
            $l2aspect: document.getElementById("level2-aspect"),
            $backdrop: document.getElementById("backdrop"),
            $detailsContainer: document.getElementById("details-container"),
            init() {
                this.headerTable.innerHTML = this.mainTable.firstElementChild.outerHTML;
                this.mainTable.firstElementChild.classList.add("hidden");
                this.domRows = this.mainTable.rows;
                let tableHeaderCells = this.headerTable.rows[0].cells;
                for (let i=0; i<tableHeaderCells.length; i++) {
                    this.headers.push(tableHeaderCells[i]);
                }
                for (let i=0; i<this.domRows.length; i++) {
                    let rowCells = this.domRows[i].cells;
                    let row = [];
                    let cellLength = rowCells.length;
                    if (cellLength > 1) {
                        if (i === 0) {
                            for (let j = 0; j<cellLength; j++) {
                                this.cells.push([]);
                            }
                        }
                        for (let j = 0; j<cellLength; j++) {
                            let cell = rowCells[j];
                            this.cells[j].push(cell);
                            row.push(cell);
                        }
                        this.rows.push(row);
                    }
                }
            }
        };

        dom.init();

        const util = {
            isInViewport(element) {
                let width = element.offsetWidth;
                let height = element.offsetHeight;
                const rect = element.getBoundingClientRect();
                return (
                    rect.top >= -height &&
                    rect.left >= -width &&
                    rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) + width &&
                    rect.right <= (window.innerWidth || document.documentElement.clientWidth) + height
                );
            },
            visibleRange(cells, startIndex) {
                let cellCount = cells.length;
                let from = -1, to = -1;
                for (let i = startIndex; i < cellCount; i++) {
                    if (util.isInViewport(cells[i])) {
                        to = i;
                    }
                }
                for (let i = startIndex; i >= 0; i--) {
                    if (util.isInViewport(cells[i])) {
                        from = i;
                    }
                }
                return {from: from, to: to};
            },
            headerHeight: dom.headerTable.offsetHeight,
            scrollIntoView(e) {
                e.scrollIntoView({behavior: "instant"});
                if (e.getBoundingClientRect().top <= this.headerHeight) {
                    window.scrollTo(window.scrollX, window.scrollY - this.headerHeight);
                }
            },
            arrayDOMFind(collection, property, value) {
                let valueString = String(value);
                for (let i = 0, len = collection.length; i < len; i++) {
                    let propertyAttribute = collection[i].attributes.getNamedItem(property);
                    if (propertyAttribute !== null && propertyAttribute.nodeValue === valueString) {
                        return i;
                    }
                }
                return -1;
            },
            loaderIdx: -1,
            loader(underlyingRequestCount = 1) {
                let idx = ++this.loaderIdx;
                return {
                    markup: "<div class=\"lds-ring\"><div></div><div></div><div></div><div></div><span id=\"loader-progress-" + idx + "\"></span></div>",
                    element: null,
                    progress(text) {
                        if (this.element === null) {
                            this.element = document.getElementById("loader-progress-" + idx);
                        }
                        if (this.element) {
                            this.element.innerText = text;
                        }
                    },
                    createProgressCallbackHandler() {
                        let stateByRequestId = {};
                        return (progressInfo) => {
                            if (window.globalTransportDebug) {
                                console.log(JSON.stringify(progressInfo));
                            }
                            stateByRequestId["" + progressInfo.requestId] = progressInfo;
                            if (Object.keys(stateByRequestId).length === underlyingRequestCount) {
                                let loaded = 0, total = 0, nrWithTotal = 0;
                                Object.keys(stateByRequestId).forEach(key => {
                                    let pi = stateByRequestId[key];
                                    if (pi.total > 0) {
                                        nrWithTotal++;
                                    }
                                    loaded += pi.loaded;
                                    total += pi.total;
                                });
                                if (nrWithTotal === underlyingRequestCount) {
                                    let ratio = total > 0 ? Math.floor(loaded * 100 / total) : 0;
                                    this.progress(ratio + "%");
                                }
                            }
                        };
                    }

                }
            }
        }

        let dataAcquisition = {
            requestIdx: 0,
            transportIdx: 0,
            activeTransportsByURL: {},
            cacheByURL: {
                cache: {},
                set(url, data, size) {
                    this.cache[url] = {data: data, size: size};
                },
                get(url) {
                    return this.has(url) ? this.cache[url].data : null;
                },
                size(url) {
                    return this.has(url) ? this.cache[url].size : -1;
                },
                has(url) {
                    if (this.cache[url]) {
                        return true;
                    } else {
                        return false;
                    }
                }
            },
            get(url, progressMonitor, callback) {
                const req = new XMLHttpRequest();
                req.addEventListener("load", (event) => {
                    if (req.status === 200) {
                        callback(JSON.parse(req.responseText), req);
                    } else {
                        callback(null, req);
                    }
                });
                req.addEventListener("error", (event) => {
                    callback(null, req);
                });
                ["loadstart", "load", "loadend", "progress", "error", "abort"].forEach(eventType => {
                    req.addEventListener(eventType, event => {
                        let f = progressMonitor[eventType];
                        if (typeof f === "function") {
                            f(event);
                        }
                    });
                });
                req.open("GET", url, true);
                req.send();
                return req;
            },
            acquire(endpoint, url, progressCallback, callback) {
                let requestId = this.requestIdx++;
                if (this.cacheByURL.has(url)) {
                    if (callback) {
                        callback(this.cacheByURL.get(url));
                    }
                    if (progressCallback) {
                        let size = this.cacheByURL.size(url);
                        progressCallback({ ratio: 1, loaded: size, total: size, transportId: -1, requestId: requestId });
                    }
                    return {result: this.cacheByURL.get(url), cached: true, complete: true, abort() {}, abortIfIncomplete() {}, requestId: requestId};
                } else {
                    let request = {
                        requestId: requestId,
                        transport: null,
                        requestTimestamp: new Date().getTime(),
                        cached: false,
                        aborted: false,
                        completed: false,
                        callback: callback,
                        progressCallback: progressCallback,
                        abort() {
                            this.aborted = true;
                            if (this.transport) {
                                this.transport.removeRequest(this);
                                this.transport = null;
                            }
                        },
                        abortIfIncomplete() {
                            if (!this.completed) {
                                this.abort();
                            }
                        },
                        progress(progressInfo) {
                            if (!this.aborted) {
                                if (typeof this.progressCallback === "function") {
                                    let p = Object.assign({}, progressInfo);
                                    p.requestId = this.requestId;
                                    this.progressCallback(p);
                                }
                            }
                        },
                        complete(data) {
                            this.completed = true;
                            if (this.transport) {
                                this.transport = null;
                                if (!this.aborted) {
                                    if (typeof this.callback === "function") {
                                        this.callback(data);
                                    }
                                }
                            }
                        }
                    };

                    // now choose transport for request

                    let transport = null;

                    if (window.globalTransportDebug) {
                        window.globalDataAcquisition = this;
                    }

                    if (this.activeTransportsByURL[url]) {
                        let existingTransports = Object.values(this.activeTransportsByURL[url]).filter(r => !r.aborted);
                        for (let i=0; i<existingTransports.length; i++) {
                            let existingTransport = existingTransports[i];
                            if (!existingTransport.aborted && Math.abs(new Date().getTime() - existingTransport.lastActiveTimestamp) < 10000) { // less than 10 seconds since something happened, join this transport
                                transport = existingTransport;
                            }
                        }
                    }

                    let parent = this;

                    if (transport === null) {
                        // we need a new transport
                        transport = {
                            transportId: this.transportIdx++,
                            transportTimestamp: new Date().getTime(),
                            lastActiveTimestamp: new Date().getTime(),
                            aborted: false,
                            completed: false,
                            requests: {},
                            xhr: null,
                            lastProgressEvent: null,
                            removeTransport() {
                                let transports = parent.activeTransportsByURL[url];
                                if (transports) {
                                    delete transports["T" + this.transportId]
                                    if (Object.keys(transports).length === 0) {
                                        delete parent.activeTransportsByURL[url];
                                    }
                                    Object.values(this.requests).forEach(request => {
                                        request.transport = null;
                                    });
                                }
                            },
                            abort() {
                                if (!this.completed) {
                                    if (window.globalTransportDebug) {
                                        console.log("Aborting transport " + this.transportId);
                                    }
                                    this.aborted = true;
                                    try {
                                        this.xhr.abort();
                                    } catch (e) {
                                    }
                                    this.removeTransport();
                                }
                            },
                            complete(data) {
                                this.completed = true;
                                Object.values(this.requests).forEach(r => {
                                    r.complete(data);
                                })
                                this.removeTransport();
                            },
                            abortIfUnused() {
                                if (!this.aborted && Object.keys(this.requests).length === 0) {
                                    this.abort();
                                }
                            },
                            unusedTimeout: null,
                            addRequest(request) {
                                let key = "R" + request.requestId;
                                if (this.requests[key]) {
                                } else {
                                    this.requests[key] = request;
                                    request.transport = this;
                                    if (this.unusedTimeout) {
                                        clearTimeout(this.unusedTimeout);
                                    }
                                    if (typeof request.progress === "function" && this.lastProgressEvent) {
                                        request.progress(this.lastProgressEvent.info);
                                    }
                                }
                            },
                            removeRequest(request) {
                                let key = "R" + request.requestId;
                                if (this.requests[key]) {
                                    this.requests[key].transport = null;
                                    delete this.requests[key];
                                }
                                if (this.unusedTimeout) {
                                    clearTimeout(this.unusedTimeout);
                                }
                                this.unusedTimeout = setTimeout(() => { this.abortIfUnused(); }, 5000);
                            }
                        }

                        let getProgressInfo = (xhrEvent) => {
                            let contentLength = xhrEvent.target.getResponseHeader("X-Content-Length") || xhrEvent.target.getResponseHeader("Content-Length");
                            if (contentLength) {
                                let numericContentLength = parseInt(contentLength);
                                let completionRatio = xhrEvent.loaded / numericContentLength;
                                return { ratio: completionRatio, loaded: xhrEvent.loaded, total: numericContentLength, transportId: transport.transportId };
                            } else {
                                return null;
                            }
                        }

                        transport.addRequest(request);

                        transport.xhr = this.get(
                            url,
                            {
                                loadstart(event) {
                                    transport.lastActiveTimestamp = new Date().getTime();
                                    if (!transport.aborted) {
                                        let progressInfo = { ratio: 0, loaded: 0, total: 0, transportId: transport.transportId };
                                        if (progressInfo) {
                                            transport.lastProgressEvent = {name: "loadstart", info: progressInfo};
                                            Object.values(transport.requests).forEach(r => {
                                                r.progress(progressInfo);
                                            });
                                        }
                                    }
                                },
                                load(event) {
                                    transport.lastActiveTimestamp = new Date().getTime();
                                    if (!transport.aborted) {
                                        let progressInfo = getProgressInfo(event);
                                        if (progressInfo) {
                                            transport.lastProgressEvent = {name: "load", info: progressInfo};
                                            Object.values(transport.requests).forEach(r => {
                                                r.progress(progressInfo);
                                            });
                                        }
                                    }
                                },
                                loadend(event) {
                                    transport.lastActiveTimestamp = new Date().getTime();
                                    if (!transport.aborted) {
                                        let progressInfo = getProgressInfo(event);
                                        if (progressInfo) {
                                            transport.lastProgressEvent = {name: "loadend", info: progressInfo};
                                            Object.values(transport.requests).forEach(r => {
                                                r.progress(progressInfo);
                                            });
                                        }
                                    }
                                },
                                progress(event) {
                                    transport.lastActiveTimestamp = new Date().getTime();
                                    if (!transport.aborted) {
                                        let progressInfo = getProgressInfo(event);
                                        transport.lastProgressEvent = {name: "progress", info: progressInfo};
                                        if (progressInfo) {
                                            Object.values(transport.requests).forEach(r => {
                                                r.progress(progressInfo);
                                            });
                                        }
                                    }
                                },
                                error(event) {
                                    transport.lastActiveTimestamp = new Date().getTime();
                                },
                                abort(event) {
                                    transport.lastActiveTimestamp = new Date().getTime();
                                }
                            },
                            (data, xhr) => {
                                if (!transport.aborted) {
                                    if (data) {
                                        let lengthHeader = xhr.getResponseHeader("X-Content-Length") || xhr.getResponseHeader("Content-Length");
                                        this.cacheByURL.set(url, data, lengthHeader !== null ? parseInt(lengthHeader) : 0);
                                    }
                                }
                                transport.complete(data);
                            }
                        );

                        if (this.activeTransportsByURL[url] === undefined) {
                            this.activeTransportsByURL[url] = {};
                        }
                        this.activeTransportsByURL[url]["T" + transport.transportId] = transport;

                    } else {

                        transport.addRequest(request)

                    }

                    return request;

                }

            }

        };

        let aspectProvider = {
            cache: {},
            get(aspectId, callback) {
                let key = "A" + aspectId, ret = null;
                if (this.cache[key]) {
                    ret = this.cache[key];
                } else {
                    for (let i = 0; i < aspecte.length; i++) {
                        if (aspecte[i].id === aspectId) {
                            ret = this.cache[key] = aspecte[i];
                            break;
                        }
                    }
                }
                if (callback) {
                    callback(ret);
                }
                return ret;
            }
        };

        let authorProvider = {
            get(authorId, progressCallback, callback) {
                return dataAcquisition.acquire("author", "/autor/" + authorId + "?deep=false", progressCallback, data => {
                    if (data && callback) {
                        callback(data);
                    }
                })
            }
        };

        let authorDeepProvider = {
            get(authorId, progressCallback, callback) {
                return dataAcquisition.acquire("author", "/autor/" + authorId + "?deep=true", progressCallback, data => {
                    if (data && callback) {
                        callback(data);
                    }
                })
            }
        };


        let l1Provider = {
            get(authorId, progressCallback, callback) {
                return dataAcquisition.acquire("author", "/autor/" + authorId + "/l1", progressCallback, data => {
                    if (data && callback) {
                        callback(data["" + authorId]);
                    }
                })
            }
        };

        let l2Provider = {
            get(authorId, progressCallback, callback) {
                return dataAcquisition.acquire("author", "/autor/" + authorId + "/l2", progressCallback, data => {
                    if (data && callback) {
                        callback(data["" + authorId]);
                    }
                })
            }
        };

        let l1Manager = {
            maximaQuotationManager: {
                renderQuote(author, aspect, lucrare, quote) {
                    return `
                    <div class="card rounded-3">
                        <div class="card-body p-1">
                            <figure class="mb-0">
                                <blockquote class="blockquote mb-4">
                                    <p>
                                        <span class="font-italic">${quote.continut}</span>
                                    </p>
                                </blockquote>
                                <figcaption class="blockquote-footer mb-0">
                                    <span>${author.prenume} ${author.nume}</span>, <cite>${lucrare.titlu}${lucrare.data ? ", " + lucrare.data : ""}</cite>
                                </figcaption>
                            </figure>
                        </div>
                    </div>
                    `;
                },
                renderFragments(author, aspect, lucrare, nrFragments) {
                    return `
                                <div class="row d-flex justify-content-center align-items-center">
                                    <div class="col col-lg-12 col-xl-8">
                                        <div class="card rounded-3">
                                            <div class="card-body p-1">
                                                <figure class="text-center mb-0">
                                                    <blockquote class="blockquote mb-4">
                                                        <p>
                                                            ${nrFragments} fragment${nrFragments !== 1 ? "e" : ""}
                                                        </p>
                                                    </blockquote>
                                                    <figcaption class="blockquote-footer mb-0">
                                                        <span>${author.prenume} ${author.nume}</span>, <cite>${lucrare.titlu}${lucrare.data ? ", " + lucrare.data : ""}</cite>
                                                    </figcaption>
                                                </figure>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                    `;
                },
                $carouselQuotes: null,
                authorDataRequest : null,
                l1DataRequest: null,
                loader: null,
                show(authorId, aspectId) {
                    this.loader = util.loader(2);
                    dom.$l1quote.innerHTML = this.loader.markup;
                    dom.$l1quote.style.display = "block";

                    aspectProvider.get(aspectId, aspect => {
                        let progressHandler = this.loader.createProgressCallbackHandler();
                        let handler = (author, l1) => {
                            if (l1) {
                                let sintezaAspect = l1.sinteza["" + aspectId];
                                let markup = "";
                                let markupQuotes = [];
                                let markupLucrari = [];
                                let numarTotalFragmente = 0;
                                Object.keys(sintezaAspect).forEach(lucrareId => {
                                    let lucrare = l1.lucrari[lucrareId];
                                    sintezaAspect[lucrareId].maxime.forEach(maxima => {
                                        markupQuotes.push(this.renderQuote(author, aspect, lucrare, maxima));
                                    });
                                    markupLucrari.push(this.renderFragments(author, aspect, lucrare, sintezaAspect[lucrareId].fragmente));
                                    numarTotalFragmente += sintezaAspect[lucrareId].fragmente;
                                });
                                // now decide what to render
                                let toRender = markupQuotes.length > 0 ? markupQuotes : markupLucrari;
                                let activeQuote = Math.floor(Math.random() * toRender.length);
                                markup += `
                                    <div class="row d-flex justify-content-center align-items-center">
                                        <div class="col col-lg-12 col-xl-12">
                                            <div class="card">
                                                <div class="card-body text-muted text-center">
                                                    ${markupLucrari.length > 1 ? `${markupLucrari.length} lucrări` : "O lucrare"}, ${numarTotalFragmente > 1 ? `în total ${numarTotalFragmente} fragmente` : "un singur fragment"}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br/>
                                `;
                                markup += `
                                    <div class="row d-flex justify-content-center align-items-center">
                                        <div class="col col-lg-12 col-xl-8">
                                            <div class="card">
                                                <div class="card-header text-muted text-center">`;
                                if (markupQuotes.length > 0) {
                                    if (toRender.length > 1) {
                                        markup += `Crîmpei <span id="currentQuote">${activeQuote + 1}</span> din ${toRender.length}`;
                                    } else {
                                        markup += `Crîmpei unic`;
                                    }
                                } else {
                                    if (toRender.length > 1) {
                                        markup += `${toRender.length} lucrări`;
                                    } else {
                                        markup += `Lucrare unică`;
                                    }
                                }
                                markup += `    
                                                </div>
                                                <div class="card-body">
                                                    <h5 class="card-title text-center">${aspect.cod} ${aspect.nume}</h5>
                                                    <div id="carouselQuotes" class="carousel slide">
                                                        <div class="carousel-inner">
                                    `;
                                toRender.forEach((markupQuote, i) => {
                                    markup += `            <div class="text-justify carousel-item${i === activeQuote ? " active" : ""}">${markupQuote}</div>`;
                                });
                                markup += `
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    `;
                                dom.$l1quote.innerHTML = markup;
                                let $carouselQuotes = this.$carouselQuotes = $("#carouselQuotes");
                                let $currentQuote = $("#currentQuote");
                                $carouselQuotes.carousel({interval: false});
                                $carouselQuotes.on('slid.bs.carousel', function () {
                                    let currentIndex = $(this).find('div.active').index() + 1;
                                    $currentQuote.html(currentIndex);
                                });
                            } else {
                                dom.$l1quote.innerHTML = "Eroare, vă rugăm să încercați mai târziu";
                            }
                        };
                        let requestResolver = {
                            author: null,
                            l1: null,
                            setAuthor(author) {
                                this.author = author;
                                this.checkAllSet();
                            },
                            setL1(l1) {
                                this.l1 = l1;
                                this.checkAllSet();
                            },
                            checkAllSet() {
                                if (this.author !== null && this.l1 !== null) {
                                    handler(this.author, this.l1);
                                }
                            }
                        };
                        this.authorDataRequest = authorProvider.get(authorId, progressHandler, author => { requestResolver.setAuthor(author); });
                        this.l1DataRequest = l1Provider.get(authorId, progressHandler, l1 => { requestResolver.setL1(l1); });
                    });
                },
                hide() {
                    if (this.authorDataRequest) {
                        this.authorDataRequest.abortIfIncomplete();
                    }
                    if (this.l1DataRequest) {
                        this.l1DataRequest.abortIfIncomplete();
                    }
                    if (this.$carouselQuotes) {
                        this.$carouselQuotes.carousel("dispose");
                    }
                }
            },
            authorQuotationManager: {
                render(author) {
                    let shortBio = "";
                    if (author.nastere) {
                        shortBio += author.nastere;
                    }
                    if (author.deces) {
                        if (author.nastere) {
                            shortBio += " - ";
                        }
                        shortBio += author.deces;
                    }

                    return `                            
                            <div class="row d-flex justify-content-center align-items-center h-100">
                                <div class="col col-lg-12 col-xl-8">
                                    <div class="card rounded-3">
                                        <div class="card-body p-1">
                                            <div class="d-flex justify-content-center mb-4">
                            ` +
                            (author.poza
                            ?
                            `
                                                <img src="${author.poza}" class="shadow-1-strong details-author-image" />
                            `
                            :
                            "")
                            + `
                                                
                                            </div>
                                            <figure class="text-center mb-0">
                                                <blockquote class="blockquote mb-4">
                                                    <p>
                                                        <span class="font-italic details-author-name">${author.prenume} ${author.nume}</span>
                                                    </p>
                                                </blockquote>
                                                <figcaption class="blockquote-footer mb-0">
                                                    <span class="details-author-bio">${shortBio}</span>
                                                </figcaption>
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    `;
                },
                dataRequest: null,
                loader: null,
                show(authorId) {
                    this.loader = util.loader();
                    dom.$l1author.innerHTML = this.loader.markup;
                    dom.$l1author.style.display = "block";
                    this.dataRequest = authorProvider.get(authorId, this.loader.createProgressCallbackHandler(), author => {
                        dom.$l1author.innerHTML = this.render(author);
                    });
                },
                hide() {
                    if (this.dataRequest) {
                        this.dataRequest.abortIfIncomplete();
                    }
                }
            },
            aspectQuotationManager: {
                render(aspect) {
                    return `
                            <div class="row d-flex justify-content-center align-items-center h-100">
                                <div class="col col-lg-12 col-xl-8">
                                    <div class="card rounded-3">
                                        <div class="card-body p-1">
                                            <figure class="text-center mb-0">
                                                <figcaption class="blockquote-footer mb-0">
                                                    <span class="details-aspect-short-description">${aspect.descriereScurta}</span>
                                                </figcaption>
                                            </figure>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    `;
                },
                show(aspectId) {
                    dom.$l1aspect.innerHTML = this.render(aspecte[aspectId]);
                    dom.$l1aspect.style.display = "block";
                },
                hide() {
                }
            },
            shownManager: null,
            show(column, row) {
                if (row === 0) {
                    (this.shownManager = this.aspectQuotationManager).show(aspecte[column - 1].id);
                } else {
                    let authorId = parseInt(dom.domRows[row].attributes.getNamedItem("data-author-id").nodeValue);
                    if (column === 0) {
                        (this.shownManager = this.authorQuotationManager).show(authorId);
                    } else {
                        (this.shownManager = this.maximaQuotationManager).show(authorId, aspecte[column - 1].id);
                    }
                }
                dom.$details.style.display = "block";
            },
            hide() {
                if (this.shownManager != null) {
                    this.shownManager.hide();
                }
                [dom.$details, dom.$l1quote, dom.$l1author, dom.$l1aspect, dom.$l2quote, dom.$l2author, dom.$l2aspect].forEach(node => node.style.display = "none");
            }
        };

        let highlightManager = {
            current: null,
            enabled: true,
            highlighter: {
                lastHighlightedRange: {from: -1, to: -1},
                highlightCells(cells) {
                    cells.forEach(c => c.classList.add("highlighted"));
                },
                unhighlightCells(cells) {
                    cells.forEach(c => c.classList.remove("highlighted"));
                },
                highlight(column, row) {
                    this.highlightCells(dom.rows[row]);
                    if (column > 0) {
                        this.highlightCells([dom.headers[column]]);
                        let visibleRow = row;
                        if (row === 0) { // header row, might not match visible row
                            let headerColumn = dom.headers[column];
                            let headerColumnRect = headerColumn.getBoundingClientRect();
                            let targetX = (headerColumnRect.left + headerColumnRect.right) / 2;
                            let targetY = headerColumnRect.bottom + 10;
                            document.elementsFromPoint(targetX, targetY).filter(e => e.tagName === "TD").forEach(e => {
                                visibleRow = e.parentNode.attributes.getNamedItem("data-row").value;
                            });
                        }
                        this.lastHighlightedRange = util.visibleRange(dom.cells[column], visibleRow);
                        this.highlightCells(dom.cells[column].slice(this.lastHighlightedRange.from, this.lastHighlightedRange.to + 1));
                    }
                },
                unhighlight(column, row) {
                    this.unhighlightCells([dom.headers[column]]);
                    this.unhighlightCells(dom.rows[row]);
                    if (this.lastHighlightedRange.from > -1) {
                        this.unhighlightCells(dom.cells[column].slice(this.lastHighlightedRange.from, this.lastHighlightedRange.to + 1));
                    }
                }
            },
            enter(row, column, showL1 = true) {
                let hasLeft = false;
                if (this.current != null && (this.current.row !== row || this.current.column !== column)) {
                    this.leave();
                    hasLeft = true;
                }
                if (dom.rows[row][column].textContent !== "") {
                    this.current = {row: row, column: column}
                    let lastHighlightedFrom = this.highlighter.lastHighlightedRange.from;
                    let lastHighlightedTo = this.highlighter.lastHighlightedRange.to;
                    this.highlighter.highlight(column, row);

                    if (this.highlighter.lastHighlightedRange.from !== -1 && !hasLeft) { // check if a resize may require unhighlighting previous cells
                        if (this.highlighter.lastHighlightedRange.from !== lastHighlightedFrom || this.highlighter.lastHighlightedRange.to !== lastHighlightedTo) {
                            this.highlighter.lastHighlightedRange = {from: lastHighlightedFrom, to: lastHighlightedTo};
                            this.highlighter.unhighlight(column, row);
                            this.highlighter.highlight(column, row);
                        }
                    }

                    if (showL1) {
                        l1Manager.show(column, row);
                    }
                }
            },
            in(row, column) {
                return this.current !== null && this.current.row === row && this.current.column === column;
            },
            leave() {
                if (this.enabled && this.current != null) {
                    this.highlighter.unhighlight(this.current.column, this.current.row);
                    l1Manager.hide();
                    this.current = null;
                }
            },
            enable() {
                this.enabled = true;
            },
            disable() {
                this.enabled = false;
            },
            isHighlighted() {
                return this.current !== null;
            }
        };

        let hoverListenerFactory = (mask) => {
            return (event) => {
                let target = event.target;
                if (!target.classList.contains("unhighlightable") && mask.indexOf(target.tagName) > -1 && target.textContent !== "") {
                    do {
                        let column = target.attributes.getNamedItem("data-column");
                        let row = target.parentNode.attributes.getNamedItem("data-row");
                        if (column != null && row != null) {
                            highlightManager.enter(
                                parseInt(row.value),
                                parseInt(column.value)
                            );
                            return;
                        }
                    } while ((target = target.parentNode) != null && target.tagName !== "BODY");
                }
            };
        };

        let prepareFragmentTitle = (content) => {
            content = content.replace(/\s*<!--((?!-->)[\s\S])*-->\s*/g, "").replace(/(<([^>]+)>)/ig, "").replace(/&nbsp;/ig, " ").replace(/^( |\n|\t|\[..]|\[...]|\[\+])+/ig, "").replace(/[ \n\t][ \n\t]+/ig, " ");
            if (content.length > 1024) {
                content = content.substring(0, 1024);
            }
            return content.trim();
        };

        let renderLucrare = (lucrare, fragmentRetriever, fragmentIds, aspectId) => {
            let markup = `
                        <div class="card bg-light">
                            <div class="card-header">
                                <h2 class="mb-0">
                                    <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#l${lucrare.id}">
                                        <span>${lucrare.titlu.trim()}</span> 
                                        <span class="badge badge-primary">${fragmentIds.length} fragment${fragmentIds.length !== 1 ? "e" : ""}</span>
                                    </button>
                                </h2>
                                <div class="info-lucrare">
                                    ${lucrare.data ? `<span class="data-lucrare">${lucrare.data}</span>` : ""}
                                    ${lucrare.publicatie ? `<span class="data-publicatie">${lucrare.publicatie}</span>` : ""}
                                </div>
                            </div>
                            <div id="l${lucrare.id}" class="collapse l-collapse" data-work-title="${l2Manager.urlManager.prepare(lucrare.titlu.trim())}" data-work-id="${lucrare.id}">
                                <div class="card-body">
                                    <div id="fragmentel${lucrare.id}" class="accordion">
            `;

            fragmentIds.forEach((idFragment, j) => {
                let fragment = fragmentRetriever(idFragment);
                let aspecteMarkup = "[";
                fragment.aspecte.forEach((id, k) => {
                    let isCurrentAspect = id === aspectId;
                    let fragmentAspect = aspectProvider.get(id);
                    aspecteMarkup += (k > 0 ? ", " : "") + (isCurrentAspect ? "<span class='active-aspect'>" + fragmentAspect.cod + " " + fragmentAspect.nume + "</span>" : fragmentAspect.cod + " " + fragmentAspect.nume);
                });
                aspecteMarkup += "]";
                let fragmentTitle = prepareFragmentTitle(fragment.continut);
                markup += `
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="mb-0">
                                        <button class="btn btn-link fragment collapsed" type="button" data-toggle="collapse" data-target="#l${lucrare.id}f${fragment.id}">
                                            ${fragmentTitle}
                                        </button>
                                    </h3>
                                    ${aspecteMarkup}
                                </div>
                                <div id="l${lucrare.id}f${fragment.id}" class="collapse f-collapse" data-work-title="${l2Manager.urlManager.prepare(lucrare.titlu.trim())}" data-work-id="${lucrare.id}" data-fragment-title="${l2Manager.urlManager.prepare(fragmentTitle)}" data-fragment-id="${fragment.id}">
                                    <div class="card-body">
                `;
                let content = fragment.continut;
                let detailedContent = fragment.continutDetaliat;
                let showToggle = false;
                let showContent = false;
                let showDetailedContent = false;
                if (detailedContent.length > 1.33 * content.length && (detailedContent.length - content.length) > 160) {
                    // there's a significant difference between long and short forms
                    showContent = true;
                    showToggle = true;
                } else if (detailedContent.trim() !== "") {
                    showDetailedContent = true;
                } else {
                    showContent = true;
                }
                if (showToggle) {
                    markup += `
                                <div class="shortening-toggle">
                                    <span class="mr-2">Mai scurt</span>
                                    <div class="custom-control custom-switch fragment-content-trigger">
                                        <input type="checkbox" class="custom-control-input" id="detailedSwitchl${lucrare.id}f${fragment.id}" onchange="if (this.checked) { document.getElementById('contentl${lucrare.id}f${fragment.id}').style.display = 'none'; document.getElementById('contentdl${lucrare.id}f${fragment.id}').style.display = 'unset'; } else { document.getElementById('contentl${lucrare.id}f${fragment.id}').style.display = 'unset'; document.getElementById('contentdl${lucrare.id}f${fragment.id}').style.display = 'none'; }"/>
                                        <label class="custom-control-label" for="detailedSwitchl${lucrare.id}f${fragment.id}">Mai lung</label>
                                    </div>
                                </div>
                    `;
                }
                markup += `
                                        <div class="fragment-content" id="contentl${lucrare.id}f${fragment.id}"${!showContent ? " style=\"display: none;\"" : ""}>
                                            ${fragment.continut}
                                        </div>
                                        <div class="fragment-detailed-content" id="contentdl${lucrare.id}f${fragment.id}"${!showDetailedContent ? " style=\"display: none;\"" : ""}>
                                            ${fragment.continutDetaliat}
                                        </div>
                                    </div>
                                </div>
                            </div>
                `;
            });

            markup += `
                                    </div>
                                </div>
                            </div>
                        </div>
            `;

            return markup;

        };

        let l2Manager = {
            urlManager: {
                disabled: false,
                load(url) {
                    let extractId = t => {
                        let parts = t.split("-");
                        if (parts.length > 2) {
                            if (!isNaN(parts[1])) {
                                return parseInt(parts[1]);
                            }
                        }
                        return null;
                    };
                    let extractParts = (hash) => {
                        let request = {};
                        hash.split("/").forEach(part => {
                            let id = extractId(part);
                            if (id) {
                                switch (part.substring(0, 1)) {
                                    case "a":
                                        request.author = id;
                                        break;
                                    case "t":
                                        request.aspect = id;
                                        break;
                                    case "l":
                                        request.work = id;
                                        break;
                                    case "f":
                                        request.fragment = id;
                                        break;
                                }
                            }
                        });
                        return request;
                    };
                    const hashIndex = url.indexOf("#");
                    if (hashIndex > -1 && !this.disabled) {
                        let request = extractParts(url.substring(hashIndex + 1));
                        if (Object.keys(request).length > 0) {
                            this.disabled = true;
                            let hasAuthor = typeof request.author === "number";
                            let hasAspect = typeof request.aspect === "number";
                            let hasWork = typeof request.work === "number";
                            let hasFragment = typeof request.fragment === "number";

                            if (hasAuthor && hasAspect && hasWork && hasFragment) {
                                let authorIndex = util.arrayDOMFind(dom.domRows, "data-author-id", request.author);
                                let aspectIndex = util.arrayDOMFind(dom.rows[0], "data-aspect-id", request.aspect);
                                if (authorIndex > -1 && aspectIndex > -1) {
                                    let node = dom.rows[authorIndex][aspectIndex];
                                    util.scrollIntoView(node);
                                    l2Manager.enter(authorIndex, aspectIndex, () => {
                                        $("#lucrariAutor").collapse("show");
                                        $("#l" + request.work).collapse("show");
                                        setTimeout(() => {
                                            $("#l" + request.work + "f" + request.fragment).collapse("show");
                                            util.scrollIntoView($("#l" + request.work + "f" + request.fragment).get(0).parentNode);
                                            setTimeout(() => {
                                                util.scrollIntoView($("#l" + request.work + "f" + request.fragment).get(0).parentNode);
                                                this.disabled = false;
                                            }, 500);
                                        }, 500);
                                    });
                                }
                            } else if (hasAuthor && hasAspect && hasWork) {
                                let authorIndex = util.arrayDOMFind(dom.domRows, "data-author-id", request.author);
                                let aspectIndex = util.arrayDOMFind(dom.rows[0], "data-aspect-id", request.aspect);
                                if (authorIndex > -1 && aspectIndex > -1) {
                                    let node = dom.rows[authorIndex][aspectIndex];
                                    util.scrollIntoView(node);
                                    l2Manager.enter(authorIndex, aspectIndex, () => {
                                        $("#lucrariAutor").collapse("show");
                                        $("#l" + request.work).collapse("show");
                                        util.scrollIntoView($("#l" + request.work).get(0).parentNode);
                                        setTimeout(() => {
                                            util.scrollIntoView($("#l" + request.work).get(0).parentNode);
                                            this.disabled = false;
                                        }, 500);
                                    });
                                }
                            } else if (hasAuthor && hasWork && hasFragment) {
                                let authorIndex = util.arrayDOMFind(dom.domRows, "data-author-id", request.author);
                                if (authorIndex > -1) {
                                    let authorRowNode = dom.rows[authorIndex][0];
                                    util.scrollIntoView(authorRowNode);
                                    l2Manager.enter(authorIndex, 0, () => {
                                        $("#lucrariAutor").collapse("show");
                                        $("#l" + request.work).collapse("show");
                                        setTimeout(() => {
                                            $("#l" + request.work + "f" + request.fragment).collapse("show");
                                            util.scrollIntoView($("#l" + request.work + "f" + request.fragment).get(0).parentNode);
                                            setTimeout(() => {
                                                util.scrollIntoView($("#l" + request.work + "f" + request.fragment).get(0).parentNode);
                                                this.disabled = false;
                                            }, 500);
                                        }, 500);
                                    });
                                }
                            } else if (hasAuthor && hasWork) {
                                let authorIndex = util.arrayDOMFind(dom.domRows, "data-author-id", request.author);
                                if (authorIndex > -1) {
                                    let authorRowNode = dom.rows[authorIndex][0];
                                    util.scrollIntoView(authorRowNode);
                                    l2Manager.enter(authorIndex, 0, () => {
                                        $("#lucrariAutor").collapse("show");
                                        $("#l" + request.work).collapse("show");
                                        util.scrollIntoView($("#l" + request.work).get(0).parentNode);
                                        setTimeout(() => {
                                            util.scrollIntoView($("#l" + request.work).get(0).parentNode);
                                            this.disabled = false;
                                        }, 500);
                                    });
                                }
                            } else if (hasAuthor && hasAspect) {
                                let authorIndex = util.arrayDOMFind(dom.domRows, "data-author-id", request.author);
                                let aspectIndex = util.arrayDOMFind(dom.rows[0], "data-aspect-id", request.aspect);
                                if (authorIndex > -1 && aspectIndex > -1) {
                                    let node = dom.rows[authorIndex][aspectIndex];
                                    util.scrollIntoView(node);
                                    l2Manager.enter(authorIndex, aspectIndex, () => { this.disabled = false; });
                                }
                            } else if (hasAuthor) {
                                let authorIndex = util.arrayDOMFind(dom.domRows, "data-author-id", request.author);
                                if (authorIndex > -1) {
                                    let authorRowNode = dom.rows[authorIndex][0];
                                    util.scrollIntoView(authorRowNode);
                                    l2Manager.enter(authorIndex, 0, () => { this.disabled = false; });
                                }
                            } else if (hasAspect) {
                                let aspectIndex = util.arrayDOMFind(dom.rows[0], "data-aspect-id", request.aspect);
                                if (aspectIndex > -1) {
                                    let aspectNode = dom.rows[0][aspectIndex];
                                    util.scrollIntoView(aspectNode);
                                    l2Manager.enter(0, aspectIndex, () => { this.disabled = false; });
                                }
                            } else {
                                this.disabled = false;
                            }
                        }
                    }
                },
                prepare(label) {
                    label = label
                        .toLowerCase()
                        .normalize("NFD").replace(/[\u0300-\u036f]/g, "")
                        .replace(/[^A-z0-9 ]/g, "")
                        .replace(/[ ]/g, "-");
                    if (label.length > 32) {
                        label = label.substring(0, 32);
                    }
                    return label;
                },
                navigateAspectLink(id, label) {
                    if (!this.disabled) {
                        this.disabled = true;
                        document.location.href = `#t-${id}-${this.prepare(label)}`;
                        setTimeout(() => {
                            this.disabled = false;
                        }, 0);
                    }
                },
                navigateAuthorLink(id, label) {
                    if (!this.disabled) {
                        this.disabled = true;
                        document.location.href = `#a-${id}-${this.prepare(label)}`;
                        setTimeout(() => {
                            this.disabled = false;
                        }, 0);
                    }
                },
                navigateNodeLink(authorId, authorLabel, aspectId, aspectLabel) {
                    if (!this.disabled) {
                        this.disabled = true;
                        document.location.href = `#a-${authorId}-${this.prepare(authorLabel)}/t-${aspectId}-${this.prepare(aspectLabel)}`;
                        setTimeout(() => {
                            this.disabled = false;
                        }, 0);
                    }
                },
                navigateAuthorWorkLink(authorId, authorLabel, workId, workLabel) {
                    if (!this.disabled) {
                        this.disabled = true;
                        document.location.href = `#a-${authorId}-${this.prepare(authorLabel)}/l-${workId}-${this.prepare(workLabel)}`;
                        setTimeout(() => {
                            this.disabled = false;
                        }, 0);
                    }
                },
                navigateAuthorWorkFragmentLink(authorId, authorLabel, workId, workLabel, fragmentId, fragmentLabel) {
                    if (!this.disabled) {
                        this.disabled = true;
                        document.location.href = `#a-${authorId}-${this.prepare(authorLabel)}/l-${workId}-${this.prepare(workLabel)}/f-${fragmentId}-${this.prepare(fragmentLabel)}`;
                        setTimeout(() => {
                            this.disabled = false;
                        }, 0);
                    }
                },
                navigateAuthorAspectWorkLink(authorId, authorLabel, aspectId, aspectLabel, workId, workLabel) {
                    if (!this.disabled) {
                        this.disabled = true;
                        document.location.href = `#a-${authorId}-${this.prepare(authorLabel)}/t-${aspectId}-${this.prepare(aspectLabel)}/l-${workId}-${this.prepare(workLabel)}`;
                        setTimeout(() => {
                            this.disabled = false;
                        }, 0);
                    }
                },
                navigateAuthorAspectWorkFragmentLink(authorId, authorLabel, aspectId, aspectLabel, workId, workLabel, fragmentId, fragmentLabel) {
                    if (!this.disabled) {
                        this.disabled = true;
                        document.location.href = `#a-${authorId}-${this.prepare(authorLabel)}/t-${aspectId}-${this.prepare(aspectLabel)}/l-${workId}-${this.prepare(workLabel)}/f-${fragmentId}-${this.prepare(fragmentLabel)}`;
                        setTimeout(() => {
                            this.disabled = false;
                        }, 0);
                    }
                },
                clearNavigation() {
                    this.disabled = true;
                    let scrollTop, scrollLeft, location = window.location;
                    if ("pushState" in history)
                        history.pushState("", document.title, location.pathname + location.search);
                    else {
                        scrollTop = document.body.scrollTop;
                        scrollLeft = document.body.scrollLeft;
                        location.hash = "";
                        document.body.scrollTop = scrollTop;
                        document.body.scrollLeft = scrollLeft;
                    }
                    setTimeout(() => {
                        this.disabled = false;
                    }, 0);
                }
            },
            aspectManager: {
                display(aspect, onComplete) {
                    let markup = l1Manager.aspectQuotationManager.render(aspect);
                    markup += `
                            <br/>
                            <div class="row d-flex justify-content-center align-items-center h-100">
                                <div class="col col-lg-12">
                                    <div class="card rounded-3">
                                        <div class="card-body p-1">
                                            ${aspect.descriereLunga}
                                        </div>
                                    </div>
                                </div>
                            </div>
                    `;
                    dom.$l2aspect.innerHTML = markup;
                    dom.$l2aspect.style.display = "block";
                    if (typeof onComplete === "function") {
                        onComplete();
                    }
                }
            },
            authorManager: {
                dataRequest: null,
                loader: null,
                display(author, onComplete) {
                    this.loader = util.loader();
                    var markup = "";
                    markup += `
                    ${l1Manager.authorQuotationManager.render(author)}
                    <br/>
                    <div id="autor" class="accordion">
                        <div class="card bg-light">
                            <div class="card-header">
                                <h2 class="mb-0">
                                    <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#lucrariAutor">
                                        <span>Explorare lucrări</span> 
                                        <span class="badge badge-primary">${author.lucrari.length} ${author.lucrari.length !== 1 ? "lucrări" : "lucrare"}</span>
                                    </button>
                                </h2>
                            </div>
                            <div id="lucrariAutor" class="collapse">
                                <div class="card-body">
                                    ${this.loader.markup}
                                </div>
                            </div>
                        </div>
                        <div class="card bg-light">
                            <div class="card-header">
                                <h2 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#biografieAutor">
                                        <span>Biografie</span> 
                                    </button>
                                </h2>
                            </div>
                            <div id="biografieAutor" class="collapse show">
                                <div class="card-body">
                                    ${author.biografieExplicativa}
                                    <table class="table table-bordered table-hover table-sm">
                                        <tbody>
                    `;
                    author.lucrari.forEach((lucrare, i) => {
                        if (i > 0) {
                            markup += "<tr><td colspan=\"2\"></td>";
                        }
                        markup += `
                                            <tr>
                                                <th>Titlu</th>
                                                <td>${lucrare.titlu}</td>
                                            </tr>
                                            <tr>
                                                <th>Publicație</th>
                                                <td>${lucrare.publicatie}</td>
                                            </tr>
                                            <tr>
                                                <th>Dată</th>
                                                <td>${lucrare.data}</td>
                                            </tr>
                                            <tr>
                                                <th>Sursă</th>
                                                <td>${lucrare.sursa.startsWith("http") ? `<a href="${lucrare.sursa}" target="_blank">${lucrare.sursa}</a>` : lucrare.sursa}</td>
                                            </tr>
                        `;
                    });
                    markup += `
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    `;
                    dom.$l2author.innerHTML = markup;
                    let $lucrariAutorContainer = $("#lucrariAutor .card-body").get(0);
                    this.dataRequest = authorDeepProvider.get(author.id, this.loader.createProgressCallbackHandler(), data => {
                        let markupLucrari = `
                            <div id="listaLucrariAutor" class="accordion">
                        `;
                        data.lucrari.forEach(lucrare => {
                            let fragmentMap = {};
                            lucrare.fragmente.forEach(fragment => {
                                fragmentMap["" + fragment.id] = fragment;
                            })
                            markupLucrari += renderLucrare(lucrare, idFragment => fragmentMap["" + idFragment], Object.keys(fragmentMap));
                        });
                        markupLucrari += `
                            </div>
                        `;
                        $lucrariAutorContainer.innerHTML = markupLucrari;
                        $(".l-collapse").on("show.bs.collapse", (ev) => {
                            l2Manager.urlManager.navigateAuthorWorkLink(
                                author.id,
                                author.prenume + " " + author.nume,
                                parseInt($(ev.target).attr("data-work-id")),
                                $(ev.target).attr("data-work-title")
                            );
                        });
                        $(".f-collapse").on("show.bs.collapse", (ev) => {
                            l2Manager.urlManager.navigateAuthorWorkFragmentLink(
                                author.id,
                                author.prenume + " " + author.nume,
                                parseInt($(ev.target).attr("data-work-id")),
                                $(ev.target).attr("data-work-title"),
                                parseInt($(ev.target).attr("data-fragment-id")),
                                $(ev.target).attr("data-fragment-title")
                            );
                            ev.stopPropagation();
                        });
                        if (typeof onComplete === "function") {
                            onComplete();
                        }
                    });
                }
            },
            dataRequest: null,
            l2DataRequest: null,
            loader: null,
            current: null,
            enter(row, column, onComplete) {
                let validDestination = dom.rows[row][column].textContent !== "";
                if (!validDestination) {
                    return;
                }
                l1Manager.hide();
                if (this.current != null && (this.current.row !== row || this.current.column !== column)) {
                    this.leave(true);
                }
                this.current = {row: row, column: column};
                highlightManager.enable();
                if (!highlightManager.in(row, column)) {
                    highlightManager.enter(row, column, false);
                }
                if (row === 0) {
                    let aspect = aspecte[column - 1];
                    this.urlManager.navigateAspectLink(aspect.id, aspect.nume);
                    this.aspectManager.display(aspect, onComplete);
                } else {
                    let authorId = parseInt(dom.domRows[row].attributes.getNamedItem("data-author-id").nodeValue);
                    let authorLabel = dom.rows[row][0].firstChild.nodeValue;
                    if (column === 0) {
                        this.loader = util.loader();
                        dom.$l2author.innerHTML = this.loader.markup;
                        dom.$l2author.style.display = "block";
                        this.urlManager.navigateAuthorLink(authorId, authorLabel);
                        this.dataRequest = authorProvider.get(authorId, this.loader.createProgressCallbackHandler(), author => {
                            this.authorManager.display(author, onComplete);
                        });
                    } else {
                        let aspect = aspecte[column - 1];
                        this.loader = util.loader(2);
                        dom.$l2quote.innerHTML = this.loader.markup;
                        dom.$l2quote.style.display = "block";
                        this.urlManager.navigateNodeLink(authorId, authorLabel, aspect.id, aspect.nume);
                        let requestResolver = {
                            author: null,
                            l2: null,
                            setAuthor(author) {
                                this.author = author;
                                this.checkAllSet();
                            },
                            setL2(l2) {
                                this.l2 = l2;
                                this.checkAllSet();
                            },
                            checkAllSet() {
                                if (this.author !== null && this.l2 !== null) {
                                    this.handler(this.author, this.l2);
                                }
                            },
                            handler() {
                                var markup = `
                                    <p>
                                        <h5>
                                             <span class="badge badge-light">${this.author.prenume} ${this.author.nume}</span>
                                             <span class="badge badge-light">${aspect.cod} ${aspect.nume}</span>
                                         </h5>
                                    </p>
                                    <div id="lucrari" class="accordion">
                                    `;
                                this.l2.situatieLucrari["" + aspect.id].forEach((idLucrare, i) => {
                                    let lucrare = this.l2.lucrari["" + idLucrare];
                                    let fragmentIds = this.l2.situatieFragmente["" + aspect.id]["" + lucrare.id];
                                    markup += renderLucrare(lucrare, idFragment => this.l2.fragmente["" + idFragment], fragmentIds, aspect.id);
                                });
                                markup += `
                                    </div>
                                `;
                                dom.$l2quote.innerHTML = markup;
                                $(".l-collapse").on("show.bs.collapse", (ev) => {
                                    l2Manager.urlManager.navigateAuthorAspectWorkLink(
                                        authorId,
                                        authorLabel,
                                        aspect.id,
                                        aspect.nume,
                                        parseInt($(ev.target).attr("data-work-id")),
                                        $(ev.target).attr("data-work-title")
                                    );
                                });
                                $(".f-collapse").on("show.bs.collapse", (ev) => {
                                    l2Manager.urlManager.navigateAuthorAspectWorkFragmentLink(
                                        authorId,
                                        authorLabel,
                                        aspect.id,
                                        aspect.nume,
                                        parseInt($(ev.target).attr("data-work-id")),
                                        $(ev.target).attr("data-work-title"),
                                        parseInt($(ev.target).attr("data-fragment-id")),
                                        $(ev.target).attr("data-fragment-title")
                                    );
                                    ev.stopPropagation();
                                });
                                if (typeof onComplete === "function") {
                                    onComplete();
                                }
                            }
                        };
                        let progressHandler = this.loader.createProgressCallbackHandler();
                        this.dataRequest = authorProvider.get(authorId, progressHandler, author => { requestResolver.setAuthor(author); });
                        this.l2DataRequest = l2Provider.get(authorId, progressHandler, l2 => { requestResolver.setL2(l2); });
                    }
                }
                dom.$detailsContainer.classList.add("expanded");
                dom.$detailsContainer.classList.add("l2");
                dom.$details.style.display = "block";
                dom.$backdrop.style.display = "block";
                dom.$backdrop.classList.add("show");
                document.body.classList.add("noscroll");
                highlightManager.disable();
            },
            leave(newL2FollowsImmediately = false) {
                if (this.current != null) {
                    if (this.dataRequest) {
                        this.dataRequest.abortIfIncomplete();
                    }
                    if (this.l2DataRequest) {
                        this.l2DataRequest.abortIfIncomplete();
                    }
                    [this.authorManager].forEach(manager => {
                        if (manager.dataRequest) {
                            manager.dataRequest.abortIfIncomplete();
                        }
                    });
                    [dom.$details, dom.$l2quote, dom.$l2author, dom.$l2aspect].forEach(node => node.style.display = "none");
                    if (!newL2FollowsImmediately) {
                        dom.$detailsContainer.classList.remove("expanded");
                        dom.$detailsContainer.classList.remove("l2");
                        dom.$backdrop.classList.remove("show");
                        this.urlManager.clearNavigation();
                        setTimeout(() => {
                            dom.$backdrop.style.display = "none";
                            document.body.classList.remove("noscroll");
                            dom.$detailsContainer.classList.remove("enlarged");
                        }, 200);
                    }
                    this.current = null;
                }
            }
        };

        window.l2 = l2Manager;

        let infoManager = {
            $info: document.getElementById("info"),
            $infoClick: document.getElementById("info-click"),
            $infoScroll: document.getElementById("info-scroll"),
            hasBeenClicked: false,
            hasBeenScrolled: false,
            disabled: false,
            useLocalHistory: true,
            nodeClicked() {
                if (!this.hasBeenClicked) {
                    this.hasBeenClicked = true;
                    localStorage.setItem("info-click-was-seen", true);
                    this.$infoClick.classList.add("alert-success")
                    this.$infoClick.classList.remove("alert-info")
                    setTimeout(() => {
                        this.$infoClick.classList.add("slide-out")
                        setTimeout(() => {
                            this.$infoClick.style.display = "none";
                            if (this.hasBeenScrolled) {
                                this.$info.style.display = "none";
                            }
                        }, 1000);
                    }, 1000);
                }
            },
            maximaScrolled() {
                if (!this.hasBeenScrolled) {
                    this.hasBeenScrolled = true;
                    localStorage.setItem("info-scroll-was-seen", true);
                    this.$infoScroll.classList.add("alert-success")
                    this.$infoScroll.classList.remove("alert-info")
                    setTimeout(() => {
                        this.$infoScroll.classList.add("slide-out")
                        setTimeout(() => {
                            this.$infoScroll.style.display = "none";
                            if (this.hasBeenClicked) {
                                this.$info.style.display = "none";
                            }
                        }, 1000);
                    }, 1000);

                }
            },
            init() {
                if (!this.disabled) {
                    this.hasBeenClicked = false;
                    this.hasBeenScrolled = false;
                    if (this.useLocalHistory) {
                        this.hasBeenClicked = localStorage.getItem("info-click-was-seen");
                        this.hasBeenScrolled = localStorage.getItem("info-scroll-was-seen");
                    }
                    if (!this.hasBeenClicked || !this.hasBeenScrolled) {
                        this.$info.style.display = "block";
                        if (!this.hasBeenClicked) {
                            this.$infoClick.style.display = "block";
                        }
                        if (!this.hasBeenScrolled) {
                            this.$infoScroll.style.display = "block";
                        }
                    }
                }
            }
        };

        infoManager.init();

        let clickListenerFactory = (mask) => {
            return (event) => {
                let target = event.target;
                if (!target.classList.contains("unclickable") && mask.indexOf(target.tagName) > -1) {
                    do {
                        if (target.tagName === "TD" && target.textContent !== "") {
                            let column = target.attributes.getNamedItem("data-column");
                            let row = target.parentNode.attributes.getNamedItem("data-row");
                            if (column != null && row != null) {
                                row = parseInt(row.value);
                                column = parseInt(column.value);
                                if (row > 0) {
                                    infoManager.nodeClicked();
                                }
                                l2Manager.enter(row, column);
                                return;
                            }
                        }
                    } while ((target = target.parentNode) != null && target.tagName !== "BODY");
                }
            };
        };

        $(document).ready(() => {

            dom.mainTable.addEventListener("mouseover", hoverListenerFactory(["TD"]));

            dom.headerTable.addEventListener("mouseover", hoverListenerFactory(["DIV", "SPAN"]));

            dom.mainTable.addEventListener("mouseout", event => {
                highlightManager.leave();
            });

            dom.headerTable.addEventListener("mouseout", event => {
                highlightManager.leave();
            });

            dom.mainTable.addEventListener("click", clickListenerFactory(["TD"]));

            dom.headerTable.addEventListener("click", clickListenerFactory(["DIV", "SPAN"]));

            dom.mainTable.addEventListener("wheel", (event) => {
                if (highlightManager.isHighlighted() && highlightManager.current.column > 0 && highlightManager.current.row > 0) {
                    if (l1Manager.shownManager && l1Manager.shownManager.$carouselQuotes) {
                        infoManager.maximaScrolled();
                        l1Manager.shownManager.$carouselQuotes.carousel(event.deltaY < 0 ? "prev" : "next");
                    }
                    event.preventDefault();
                }
            });

            dom.headerTable.addEventListener("wheel", (event) => {
                event.preventDefault();
            });

            dom.$backdrop.addEventListener("click", event => {
                let l2Found = false; // if we've found another cell to jump to in level 2
                document.elementsFromPoint(event.clientX, event.clientY).forEach((element) => {
                    if (!l2Found && element.textContent !== "" && element.parentNode && element.parentNode.parentNode) {
                        let column, row;
                        switch (element.tagName) {
                            case "TD":
                                column = element.attributes.getNamedItem("data-column");
                                row = element.parentNode.attributes.getNamedItem("data-row");
                                break;
                            case "DIV":
                                column = element.parentNode.attributes.getNamedItem("data-column");
                                row = element.parentNode.parentNode.attributes.getNamedItem("data-row");
                        }
                        if (column != null && row != null) {
                            l2Found = true;
                            l2Manager.enter(parseInt(row.nodeValue), parseInt(column.nodeValue));
                        }
                    }
                });
                if (!l2Found) {
                    l2Manager.leave();
                    highlightManager.enable();
                    highlightManager.leave();
                }
            });

            let lastScrollLeft = -1;
            let lastOffsetTop = -1;

            window.addEventListener("scroll", event => {
                highlightManager.leave();
                let scrollLeft = window.scrollX;
                if (scrollLeft != lastScrollLeft) {
                    lastScrollLeft = scrollLeft;
                    dom.headerTable.style.left = -scrollLeft + "px";
                    dom.$detailsContainer.style.marginLeft = -scrollLeft + "px";
                }
                if (window.visualViewport) { // todo: finish this logic
                    let offsetTop = window.visualViewport.offsetTop;
                    if (offsetTop != lastOffsetTop) {
                        dom.headerTable.style.top = offsetTop + "px";
                    }
                }
            });

            window.addEventListener("resize", event => {
                if (highlightManager.isHighlighted()) {
                    highlightManager.enter(highlightManager.current.row, highlightManager.current.column, false);
                }
            });

            document.getElementById("enlarge-trigger").addEventListener("click", () => {
                if (dom.$detailsContainer.classList.contains("enlarged")) {
                    dom.$detailsContainer.classList.remove("enlarged");
                } else {
                    dom.$detailsContainer.classList.add("enlarged");
                }
            });

            window.scrollTo(0, 0);

            history.scrollRestoration = "manual";

            window.addEventListener("hashchange", (event) => {
                l2Manager.urlManager.load(event.newURL);
            });

            let hashIndex = document.location.href.indexOf("#");
            if (hashIndex > -1) {
                l2Manager.urlManager.load(document.location.href);
            }

            setInterval(() => { //
                if (window.globalDataAcquisition) {
                    let cActiveTransportsByURL = Object.assign({}, window.globalDataAcquisition.activeTransportsByURL);
                    Object.keys(cActiveTransportsByURL).forEach(url => {
                        let cTransportMap = Object.assign({}, cActiveTransportsByURL[url]);
                        Object.values(cTransportMap).forEach(transport => {
                            let cTransport = Object.assign({}, transport);
                            let cRequests = {};
                            Object.values(cTransport.requests).forEach(request => {
                                let cRequest = Object.assign({}, request);
                                cRequest.transport = null;
                                cRequests["R" + request.requestId] = cRequest;
                            });
                            cTransport.requests = cRequests;
                            cTransportMap["T" + cTransport.transportId] = cTransport;
                        });
                        cActiveTransportsByURL[url] = cTransportMap;
                    });
                    console.log("activeTransportsByURL: " + JSON.stringify(cActiveTransportsByURL));
                }
            }, 2000);

        });

    }
};
