// nota: pentru a merge si in ES2015, lasat clasele fara campuri, de unde notatia stranie

class Aspect {
    constructor() {
        this.id = -1;
        this.nume;
        this.cod;
        this.descriereScurta;
        this.descriereLunga;
    }
}

class Autor {
    constructor() {
        this.id = -1;
        this.nume;
        this.prenume;
        this.nastere;
        this.deces;
        this.poza;
        this.biografieExplicativa = "";
        this.lucrari = [];
    }
}

class Lucrare {
    constructor() {
        this.id = -1;
        this.titlu;
        this.publicatie;
        this.data;
        this.sursa;
        this.fragmente = [];
    }
}

class Fragment {
    constructor() {
        this.id = -1;
        this.continut = "";
        this.continutDetaliat = "";
        this.aspecte = [];
        this.maxime = [];
    }
}

class Maxima {
    constructor() {
        this.id = -1;
        this.continut = "";
        this.aspecte = [];
    }
}

idGenerator = {
    idx: 0,
    getUniqueId() {
        return "e" + this.idx++ + "_";
    }
}

class EditorAspecte {

    constructor(aspecte) {
        this.aspecte = aspecte || [];
        this.wrapper;
        this.editoareAspecte = [];
    }

    create(parentElement) {
        let id = idGenerator.getUniqueId();
        $(parentElement).append(`
            <form id="aspecte${id}">
              <div id="containerAspecte${id}">
                <h2 id="numarAspecte${id}"></h2>
              </div>
              <div class="form-group row">
                <input type="button" value="Adaugare aspect" id="adaugaAspect${id}"/>  
              </div>
            </form>
        `);
        let adaugareEditorAspect = (aspect) => {
            let editorAspect = new EditorAspect(aspect);
            let editorAspectContainerId = idGenerator.getUniqueId();
            let updateLength = () => $("#numarAspecte" + id).html(this.aspecte.length + " aspect" + (this.aspecte.length !== 1 ? "e" : ""));
            $("#containerAspecte" + id).append(`
                <div id="containerAspect${editorAspectContainerId}" class="container-aspect">
                    <input type="button" value="Stergere aspect" id="stergeAspect${editorAspectContainerId}"/>
                </div>
            `);
            editorAspect.create($("#containerAspect" + editorAspectContainerId).get(0));
            this.editoareAspecte.push(editorAspect);
            $("#stergeAspect" + editorAspectContainerId).click(e => {
                if (confirm("Sigur doriti stergerea aspectului? Operatiunea va esua la salvare daca mai exista fragmente care sa faca referire la acest aspect")) {
                    editorAspect.remove();
                    $("#containerAspect" + editorAspectContainerId).remove();
                    this.editoareAspecte = this.editoareAspecte.filter(v => v !== editorAspect);
                    this.aspecte = this.aspecte.filter(v => v !== aspect);
                    updateLength();
                }
            });
            updateLength();
        }
        $("#adaugaAspect" + id).click(e => {
            let aspect = new Aspect();
            this.aspecte.push(aspect);
            adaugareEditorAspect(aspect);
        });
        this.wrapper = $("#aspecte" + id).get(0);
        this.aspecte.forEach(aspect => {
            adaugareEditorAspect(aspect);
        });
    }

    remove() {
        this.editoareAspecte.forEach(editor => editor.remove());
        $(this.wrapper).remove();
    }

    getState() {
        let aspecte = [];
        this.editoareAspecte.forEach(e => aspecte.push(e.getState()));
        return aspecte;
    }

}

class EditorAspect {

    constructor(aspect) {
        this.aspect = aspect;
        this.aspectId = aspect.id;
        this.wrapper;
        this.tinymceL;
    }

    create(parentElement) {
        let id = this.id = idGenerator.getUniqueId();
        $(parentElement).append(`
            <form id="aspect${id}">
              <div class="form-group row">
                <label for="nume${id}" class="col-sm-2 col-form-label">Nume</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="nume${id}" placeholder="Nume"/>
                </div>
              </div>
              <div class="form-group row">
                <label for="cod${id}" class="col-sm-2 col-form-label">Cod</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="cod${id}" placeholder="Cod"/>
                </div>
              </div>                   
              <div class="form-group row">
                <label for="descriereScurta${id}" class="col-sm-2 col-form-label">Descriere scurta</label>
                <div class="col-sm-10">
                  <textarea id="descriereScurta${id}" rows="6" class="form-control"></textarea> 
                </div>
              </div>
              <div class="form-group row">
                <label for="descriereLunga${id}" class="col-sm-2 col-form-label">Descriere lunga</label>
                <div class="col-sm-10">
                  <div id="descriereLunga${id}">${this.aspect.descriereLunga || ""}</div> 
                </div>
              </div>
            </form>
        `);
        this.wrapper = $("#aspect" + id).get(0);
        $("#nume" + id).val(this.aspect.nume);
        $("#cod" + id).val(this.aspect.cod);
        $("#descriereScurta" + id).val(this.aspect.descriereScurta || "");
        tinymce.init({
            selector: "#descriereLunga" + id,
            plugins: "table wordcount powerpaste",
            powerpaste_word_import: "clean",
            powerpaste_html_import: "clean",
            inline: true
        }).then(editors => this.tinymceL = editors[0]);
    }

    remove() {
        this.tinymceL.remove();
        $(this.wrapper).remove();
    }

    getState() {
        let aspect = new Aspect();
        aspect.id = this.aspectId;
        aspect.nume = $("#nume" + this.id).val();
        aspect.cod = $("#cod" + this.id).val();
        aspect.descriereScurta = $("#descriereScurta" + this.id).val();
        aspect.descriereLunga = this.tinymceL.getContent();
        return aspect;
    }

}

class EditorAutori {

    constructor(autori) {
        this.autori = autori || [];
        this.wrapper;
        this.editoareAutori = [];
    }

    create(parentElement) {
        let id = idGenerator.getUniqueId();
        $(parentElement).append(`
            <form id="autori${id}">
              <div id="containerAutori${id}">
                <h2 id="numarAutori${id}"></h2>
              </div>
              <div class="form-group row">
                <input type="button" value="Adaugare autor" id="adaugaAutor${id}"/>  
              </div>
            </form>
        `);
        let adaugareEditorAutor = (autor) => {
            let editorAutor = new EditorAutor(autor);
            let editorAutorContainerId = idGenerator.getUniqueId();
            let updateLength = () => $("#numarAutori" + id).html(this.autori.length + " autor" + (this.autori.length !== 1 ? "i" : ""));
            $("#containerAutori" + id).append(`
                <div id="containerAutor${editorAutorContainerId}" class="container-autor">
                    <input type="button" value="Stergere autor" id="stergeAutor${editorAutorContainerId}"/>
                </div>
            `);
            editorAutor.create($("#containerAutor" + editorAutorContainerId).get(0));
            this.editoareAutori.push(editorAutor);
            $("#stergeAutor" + editorAutorContainerId).click(e => {
                editorAutor.remove();
                $("#containerAutor" + editorAutorContainerId).remove();
                this.editoareAutori = this.editoareAutori.filter(v => v !== editorAutor);
                this.autori = this.autori.filter(v => v !== autor);
                updateLength();
            });
            updateLength();
        }
        $("#adaugaAutor" + id).click(e => {
            let autor = new Autor();
            this.autori.push(autor);
            adaugareEditorAutor(autor);
        });
        this.wrapper = $("#autori" + id).get(0);
        this.autori.forEach(autor => {
            adaugareEditorAutor(autor);
        });
    }

    remove() {
        this.editoareAutori.forEach(editor => editor.remove());
        $(this.wrapper).remove();
    }

    validateAndGetState() {
        let autori = [];
        this.editoareAutori.forEach(e => autori.push(e.validateAndGetState()));
        //TODO: validate
        return autori;
    }

}

class EditorAutor {

    constructor(autor) {
        this.autor = autor;
        this.autorId = autor.id;
        this.wrapper;
        this.tinymce;
        this.editoareLucrari = [];
    }

    create(parentElement) {
        let id = this.id = idGenerator.getUniqueId();
        this.wrapper = $("#autor" + id).get(0);
        $(parentElement).append(`
            <form id="autor${id}">
              <div class="form-group row">
                <label for="nume${id}" class="col-sm-2 col-form-label">Nume</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="nume${id}" placeholder="Numele de familie"/>
                </div>
              </div>
              <div class="form-group row">
                <label for="nume${id}" class="col-sm-2 col-form-label">Prenume</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="prenume${id}" placeholder="Prenumele"/>
                </div>
              </div>                   
              <div class="form-group row">
                <label for="nastere${id}" class="col-sm-2 col-form-label">Nastere</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="nastere${id}" placeholder="Informatii nastere"/>
                </div>
              </div>              
              <div class="form-group row">
                <label for="deces${id}" class="col-sm-2 col-form-label">Deces</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="deces${id}" placeholder="Informatii deces"/>
                </div>
                </div>
              </div>           
              <div class="form-group row">
                <label for="poza${id}" class="col-sm-2 col-form-label">Poza</label>
                <div class="col-sm-10">
                  <input type="file" class="form-control" id="poza${id}" placeholder="Imagine autor"/>
                  <input type="button" id="stergePoza${id}" value="Sterge"/>
                </div>
              </div>                   
              <div class="form-group row">
                <label for="biografieExplicativa${id}" class="col-sm-2 col-form-label">Biografie explicativa</label>
                <div class="col-sm-10">
                  <div id="biografieExplicativa${id}">${this.autor.biografieExplicativa}</div> 
                </div>
              </div>
              <div class="form-group row">
                <label for="lucrari${id}" class="col-sm-2 col-form-label">Lucrari</label>
                <div class="col-sm-10">
                    <h3 id="numarLucrari${id}"></h3>
                    <div id="lucrari${id}"></div> 
                    <input type="button" id="adaugaLucrare${id}" value="Adaugare lucrare"/>                  
                </div>
              </div>
            </form>
        `);
        $("#nume" + id).val(this.autor.nume);
        $("#prenume" + id).val(this.autor.prenume);
        if (this.autor.nastere) {
            $("#nastere" + id).val(this.autor.nastere);
        }
        if (this.autor.deces) {
            $("#deces" + id).val(this.autor.deces);
        }
        $("#poza" + id).picEdit();
        if (this.autor.poza) {
            if (typeof this.autor.poza === "function") {
                this.autor.poza(data => $("#poza" + id).data("plugin_picEdit")._create_image_with_datasrc(data));
            } else {
                $("#poza" + id).data("plugin_picEdit")._create_image_with_datasrc(this.autor.poza);
            }
        }
        $("#stergePoza" + id).click(() => {
            $("#poza" + id).data("plugin_picEdit")._wipe();
        });
        tinymce.init({
            selector: "#biografieExplicativa" + id,
            plugins: "table wordcount powerpaste",
            powerpaste_word_import: "clean",
            powerpaste_html_import: "clean",
            inline: true
        }).then(editors => this.tinymce = editors[0]);

        let updateWorksLength = () => $("#numarLucrari" + id).html(this.autor.lucrari.length + " lucrari");

        let adaugaEditorLucrare = lucrare => {
            let editorLucrare = new EditorLucrare(lucrare);
            let editorLucrareContainerId = idGenerator.getUniqueId();
            $("#lucrari" + id).append(`
                <div id="containerLucrare${editorLucrareContainerId}" class="container-lucrare">
                    <input type="button" value="Stergere lucrare" id="stergeLucrare${editorLucrareContainerId}"/>
                </div>
            `);
            editorLucrare.create($("#containerLucrare" + editorLucrareContainerId).get(0));
            this.editoareLucrari.push(editorLucrare);
            $("#stergeLucrare" + editorLucrareContainerId).click(e => {
                editorLucrare.remove();
                $("#containerLucrare" + editorLucrareContainerId).remove();
                this.editoareLucrari = this.editoareLucrari.filter(v => v !== editorLucrare);
                this.autor.lucrari = this.autor.lucrari.filter(v => v !== lucrare);
                updateWorksLength();
            });
            updateWorksLength();
        };

        this.autor.lucrari.forEach(lucrare => {
            adaugaEditorLucrare(lucrare);
        });

        $("#adaugaLucrare" + id).click(e => {
            let lucrare = new Lucrare();
            this.autor.lucrari.push(lucrare);
            adaugaEditorLucrare(lucrare);
        });
    }

    remove() {
        this.tinymce.remove();
        $(this.wrapper).remove();
        this.editoareLucrari.forEach(editor => editor.remove());
    }

    validateAndGetState() {
        let autor = new Autor();
        autor.id = this.autorId;
        autor.nume = $("#nume" + this.id).val();
        autor.prenume = $("#prenume" + this.id).val();
        autor.nastere = $("#nastere" + this.id).val();
        autor.deces = $("#deces" + this.id).val();
        autor.poza = $("#poza" + this.id).data("plugin_picEdit")._getData();
        autor.biografieExplicativa = this.tinymce.getContent();
        autor.lucrari = [];
        this.editoareLucrari.forEach(editorLucrari => autor.lucrari.push(editorLucrari.validateAndGetState()));
        //TODO: validate
        return autor;
    }

}

class EditorLucrare {

    constructor(lucrare) {
        this.lucrare = lucrare;
        this.lucrareId = lucrare.id;
        this.wrapper;
        this.editoareFragmente = [];
    }

    create(parentElement) {
        let id = this.id = idGenerator.getUniqueId();
        $(parentElement).append(`
            <form id="lucrare${id}">
              <div class="form-group row">
                <label for="nume${id}" class="col-sm-2 col-form-label">Nume</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="titlu${id}" placeholder="Titlu lucrare"/>
                </div>
              </div>
              <div class="form-group row">
                <label for="nume${id}" class="col-sm-2 col-form-label">Publicatie</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="publicatie${id}" placeholder="Publicatie"/>
                </div>
              </div>                   
              <div class="form-group row">
                <label for="data${id}" class="col-sm-2 col-form-label">Data</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="data${id}" placeholder="Data publicare"/>
                </div>
              </div>                   
              <div class="form-group row">
                <label for="sursa${id}" class="col-sm-2 col-form-label">Sursa</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="sursa${id}" placeholder="Trimitere catre sursa"/>
                </div>
              </div>                   
              <div class="form-group row">
                <label for="fragmente${id}" class="col-sm-2 col-form-label">Fragmente</label>
                <div class="col-sm-10">
                    <h4 id="numarFragmente${id}"></h4>
                    <div id="fragmente${id}"></div>
                    <input type="button" value="Adaugare fragment" id="adaugaFragment${id}"/>
                </div>
              </div>
            </form>
        `);
        this.wrapper = $("#lucrare" + id).get(0);
        $("#titlu" + id).val(this.lucrare.titlu);
        $("#publicatie" + id).val(this.lucrare.publicatie);
        $("#data" + id).val(this.lucrare.data);
        $("#sursa" + id).val(this.lucrare.sursa);

        let updateFragmentLength = () => $("#numarFragmente" + id).html(this.lucrare.fragmente.length + " fragmente");

        let adaugaEditorFragment = fragment => {
            let editorFragment = new EditorFragment(fragment);
            let editorFragmentContainerId = idGenerator.getUniqueId();
            $("#fragmente" + id).append(`
                <div id="containerFragment${editorFragmentContainerId}" class="container-fragment">
                    <input type="button" value="Stergere fragment" id="stergeFragment${editorFragmentContainerId}"/>
                </div>
            `);
            editorFragment.create($("#containerFragment" + editorFragmentContainerId).get(0));
            this.editoareFragmente.push(editorFragment);
            $("#stergeFragment" + editorFragmentContainerId).click(e => {
                editorFragment.remove();
                $("#containerFragment" + editorFragmentContainerId).remove();
                this.editoareFragmente = this.editoareFragmente.filter(v => v !== editorFragment);
                this.lucrare.fragmente = this.lucrare.fragmente.filter(v => v !== fragment);
                updateFragmentLength();
            });
            updateFragmentLength();
        };

        this.lucrare.fragmente.forEach(fragment => {
            adaugaEditorFragment(fragment);
        });

        $("#adaugaFragment" + id).click(e => {
            let fragment = new Fragment();
            this.lucrare.fragmente.push(fragment);
            adaugaEditorFragment(fragment);
        });

    }

    remove() {
        this.editoareFragmente.forEach(editorFragment => editorFragment.remove());
        $(this.wrapper).remove();
    }

    validateAndGetState() {
        let lucrare = new Lucrare();
        lucrare.id = this.lucrareId;
        lucrare.titlu = $("#titlu" + this.id).val();
        lucrare.publicatie = $("#publicatie" + this.id).val();
        lucrare.data = $("#data" + this.id).val();
        lucrare.sursa = $("#sursa" + this.id).val();
        lucrare.fragmente = [];
        this.editoareFragmente.forEach(editorFragment => lucrare.fragmente.push(editorFragment.validateAndGetState()));
        //TODO: validate
        return lucrare;
    }

}

class EditorFragment {

    constructor(fragment) {
        this.fragment = fragment;
        this.fragmentId = fragment.id;
        this.wrapper;
        this.tinymce;
        this.tinymceD;
        this.editoareMaxime = [];
    }

    create(parentElement) {
        let id = this.id = idGenerator.getUniqueId();
        let htmlAspecte = "<div class=\"input-group\">";
        let mapAspecte = {};
        getAspecte().forEach(a => {
            htmlAspecte +=
            `<div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" id="aspect${id}${a.id}">
                <label class="form-check-label" for="aspect${id}${a.id}">${a.cod}-${a.nume}</label>
            </div>`;
            mapAspecte[a.cod] = a.id;
        });
        htmlAspecte += "</div>";
        $(parentElement).append(`
            <form id="fragment${id}">
                <div class="form-group row">
                    <label for="aspecte${id}" class="col-sm-2 col-form-label">Aspecte</label>
                    <div class="col-sm-10" id="aspecte${id}">
                        ${htmlAspecte}
                    </div>
                </div>
                <div class="form-group row">
                    <label for="continutFragment${id}" class="col-sm-2 col-form-label">Continut</label>
                    <div class="col-sm-10">
                        <div id="continutFragment${id}">${this.fragment.continut}</div>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="continutDetaliatFragment${id}" class="col-sm-2 col-form-label">Continut detaliat</label>
                    <div class="col-sm-10">
                        <div id="continutDetaliatFragment${id}">${this.fragment.continutDetaliat}</div>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="maxima${id}" class="col-sm-2 col-form-label">Maxime</label>
                    <div class="col-sm-10" id="maxima${id}">
                        <h5 id="numarMaxime${id}"></h5>
                        <div id="maxime${id}"></div>
                        <input type="button" value="Adaugare maxima" id="adaugaMaxima${id}"/>
                    </div>
                </div>
            </form>
        `);
        this.wrapper = $("#fragment" + id).get(0);
        this.fragment.aspecte.forEach(a => {
            if (typeof a === "number") { // numar
                $(`#aspect${id}${a}`).prop("checked", true);
            } else { // cod
                let idAspect = mapAspecte[a];
                if (idAspect === null) {
                    idAspect = mapAspecte[a.replace("a0", "a")];
                }
                if (idAspect !== null) {
                    $(`#aspect${id}${a}`).prop("checked", true);
                }
                $(`#aspect${id}${idAspect}`).prop("checked", true);
            }
        });
        tinymce.init({
            selector: "#continutFragment" + id,
            plugins: "table wordcount powerpaste",
            powerpaste_word_import: "clean",
            powerpaste_html_import: "clean",
            inline: true
        }).then(editors => this.tinymce = editors[0]);

        tinymce.init({
            selector: "#continutDetaliatFragment" + id,
            plugins: "table wordcount powerpaste",
            powerpaste_word_import: "clean",
            powerpaste_html_import: "clean",
            inline: true
        }).then(editors => this.tinymceD = editors[0]);

        let updateMaximeLength = () => $("#numarMaxime" + id).html(this.fragment.maxime.length + " maxime");

        let adaugaEditorMaxima = maxima => {
            let editorMaxima = new EditorMaxima(maxima);
            let editorMaximaContainerId = idGenerator.getUniqueId();
            $("#maxime" + id).append(`
                <div id="containerMaxima${editorMaximaContainerId}" class="container-maxima">
                    <input type="button" value="Stergere maxima" id="stergeMaxima${editorMaximaContainerId}"/>
                </div>
            `);
            editorMaxima.create($("#containerMaxima" + editorMaximaContainerId).get(0));
            this.editoareMaxime.push(editorMaxima);
            $("#stergeMaxima" + editorMaximaContainerId).click(e => {
                editorMaxima.remove();
                $("#containerMaxima" + editorMaximaContainerId).remove();
                this.editoareMaxime = this.editoareMaxime.filter(v => v !== editorMaxima);
                this.fragment.maxime = this.fragment.maxime.filter(v => v !== maxima);
                updateMaximeLength();
            });
            updateMaximeLength();
        };

        this.fragment.maxime.forEach(fragment => {
            adaugaEditorMaxima(fragment);
        });

        $("#adaugaMaxima" + id).click(e => {
            let maxima = new Maxima();
            this.fragment.maxime.push(maxima);
            adaugaEditorMaxima(maxima);
        });

    }

    remove() {
        this.tinymce.remove();
        this.tinymceD.remove();
        $(this.wrapper).remove();
    }

    validateAndGetState() {
        let fragment = new Fragment();
        fragment.id = this.fragmentId;
        fragment.continut = this.tinymce.getContent();
        fragment.continutDetaliat = this.tinymceD.getContent();
        fragment.aspecte = [];
        getAspecte().forEach(a => {
            if ($(`#aspect${this.id}${a.id}`).is(":checked")) {
                fragment.aspecte.push(a.id);
            }
        })
        this.editoareMaxime.forEach(editorMaxime => fragment.maxime.push(editorMaxime.validateAndGetState()));

        //TODO: validate
        return fragment;
    }

}

class EditorMaxima {

    constructor(maxima) {
        this.maxima = maxima;
        this.maximaId = maxima.id;
        this.wrapper;
        this.tinymce;
    }

    create(parentElement) {
        let id = this.id = idGenerator.getUniqueId();
        let htmlAspecte = "<div class=\"input-group\">";
        let mapAspecte = {};
        getAspecte().forEach(a => {
            htmlAspecte +=
                `<div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" id="aspect${id}${a.id}">
                <label class="form-check-label" for="aspect${id}${a.id}">${a.cod}-${a.nume}</label>
            </div>`;
            mapAspecte[a.cod] = a.id;
        });
        htmlAspecte += "</div>";
        $(parentElement).append(`
            <form id="maxima${id}">
              <div class="form-group row">
                <label for="aspecte${id}" class="col-sm-2 col-form-label">Aspecte</label>
                <div class="col-sm-10" id="aspecte${id}">
                    ${htmlAspecte}
                </div>
              </div>
              <div class="form-group row">
                <label for="continutMaxima${id}" class="col-sm-2 col-form-label">Continut</label>
                <div class="col-sm-10">
                  <div id="continutMaxima${id}">${this.maxima.continut}</div>
                </div>
              </div>                   
            </form>
        `);
        this.wrapper = $("#maxima" + id).get(0);
        this.maxima.aspecte.forEach(a => {
            if (typeof a === "number") { // numar
                $(`#aspect${id}${a}`).prop("checked", true);
            } else { // cod
                let idAspect = mapAspecte[a];
                if (idAspect === null) {
                    idAspect = mapAspecte[a.replace("a0", "a")];
                }
                if (idAspect !== null) {
                    $(`#aspect${id}${a}`).prop("checked", true);
                }
                $(`#aspect${id}${idAspect}`).prop("checked", true);
            }
        });
        tinymce.init({
            selector: "#continutMaxima" + id,
            plugins: "table wordcount powerpaste",
            powerpaste_word_import: "clean",
            powerpaste_html_import: "clean",
            inline: true
        }).then(editors => this.tinymce = editors[0]);
    }

    remove() {
        this.tinymce.remove();
        $(this.wrapper).remove();
    }

    validateAndGetState() {
        let maxima = new Maxima();
        maxima.id = this.maximaId;
        maxima.continut = this.tinymce.getContent();
        maxima.aspecte = [];
        getAspecte().forEach(a => {
            if ($(`#aspect${this.id}${a.id}`).is(":checked")) {
                maxima.aspecte.push(a.id);
            }
        })
        //TODO: validate
        return maxima;
    }

}

let wikipedia = {
    autor(url) {
        let getDateAccurateClaim = (claims, property, date) => {
            if (claims[property] && claims[property].length) {
                for (let i=0; i<claims[property].length; i++) {
                    let claim = claims[property][i];
                    if (claim.qualifiers && claim.qualifiers.length > 0) {
                        if (claim.qualifiers.P580) { // has start date
                            if (date.getTime() < parseDate(claim.qualifiers.P580[0].datavalue.value.time).getTime()) {
                                continue;
                            }
                        }
                        if (claim.qualifiers.P582) { // has end date
                            if (date.getTime() > parseDate(claim.qualifiers.P582[0].datavalue.value.time).getTime()) {
                                continue;
                            }
                        }
                    }
                    return claim.mainsnak.datavalue.value.id;
                }
            }
        };
        let parseDate = (dateString) => {
            if (dateString != null) {
                if (dateString.startsWith("+")) {
                    dateString = dateString.substring(1);
                }
            }
            return new Date(dateString);
        };
        let getContainingGeographicEntityValidAtDate = (locationEntity, date) => {
            let info = {entity: null, entityValue: null, entityId: date != null ? getDateAccurateClaim(locationEntity.claims, "P131", date) : locationEntity.claims.P131 ? locationEntity.claims.P131[0].mainsnak.datavalue.value.id : null};
            if (info.entityId != null) {
                $.ajax({
                    url: "/proxy/json/" + btoa("https://www.wikidata.org/w/api.php?action=wbgetentities&languages=ro&languagefallback=en&format=json&ids=" + encodeURIComponent(info.entityId)),
                    success: c => {
                        info.entity = c.entities[info.entityId];
                        info.entityValue = (info.entity.labels.ro || info.entity.labels.en).value;
                    },
                    async: false
                });
            }
            return info;
        };

        let getCountryAndCountyValidAtDate = (locationEntity, date) => {
            let countryEntityId = date != null ? getDateAccurateClaim(locationEntity.claims, "P17", date) : locationEntity.claims.P17 ? locationEntity.claims.P17[0].mainsnak.datavalue.value.id : null;
            let countyEntityId = date != null ? getDateAccurateClaim(locationEntity.claims, "P131", date) : locationEntity.claims.P131 ? locationEntity.claims.P131[0].mainsnak.datavalue.value.id : null;
            let entitiesToFetch = [];
            if (countryEntityId != null) {
                entitiesToFetch.push(countryEntityId);
            }
            if (countyEntityId != null) {
                entitiesToFetch.push(countyEntityId);
            }
            let info = {country: null, county: null};
            if (entitiesToFetch.length > 0) {
                $.ajax({
                    url: "/proxy/json/" + btoa("https://www.wikidata.org/w/api.php?action=wbgetentities&languages=ro&languagefallback=en&format=json&ids=" + encodeURIComponent(entitiesToFetch.join("|"))),
                    success: c => {
                        if (countryEntityId != null && c.entities[countryEntityId]) {
                            info.country=(c.entities[countryEntityId].labels.ro || c.entities[countryEntityId].labels.en).value;
                        }
                        if (countyEntityId != null && c.entities[countyEntityId]) {
                            info.county=(c.entities[countyEntityId].labels.ro || c.entities[countyEntityId].labels.en).value;
                        }
                    },
                    async: false
                });
            }
            return info;
        };
        let result = {found: false};
        $.ajax({
           url: "/proxy/html/" + btoa(url),
           success: w => {
               $.ajax({
                   url: "/proxy/json/" + btoa(url.replace("/wiki/", "/w/api.php?action=query&prop=pageprops&ppprop=wikibase_item&format=json&formatversion=2&titles=")),
                   success: r => {
                       try {
                           let wikibaseItemId = r.query.pages[0].pageprops.wikibase_item;
                           $.ajax({
                               url: "/proxy/json/" + btoa("https://www.wikidata.org/w/api.php?action=wbgetclaims&format=json&entity=" + wikibaseItemId),
                               success: c => {
                                   result.found = true;
                                   let dataNasterii = c.claims.P569 ? c.claims.P569[0].mainsnak.datavalue.value.time : null;
                                   let dataDecesului = c.claims.P570 ? c.claims.P570[0].mainsnak.datavalue.value.time : null;
                                   let idLoculNasterii = dataNasterii ? getDateAccurateClaim(c.claims, "P19", parseDate(dataNasterii)) : c.claims.P19 ? c.claims.P19[0].mainsnak.datavalue.value.id : null;;
                                   let idLoculDecesului = dataDecesului ? getDateAccurateClaim(c.claims, "P20", parseDate(dataDecesului)) : c.claims.P20 ? c.claims.P20[0].mainsnak.datavalue.value.id : null;
                                   let idNumeFamilie = c.claims.P734 ? c.claims.P734[0].mainsnak.datavalue.value.id : null;
                                   let idPrenume = c.claims.P735 ? c.claims.P735[0].mainsnak.datavalue.value.id : null;
                                   let requestedIds = [];
                                   [idLoculNasterii, idLoculDecesului, idNumeFamilie, idPrenume].forEach((n) => { if (n != null) requestedIds.push(n); } );
                                   if (requestedIds.length > 0) {
                                       $.ajax({
                                           url: "/proxy/json/" + btoa("https://www.wikidata.org/w/api.php?action=wbgetentities&languages=ro&languagefallback=en&format=json&ids=" + encodeURIComponent(requestedIds.join("|"))),
                                           success: d => {
                                               if (idLoculNasterii != null && d.entities[idLoculNasterii] != null) {
                                                   result.loculNasterii = (d.entities[idLoculNasterii].labels.ro || d.entities[idLoculNasterii].labels.en).value;
                                                   let containingEntityInfo = {entity: d.entities[idLoculNasterii]};
                                                   while ((containingEntityInfo = getContainingGeographicEntityValidAtDate(containingEntityInfo.entity)).entity !== null) {
                                                       result.loculNasterii += ", " + containingEntityInfo.entityValue;
                                                   }
                                               }
                                               if (idLoculDecesului != null && d.entities[idLoculDecesului] != null) {
                                                   result.loculDecesului = (d.entities[idLoculDecesului].labels.ro || d.entities[idLoculDecesului].labels.en).value;
                                                   let containingEntityInfo = {entity: d.entities[idLoculDecesului]};
                                                   while ((containingEntityInfo = getContainingGeographicEntityValidAtDate(containingEntityInfo.entity)).entity !== null) {
                                                       result.loculDecesului += ", " + containingEntityInfo.entityValue;
                                                   }
                                               }
                                               if (idNumeFamilie != null && d.entities[idNumeFamilie] != null) {
                                                   result.numeFamilie = (d.entities[idNumeFamilie].labels.ro || d.entities[idNumeFamilie].labels.en).value;
                                               }
                                               if (idPrenume != null && d.entities[idPrenume] != null) {
                                                   result.prenume = (d.entities[idPrenume].labels.ro || d.entities[idPrenume].labels.en).value;
                                               }
                                           },
                                           async: false
                                       });
                                   }
                                   result.dataNasterii = parseDate(dataNasterii);
                                   result.dataDecesului = parseDate(dataDecesului);
                                   // get image
                                   $(w).find("img").each((i, e) => {
                                       let src = $(e).attr("src");
                                       if (src.indexOf("svg") === -1 && src.indexOf("logo") === -1 && src.indexOf("icon") === -1) {
                                           result.poza = callback => getImageAsDataUrl("/proxy/binary/" + btoa(src.startsWith("http") ? src : "http:" + src), callback);
                                           return false;
                                       }
                                   });
                               },
                               async: false
                           });
                       } catch (ignored) {}
                   },
                   async: false
               });
           },
            async: false
        });

        return result;
    }
}

function getImageAsDataUrl(url, callback) {
    let img = document.createElement("img");
    img.src = url;
    img.onload = function() {
        let canvas = document.createElement("canvas");
        let ctx = canvas.getContext("2d");
        canvas.width = img.width;
        canvas.height = img.height;
        ctx.drawImage(img, 0, 0);
        img.remove();
        callback(canvas.toDataURL("image/jpeg"));
    }
}

let _aspecte = [];

function getAspecte() {
    if (_aspecte.length === 0) {
        $.ajax({
            url: "/aspecte",
            success: a => {
                _aspecte = a;
            },
            async: false
        });
    }
    return _aspecte;
}
const WordImporter = function() {
    this.editorAutori = null;
    this.processWordInput = function(editor, domTarget) {
        const root = editor.dom.getRoot();
        const walker = new tinymce.dom.TreeWalker(root);
        let autori = [], autor_actual = null;
        let lucrare_actuala = null;
        let fragment_actual = null;
        let maxima_actuala = null;
        let extrageAspecte = (sirAspecte, startAspecte, endAspecte) => {
            return sirAspecte.substring(startAspecte + 1, endAspecte).split(/[,\ ]+/).map((v, i) => {
                v = v.toLowerCase();
                if (v.startsWith("a")) {
                    v = v.substring(1);
                    let p = v.search(/[^0-9]/);
                    if (p > -1) {
                        return "a" + v.substring(0, p);
                    } else {
                        return "a" + v;
                    }
                } else {
                    return v;
                }
            });
        };
        let getColor = (node, parentColor) => {
            let cssColor = (node.style.color || "").replace(/ /g, "");
            let color = (node.color || "").toLowerCase();
            if (cssColor) {
                return cssColor;
            } else if (color) {
                return color;
            } else if (parentColor) {
                return parentColor;
            } else {
                return "";
            }
        };
        let isColored = (color) => {
            if (color) {
                return color !==  "rgb(0,0,0)" && color !== "#000" && color !== "#000000" && color !== "black";
            } else {
                return false;
            }
        };
        let dfs = (node, callback) => {
            node.childNodes.forEach(child => { callback(child); dfs(child, callback); });
        };
        let removeBW = (node, inPlace, parentColor) => {
            // p1 - aspectele
            // p2 - culoare tata
            if (inPlace) {
                if (node.style && node.innerText.trim() !== "") { // is a non-empty element
                    let color = getColor(node, parentColor);
                    switch (node.tagName.toUpperCase()) {
                        case "PRE":
                        case "TABLE":
                            if (!isColored(color)) {
                                // if even one child has color, keep the whole node. Othewise, remove everything
                                let hasChildWithColor = false;
                                dfs(node, child => {
                                    if (child.style && isColored(getColor(child, parentColor))) {
                                        hasChildWithColor = true;
                                    }
                                });
                                if (!hasChildWithColor) { // replace with
                                    let omittedSpan = document.createElement("span");
                                    omittedSpan.classList.add("shortened")
                                    omittedSpan.innerText = " [+] ";
                                    return omittedSpan;
                                }
                            }
                            break;
                        default:
                            if (node.innerText.trim() !== "") {
                                if (!isColored(color)) {
                                    let nodes = [];
                                    node.childNodes.forEach(e => nodes.push(e)); // if you iterate on the original childNodes and remove was called, it will skip a beat
                                    nodes.forEach(child => {
                                        if (child.nodeType === Node.TEXT_NODE) {
                                            let trimmedNodeValue = child.nodeValue.trim();
                                            if (trimmedNodeValue.trim() === stripAspecte(trimmedNodeValue)) { // doesn't contain aspects
                                                child.nodeValue = " [+] ";
                                            }
                                        }
                                    });
                                }
                                let nodes = [];
                                node.childNodes.forEach(e => nodes.push(e)); // if you iterate on the original childNodes and remove was called, it will skip a beat
                                nodes.forEach(child => removeBW(child, true, color));
                                if (node.innerText.trim() === "") {
                                    node.innerText = " [+] ";
                                }
                            }
                    }
                }
                return node;
            } else {
                return removeBW(node.cloneNode(true), true);
            }
        };
        let trim = (node) => {
            return directionalTrim(directionalTrim(node, true), false);
        };
        let directionalTrim = (node, beginning) => {
            if (node.childNodes.length > 0) {
                let child = beginning ? node.childNodes[0] : node.childNodes[node.childNodes.length - 1];
                if (child.nodeType === Node.TEXT_NODE) {
                    let trimmed = child.nodeValue.trim();
                    if (trimmed === "") {
                        child.remove();
                    } else {
                        child.nodeValue = trimmed;
                    }
                } else {
                    if (child.innerText.trim() === "") {
                        child.remove();
                    } else { // go deeper on first child
                        if (child.childNodes.length > 0) {
                            trim(child.childNodes[0]);
                        }
                    }
                }
            }
            return node;
        };
        let removeEmptyParents = (element) => {
            if (element.innerText.trim() === "") {
                let parent = element.parentNode;
                element.remove();
                removeEmptyParents(parent);
            }
        }
        let stripMultiEllipsis = (node) => {
            // remove child nodes with adjacent [+]
            if (node.nodeType === Node.ELEMENT_NODE) {
                let nodeList = [];
                dfs(node, child => {
                    if (child.nodeType === Node.TEXT_NODE) {
                        nodeList.push(child);
                    }
                });
                let lastChildWasEllipsis = false;
                nodeList.forEach(child => {
                    let trimmed = child.nodeValue.trim();
                    if (trimmed !== "") {
                        let isEllipsis = false;
                        if (trimmed === "[+]") {
                            isEllipsis = true;
                            if (isEllipsis && lastChildWasEllipsis) { // remove
                                let parent = child.parentNode;
                                child.remove();
                                removeEmptyParents(parent);
                            }
                        }
                        lastChildWasEllipsis = isEllipsis;
                    }
                });
            }
            return node;
        }
        let stripColors = (node, inPlace) => {
            if (inPlace) {
                if (node.style) {
                    if (node.style.color) {
                        node.style.removeProperty("color");
                    }
                    if (node.style.backgroundColor) {
                        node.style.removeProperty("backgroundColor");
                    }
                    if (node.style.background) {
                        node.style.removeProperty("background");
                    }
                    if (node.color) {
                        node.removeAttribute("color");
                    }
                    let dataMceStyle = node.attributes.getNamedItem("data-mce-style");
                    if (dataMceStyle) {
                        dataMceStyle.nodeValue = dataMceStyle.nodeValue.replace(/(color|background-color|background):[a-zA-Z0-9 #]+;/ig, "");
                    }
                    node.removeAttribute("data-mce-style");
                    node.childNodes.forEach(child => stripColors(child, true));
                }
                return node;
            } else {
                let clone = node.cloneNode(true);
                stripColors(clone, true);
                return clone;
            }
        };
        let stripAspecte = (continut, startChar, endChar) => {
            if (startChar && endChar) {
                let inceputAspecte;
                while ((inceputAspecte = continut.search(startChar === "[" ? /\[a[0-9]/ : /{a[0-9]/)) > -1) {
                    let sfarsitAspecte = continut.indexOf(endChar, inceputAspecte);
                    sfarsitAspecte = sfarsitAspecte > -1 ? sfarsitAspecte : inceputAspecte + 2;
                    continut = continut.substring(0, inceputAspecte) + continut.substring(sfarsitAspecte + 1);
                }
                return continut;
            } else {
                return stripAspecte(stripAspecte(continut, "[", "]"), "{", "}");
            }
        };
        let currentContainer = null;
        let isInsideCurrentContainer = (node) => {
            if (currentContainer === null) {
                return false;
            } else {
                let parent = node;
                while ((parent = parent.parentNode) !== null) {
                    if (parent === currentContainer)
                        return true;
                }
                return false;
            }
        }
        do {
            let node = walker.current();
            if (node.nodeType === Node.ELEMENT_NODE) {
                switch (node.tagName.toUpperCase()) {
                    case "H2": // autor nou
                        autor_actual = new Autor();
                        autor_actual.lucrari = [];
                        autor_actual.biografieExplicativa = "";
                        lucrare_actuala = null;
                        fragment_actual = null;
                        autori.push(autor_actual);
                        let numeComplet = node.innerText;
                        if (numeComplet.indexOf(",") > -1) {
                            let partiNume = numeComplet.split(",");
                            autor_actual.nume = partiNume[0].trim();
                            autor_actual.prenume = partiNume[partiNume.length - 1].trim();
                        } else if (numeComplet.indexOf(" ") > -1) {
                            let partiNume = numeComplet.split(" ");
                            autor_actual.prenume = "";
                            for (let i=0; i<partiNume.length - 1; i++) {
                                autor_actual.prenume += (i > 0 ? " " : "") + partiNume[i];
                            }
                            autor_actual.nume = partiNume[partiNume.length - 1];
                        } else {
                            autor_actual.nume = numeComplet;
                        }
                        break;
                    case "H3": // lucrare noua
                        if (autor_actual != null) {
                            autor_actual.lucrari.push(lucrare_actuala = new Lucrare());
                            lucrare_actuala.fragmente = [];
                            lucrare_actuala.titlu = node.innerText.trim().replace(/[ \n\t\r][ \n\t\r]+/g, "");
                        }
                        fragment_actual = null;
                        break;
                    case "P":
                    case "PRE":
                    case "TABLE":
                        if (!isInsideCurrentContainer(node)) { // avoid revisiting elements in containers
                            currentContainer = null;
                            switch (node.tagName.toUpperCase()) {
                                case "PRE":
                                case "TABLE":
                                    currentContainer = node;
                            }
                            if (autor_actual != null && lucrare_actuala != null) { // continut lucrare
                                let trimmed = node.innerText.trim();
                                let startAspecte = trimmed.search(/\[a[0-9]/);
                                let endAspecte = trimmed.indexOf("]", startAspecte);
                                let removedBW = stripColors(removeBW(node), true);
                                let continut = stripAspecte(removedBW.innerHTML.trim().length > 0 ? removedBW.outerHTML : "");
                                let continutDetaliat = stripAspecte(stripColors(node).outerHTML);

                                if (startAspecte > -1 && endAspecte > startAspecte) { // posibil inceput de fragment
                                    fragment_actual = new Fragment();
                                    maxima_actuala = null;
                                    lucrare_actuala.fragmente.push(fragment_actual);
                                    fragment_actual.aspecte = extrageAspecte(trimmed, startAspecte, endAspecte);
                                    fragment_actual.continut = continut;
                                    fragment_actual.continutDetaliat = continutDetaliat;
                                } else if (fragment_actual != null) {
                                    fragment_actual.continut += "\n" + continut;
                                    fragment_actual.continutDetaliat += "\n" + continutDetaliat;
                                } else { // inca in zona lucrare
                                    let i = node.innerText, s = i.toLowerCase(), t = s.trim();
                                    if (t.startsWith("data:") || t.startsWith("dată:")) {
                                        lucrare_actuala.data = i.substring(i.indexOf(":") + 1).trim().replace(/[ \n\t\r][ \n\t\r]+/g, "");
                                    } else if (t.startsWith("publicatie:") || t.startsWith("publicație:") || t.startsWith("publicaţie:")) {
                                        lucrare_actuala.publicatie = i.substring(i.indexOf(":") + 1).trim().replace(/[ \n\t\r][ \n\t\r]+/g, "");
                                    } else if (t.startsWith("sursa:") || t.startsWith("sursă:")) {
                                        lucrare_actuala.sursa = i.substring(i.indexOf(":") + 1).trim().replace(/[ \n\t\r][ \n\t\r]+/g, "");
                                    }
                                }
                            } else if (autor_actual != null) { // continut biografie
                                let i = node.innerText, s = i.toLowerCase(), t = s.trim();
                                if (t.startsWith("nastere:") || t.startsWith("naștere:") || t.startsWith("naştere:")) {
                                    autor_actual.nastere = i.substring(i.indexOf(":") + 1).trim().replace(/[ \n\t\r][ \n\t\r]+/g, "");
                                } else if (t.startsWith("deces:")) {
                                    autor_actual.deces = i.substring(i.indexOf(":") + 1).trim().replace(/[ \n\t\r][ \n\t\r]+/g, "");
                                } else {
                                    autor_actual.biografieExplicativa += stripColors(node).outerHTML;
                                }
                            }
                        }
                        break;
                    case "SPAN":
                        if ("rgb(129,212,26)" === (node.style.backgroundColor || "").replace(/ /g, "") || "lime" === (node.style.backgroundColor || "").trim()) { // maxima
                            if (fragment_actual != null) {
                                if (maxima_actuala == null) {
                                    maxima_actuala = new Maxima();
                                    maxima_actuala.aspecte = fragment_actual.aspecte;
                                    maxima_actuala.aspectePrecizate = false;
                                    maxima_actuala.nodParinte = node.parentNode;
                                    fragment_actual.maxime.push(maxima_actuala);
                                }
                                let nodeClone = node.cloneNode(true);
                                // depistare aspecte
                                let trimmed = nodeClone.innerText.trim();
                                let startAspecte = trimmed.search(/{a[0-9]/);
                                let endAspecte = trimmed.indexOf("}", startAspecte);
                                let continut = stripColors(nodeClone).outerHTML;
                                if (startAspecte > -1 && endAspecte > startAspecte) { // caut aspecte
                                    if (maxima_actuala.aspectePrecizate) { // nevoie de o maixma noua
                                        maxima_actuala = new Maxima();
                                        fragment_actual.maxime.push(maxima_actuala);
                                    }
                                    maxima_actuala.aspecte = extrageAspecte(trimmed, startAspecte, endAspecte);
                                    maxima_actuala.aspectePrecizate = true;
                                    continut = stripAspecte(continut);
                                }
                                if (node.parentNode !== maxima_actuala.nodParinte) {
                                    maxima_actuala.nodParinte = node.parentNode;
                                    continut = "\n<br/>\n" + continut;
                                }
                                maxima_actuala.continut += continut;
                            }
                        } else {
                            maxima_actuala = null;
                        }
                }
            } else if (node.nodeType === Node.TEXT_NODE) {
                if (node.nodeValue.trim() !== "" && maxima_actuala !== null) { // verificam daca nu trebuie intrerupt
                    if (!("rgb(129,212,26)" === (node.parentNode.style.backgroundColor || "").replace(/ /g, "") || "lime" === (node.parentNode.style.backgroundColor || "").trim())) {
                        maxima_actuala = null;
                    }
                }
            }
        } while (walker.next());

        // strip multiple elipisis and empy start/end spaces
        autori.forEach(autor => {
            autor.lucrari.forEach(lucrare => {
                lucrare.fragmente.forEach(fragment => {
                    fragment.continut = trim(stripMultiEllipsis($("<div>" + fragment.continut + "</div>").get(0))).innerHTML;
                    fragment.continutDetaliat = trim($("<div>" + fragment.continutDetaliat + "</div>").get(0)).innerHTML;
                });
            });
        });


        autori.forEach(autor => {
            let findLinks = (text) => {
                const urlRegex = /(https?:\/\/[^\s<>]+)/g;
                let matches = [];
                text.replace(urlRegex, function(url) {
                    matches.push(url);
                })
                return matches;
            }
            let links = findLinks(autor.biografieExplicativa);
            let infoWikipedia = null;
            for (let i=0; i<links.length; i++) {
                if (links[i].indexOf("wikipedia") > -1) {
                    infoWikipedia = wikipedia.autor(links[i]);
                    if (infoWikipedia.found) {
                        break;
                    }
                }
            }
            let p2 = (p) => {
                return (p < 10 ? "0" : "") + p;
            }
            let formatDate = (date) => { // yyyy-mm-dd
                if (date) {
                    return date.getFullYear() + "-" + p2(date.getMonth() + 1) + "-" + p2(date.getDate())
                } else {
                    return "";
                }
            };
            if (infoWikipedia != null && infoWikipedia.found) {
                if (!autor.nastere) {
                    autor.nastere = "";
                    autor.nastere += formatDate(infoWikipedia.dataNasterii);
                    autor.nastere += (autor.nastere.length > 0 ? ", " : "") + infoWikipedia.loculNasterii;
                }
                if (!autor.deces) {
                    autor.deces = "";
                    autor.deces += formatDate(infoWikipedia.dataDecesului);
                    autor.deces += (autor.deces.length > 0 ? ", " : "") + infoWikipedia.loculDecesului;
                }
                if (!autor.poza) {
                    autor.poza = infoWikipedia.poza;
                }
            }
        });

        if (this.editorAutori != null) {
            this.editorAutori.remove();
        }

        this.editorAutori = new EditorAutori(autori);
        this.editorAutori.create(domTarget);

    }
}

