create table aspect
(
    id                    int identity constraint ASPECT_PK primary key,
    nume                  varchar(128) not null,
    cod                   varchar(8) not null,
    descriere_scurta      longvarchar,
    descriere_lunga       longvarchar
);

create unique index ASPECT_ID_UINDEX on aspect (id);
create unique index ASPECT_NUME_UINDEX on aspect (nume);
create unique index ASPECT_COD_UINDEX on aspect (cod);

insert into aspect (nume, cod, descriere_scurta) values ('Cotropire prădalnică',    'a00', 'Cucerire sistematică');
insert into aspect (nume, cod, descriere_scurta) values ('Invazie continuată',      'a01', 'Invazie continuată peste un secol');
insert into aspect (nume, cod, descriere_scurta) values ('Colonizări alogene',      'a02', 'Colonizări de-românizante, cu efect prelungit după reîntregire');
insert into aspect (nume, cod, descriere_scurta) values ('Sionism imperialist',     'a03', 'Dialectica imperialistă a sionismului-naţionalism al poporului ales');
insert into aspect (nume, cod, descriere_scurta) values ('Exclusivism etnic',       'a04', 'Exclusivism şi cameleonism (pseudo-asimilare)');
insert into aspect (nume, cod, descriere_scurta) values ('Pretinsă persecuţie',     'a05', 'Pretinsă persecuţie… de către victimele lor');
insert into aspect (nume, cod, descriere_scurta) values ('Holocaustizare',          'a06', 'Afacerea holocaustizării şi trucul combaterii antisemitismului');
insert into aspect (nume, cod, descriere_scurta) values ('Parazitism comercial',    'a07', 'Mercatilism parazitar, comercialism prădalnic');
insert into aspect (nume, cod, descriere_scurta) values ('Parazitism financiar',    'a08', 'Parazitism financiar dominator/devastator');
insert into aspect (nume, cod, descriere_scurta) values ('Ocuparea meseriilor',     'a09', 'Ocuparea meseriilor/industriei şi secătuirea colonială a resurselor');
insert into aspect (nume, cod, descriere_scurta) values ('Nimicirea satelor',       'a10', 'Distrugerea vieţii la ţară');
insert into aspect (nume, cod, descriere_scurta) values ('Năpădirea oraşelor',      'a11', 'Ocuparea oraşelor, universităţilor şi profesiilor');
insert into aspect (nume, cod, descriere_scurta) values ('Acapararea avuţiei',      'a12', 'Acapararea avuţiilor');
insert into aspect (nume, cod, descriere_scurta) values ('Degradare fizică',        'a13', 'Abordare corozivă, ce a provocat distrugerea fizică a românilor');
insert into aspect (nume, cod, descriere_scurta) values ('Degradare morală',        'a14', 'Degradarea morală, intelectuală şi culturală');
insert into aspect (nume, cod, descriere_scurta) values ('Ocupaţii necinstite',     'a15', 'Practica metodică a activităţilor necinsitite/ilicite');
insert into aspect (nume, cod, descriere_scurta) values ('Corupere metodică',       'a16', 'Coruperea birocraţilor/administraţiei');
insert into aspect (nume, cod, descriere_scurta) values ('Deturnarea statului',     'a17', 'Pervertirea democraţiei  şi deturnarea statalităţii');
insert into aspect (nume, cod, descriere_scurta) values ('Sluţirea civilizaţiei',   'a18', 'Distrugerea fiziologiei tradiţionale şi urîţirea civilizaţiei');
insert into aspect (nume, cod, descriere_scurta) values ('Anti-creştinism',         'a19', 'Religie/morală anti-creştină şi coruperea sudurii creştine');
insert into aspect (nume, cod, descriere_scurta) values ('Vrajbă fratricidă',       'a20', 'Provocarea şi asmuţirea învrăjbirii/dezbinării românilor, pînă la război civil');
insert into aspect (nume, cod, descriere_scurta) values ('Agenţii străinilor',      'a21', 'Agenţi ai cosmopolitismului şi mondializării (contra sudurii naţionale) şi instigatori ai minoritarilor');
insert into aspect (nume, cod, descriere_scurta) values ('Şantaj internaţional',    'a22', 'Şantaj întru încetăţenire forţată, dinspre lumea capturată de ei');
insert into aspect (nume, cod, descriere_scurta) values ('Joc ocult mondial',       'a23', 'Jocul ocult întru surparea oricărei puteri concurente');
insert into aspect (nume, cod, descriere_scurta) values ('Vicierea diplomaţiei',    'a24', 'Deturnarea politicii externe, de la interesele româneşti');
insert into aspect (nume, cod, descriere_scurta) values ('Atitudine în războie',    'a25', 'Lipsa de loialitate/ostilitatea în marile războaie');
insert into aspect (nume, cod, descriere_scurta) values ('Comunism genocidar',      'a26', 'Pregătirea şi instalarea/dezinstalarea comunismului');
insert into aspect (nume, cod, descriere_scurta) values ('Deturnarea eliberării',   'a27', 'Manipularea mişcărilor revoluţionare, cum ar fi cea decembrie 1989 - deturnată întru jaf şi împiedicarea judecării genocidului comunist');
insert into aspect (nume, cod, descriere_scurta) values ('Stîrpirea rezistenţei',   'a28', 'Denigrarea/reprimarea/exterminarea naţionaliştilor români');
insert into aspect (nume, cod, descriere_scurta) values ('Manipulare mediatică',    'a29', 'Dezinformare şi cenzură - întru promovarea intereselor de clan');
insert into aspect (nume, cod, descriere_scurta) values ('Dominaţie represivă',     'a30', 'Dominaţia la care s-a ajuns, in numele combaterii antisemitismului');

create table autor
(
    id                    int identity constraint AUTOR_PK primary key,
    nume                  varchar(32) not null,
    prenume               varchar(32) not null,
    nastere               varchar(1024),
    deces                 varchar(1024),
    poza                  longvarchar,
    biografie_explicativa longvarchar
);

create unique index AUTOR_ID_UINDEX on autor (id);
create unique index AUTOR_NUME_UINDEX on autor (nume, prenume);

create table lucrare
(
    id                    int identity constraint LUCRARE_PK primary key,
    id_autor              int,
    titlu                 varchar(1024) not null,
    publicatie            varchar(256),
    data                  varchar(256),
    sursa                 varchar(1024),
    foreign key (id_autor) references autor(id)
);

create table fragment
(
    id                    int identity constraint FRAGMENT_PK primary key,
    id_lucrare            int,
    continut              longvarchar,
    continut_detaliat     longvarchar,
    foreign key (id_lucrare) references lucrare(id)
);

create table aspecte_fragment
(
    id_fragment           int not null,
    id_aspect             int not null,
    foreign key (id_fragment) references fragment(id),
    foreign key (id_aspect)   references aspect(id)
);

create table maxima
(
    id                    int identity constraint MAXIMA_PK primary key,
    id_fragment           int,
    continut              longvarchar,
    foreign key (id_fragment) references fragment(id)
);

create table aspecte_maxima
(
    id_maxima             int not null,
    id_aspect             int not null,
    foreign key (id_maxima)   references maxima(id),
    foreign key (id_aspect)   references aspect(id)
);

--todo: add unicity constraints on Maxima




