/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.util;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cives.fresca.server.util.XContentLengthFilter;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.WebUtils;

public class XContentLengthFilter
extends OncePerRequestFilter {
    private static final String HEADER_NAME = "X-Content-Length";

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletResponse responseToUse = response;
        if (!this.isAsyncDispatch(request) && !(response instanceof ConditionalContentCachingResponseWrapper)) {
            responseToUse = new ConditionalContentCachingResponseWrapper(response, request);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)responseToUse);
        if (!this.isAsyncStarted(request)) {
            this.updateResponse(request, responseToUse);
        }
    }

    private void updateResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String xContentLength;
        ConditionalContentCachingResponseWrapper wrapper = (ConditionalContentCachingResponseWrapper)WebUtils.getNativeResponse((ServletResponse)response, ConditionalContentCachingResponseWrapper.class);
        Assert.notNull((Object)wrapper, (String)"ContentCachingResponseWrapper not found");
        HttpServletResponse rawResponse = (HttpServletResponse)wrapper.getResponse();
        if (this.isEligibleForXContentLength(request, (HttpServletResponse)wrapper, wrapper.getStatus(), wrapper.getContentInputStream()) && !StringUtils.hasText((String)(xContentLength = wrapper.getHeader(HEADER_NAME)))) {
            xContentLength = this.generateXContentLengthHeaderValue(wrapper.getContentInputStream());
            rawResponse.setHeader(HEADER_NAME, xContentLength);
        }
        wrapper.copyBodyToResponse();
    }

    protected boolean isEligibleForXContentLength(HttpServletRequest request, HttpServletResponse response, int responseStatusCode, InputStream inputStream) {
        return !response.isCommitted() && responseStatusCode >= 200 && responseStatusCode < 300 && HttpMethod.GET.matches(request.getMethod());
    }

    protected String generateXContentLengthHeaderValue(InputStream inputStream) throws IOException {
        int c;
        byte[] buf = new byte[8192];
        int length = 0;
        while ((c = inputStream.read(buf)) > 0) {
            length += c;
        }
        return Integer.toString(length);
    }
}

