/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.cives.fresca.server.model.Aspect;
import org.cives.fresca.server.model.AutorFragmentSummary;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class FrescaPreRenderer {
    @Cacheable(value={"summaries"})
    public String render(List<AutorFragmentSummary> fresca) {
        StringBuilder sb = new StringBuilder();
        int rowIdx = 1;
        char lastFirstLetter = '\n';
        for (AutorFragmentSummary line : fresca) {
            char firstLetter;
            sb.append("<tr data-row=\"" + rowIdx++ + "\" data-author-id=\"" + line.getAutor().getId() + "\">\n");
            sb.append(" <td data-column=\"0\" class=\"autor\">").append(line.getAutor().getPrenume()).append(" ").append(line.getAutor().getNume());
            char[] chars = line.getAutor().getNume().toCharArray();
            if (chars.length > 0 && (firstLetter = chars[0]) != lastFirstLetter) {
                lastFirstLetter = firstLetter;
                sb.append("<span class=\"badge badge-light letter-").append(firstLetter).append("\">").append(lastFirstLetter).append("</span>");
            }
            sb.append("</td>");
            int colIdx = 1;
            for (Integer nrFragmente : line.getNumarFragmentePerAspect().values()) {
                sb.append(" <td data-column=\"" + colIdx++ + "\">").append(nrFragmente > 0 ? "&#9632;" : "").append("</td>");
            }
            sb.append("</tr>\n");
        }
        return sb.toString();
    }

    public String renderToJSExpression(List<Aspect> aspecte) {
        ObjectMapper om = new ObjectMapper();
        try {
            return om.writerWithDefaultPrettyPrinter().writeValueAsString(aspecte);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

