/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.dao;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cives.fresca.server.dao.MaximaRepository;
import org.cives.fresca.server.model.Maxima;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class MaximaRepository {
    @Autowired
    private NamedParameterJdbcTemplate template;
    @Value(value="${sql.listaMaximeFragment}")
    private String listaMaximeFragmentSQL;
    @Value(value="${sql.listaAspecteMaximeFragment}")
    private String listaAspecteMaximeFragmentSQL;
    @Value(value="${sql.insertAspecteMaxima}")
    private String insertAspecteMaximaSQL;
    @Value(value="${sql.updateMaxima}")
    private String updateMaximaSQL;
    @Value(value="${sql.insertMaxima}")
    private String insertMaximaSQL;
    @Value(value="${sql.deleteAspecteMaxime}")
    private String deleteAspecteMaximeSQL;
    @Value(value="${sql.deleteMaxime}")
    private String deleteMaximeSQL;
    @Value(value="${sql.identity}")
    private String identitySQL;

    public List<Maxima> getMaximeFragment(int idFragment) {
        List maxime = this.template.query(this.listaMaximeFragmentSQL, Collections.singletonMap("id_fragment", idFragment), (rs, rowNum) -> new Maxima(rs.getInt("id"), rs.getString("continut")));
        HashMap map = new HashMap();
        maxime.forEach(f -> map.put(f.getId(), f));
        this.template.query(this.listaAspecteMaximeFragmentSQL, Collections.singletonMap("id_fragment", idFragment), (rs, rowNum) -> ((Maxima)map.get(rs.getInt("id_maxima"))).getAspecte().add(rs.getInt("id_aspect")));
        return maxime;
    }

    @Transactional
    public void saveMaxime(int idFragment, List<Maxima> maxime) {
        Set deSters = this.getMaximeFragment(idFragment).stream().map(Maxima::getId).collect(Collectors.toSet());
        deSters.removeAll(maxime.stream().map(Maxima::getId).collect(Collectors.toSet()));
        if (!deSters.isEmpty()) {
            this.template.update(this.deleteAspecteMaximeSQL, Collections.singletonMap("ids", deSters));
            this.template.update(this.deleteMaximeSQL, Collections.singletonMap("ids", deSters));
        }
        for (Maxima maxima : maxime) {
            1 parameters = new /* Unavailable Anonymous Inner Class!! */;
            if (maxima.getId() >= 0) {
                this.template.update(this.updateMaximaSQL, (Map)parameters);
            } else {
                this.template.update(this.insertMaximaSQL, (Map)parameters);
                maxima.setId(((Integer)this.template.queryForObject(this.identitySQL, Collections.emptyMap(), Integer.class)).intValue());
            }
            this.saveAspecteMaxima(maxima.getId(), maxima.getAspecte());
        }
    }

    @Transactional
    public void saveAspecteMaxima(int idMaxima, List<Integer> aspecte) {
        LinkedList<2> parameters = new LinkedList<2>();
        for (Integer aspect : aspecte) {
            parameters.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        this.template.batchUpdate(this.deleteAspecteMaximeSQL, new Map[]{Collections.singletonMap("ids", Collections.singleton(idMaxima))});
        this.template.batchUpdate(this.insertAspecteMaximaSQL, parameters.toArray(new Map[0]));
    }
}

