/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.dao;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cives.fresca.server.dao.FragmentRepository;
import org.cives.fresca.server.dao.LucrareRepository;
import org.cives.fresca.server.model.Lucrare;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class LucrareRepository {
    @Autowired
    private NamedParameterJdbcTemplate template;
    @Value(value="${sql.listaLucrari}")
    private String listaLucrariSQL;
    @Value(value="${sql.listaLucrariAutor}")
    private String listaLucrariAutorSQL;
    @Value(value="${sql.updateLucrare}")
    private String updateLucrareSQL;
    @Value(value="${sql.insertLucrare}")
    private String insertLucrareSQL;
    @Value(value="${sql.deleteAspecteMaximeFragmenteLucrari}")
    private String deleteAspecteMaximeFragmenteLucrariSQL;
    @Value(value="${sql.deleteMaximeLucrari}")
    private String deleteMaximeLucrariSQL;
    @Value(value="${sql.deleteAspecteFragmenteLucrari}")
    private String deleteAspecteFragmenteLucrariSQL;
    @Value(value="${sql.deleteFragmenteLucrari}")
    private String deleteFragmenteLucrariSQL;
    @Value(value="${sql.deleteLucrari}")
    private String deleteLucrariSQL;
    @Value(value="${sql.identity}")
    private String identitySQL;
    @Autowired
    private FragmentRepository fragmentRepository;

    public List<Lucrare> getLucrari() {
        return this.template.query(this.listaLucrariSQL, (rs, rowNum) -> new Lucrare(rs.getInt("id"), rs.getString("titlu"), rs.getString("publicatie"), rs.getString("data"), rs.getString("sursa")));
    }

    public List<Lucrare> getLucrariAutor(int idAutor) {
        return this.template.query(this.listaLucrariAutorSQL, Collections.singletonMap("id_autor", idAutor), (rs, rowNum) -> new Lucrare(rs.getInt("id"), rs.getString("titlu"), rs.getString("publicatie"), rs.getString("data"), rs.getString("sursa")));
    }

    public List<Lucrare> getLucrariAutorDeep(int idAutor) {
        List lucrariAutor = this.getLucrariAutor(idAutor);
        for (Lucrare lucrare : lucrariAutor) {
            lucrare.setFragmente(this.fragmentRepository.getFragmenteLucrareDeep(lucrare.getId()));
        }
        return lucrariAutor;
    }

    @Transactional
    public void saveLucrari(int idAutor, List<Lucrare> lucrari) {
        Set deSters = this.getLucrariAutor(idAutor).stream().map(a -> a.getId()).collect(Collectors.toSet());
        deSters.removeAll(lucrari.stream().map(Lucrare::getId).collect(Collectors.toSet()));
        if (!deSters.isEmpty()) {
            this.template.update(this.deleteAspecteMaximeFragmenteLucrariSQL, Collections.singletonMap("ids", deSters));
            this.template.update(this.deleteMaximeLucrariSQL, Collections.singletonMap("ids", deSters));
            this.template.update(this.deleteAspecteFragmenteLucrariSQL, Collections.singletonMap("ids", deSters));
            this.template.update(this.deleteFragmenteLucrariSQL, Collections.singletonMap("ids", deSters));
            this.template.update(this.deleteLucrariSQL, Collections.singletonMap("ids", deSters));
        }
        for (Lucrare lucrare : lucrari) {
            1 parameters = new /* Unavailable Anonymous Inner Class!! */;
            if (lucrare.getId() >= 0) {
                this.template.update(this.updateLucrareSQL, (Map)parameters);
            } else {
                this.template.update(this.insertLucrareSQL, (Map)parameters);
                lucrare.setId(((Integer)this.template.queryForObject(this.identitySQL, Collections.emptyMap(), Integer.class)).intValue());
            }
            this.fragmentRepository.saveFragmente(lucrare.getId(), lucrare.getFragmente());
        }
    }
}

