/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.dao;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.cives.fresca.server.dao.AspectRepository;
import org.cives.fresca.server.dao.AutorRepository;
import org.cives.fresca.server.model.Aspect;
import org.cives.fresca.server.model.AutorFragmentSummary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.comparator.Comparators;

@Service
public class FrescaDao {
    @Autowired
    private AutorRepository autorRepository;
    @Autowired
    private AspectRepository aspectRepository;
    @Autowired
    private NamedParameterJdbcTemplate template;
    @Value(value="${sql.getFresca}")
    private String getFrescaSQL;

    @Cacheable(value={"summaries"})
    public List<AutorFragmentSummary> getSummaryFresca() {
        List aspecte = this.aspectRepository.getAspecte();
        List<AutorFragmentSummary> summaryFresca = this.autorRepository.getAutoriSinteza().stream().map(autor -> {
            LinkedHashMap<Integer, Integer> numarFragmentePerAspect = new LinkedHashMap<Integer, Integer>();
            for (Aspect aspect : aspecte) {
                numarFragmentePerAspect.put(aspect.getId(), 0);
            }
            AutorFragmentSummary summary = new AutorFragmentSummary(autor, numarFragmentePerAspect);
            return summary;
        }).collect(Collectors.toList());
        PeekingIterator summaryIterator = PeekingIterator.peekingIterator(summaryFresca.stream().sorted((a, b) -> Comparators.comparable().compare(a.getAutor().getId(), b.getAutor().getId())).iterator());
        this.template.query(this.getFrescaSQL, rs -> {
            AutorFragmentSummary summary;
            int idAutor = rs.getInt("id_autor");
            int idAspect = rs.getInt("id_aspect");
            int nrFragmente = rs.getInt("nr_fragmente");
            while ((summary = (AutorFragmentSummary)summaryIterator.peek()).getAutor().getId() != idAutor) {
                summaryIterator.next();
            }
            summary.getNumarFragmentePerAspect().put(idAspect, nrFragmente);
        });
        return summaryFresca;
    }
}

