/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.dao;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cives.fresca.server.dao.FragmentRepository;
import org.cives.fresca.server.dao.MaximaRepository;
import org.cives.fresca.server.model.Fragment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FragmentRepository {
    @Autowired
    private NamedParameterJdbcTemplate template;
    @Autowired
    private MaximaRepository maximaRepository;
    @Value(value="${sql.listaFragmenteLucrare}")
    private String listaFragmenteLucrareSQL;
    @Value(value="${sql.listaAspecteFragmenteLucrare}")
    private String listaAspecteFragmenteLucrareSQL;
    @Value(value="${sql.insertAspecteFragment}")
    private String insertAspecteFragmentSQL;
    @Value(value="${sql.updateFragment}")
    private String updateFragmentSQL;
    @Value(value="${sql.insertFragment}")
    private String insertFragmentSQL;
    @Value(value="${sql.deleteAspecteMaximeFragmente}")
    private String deleteAspecteMaximeFragmenteSQL;
    @Value(value="${sql.deleteMaximeFragmente}")
    private String deleteMaximeFragmenteSQL;
    @Value(value="${sql.deleteAspecteFragmente}")
    private String deleteAspecteFragmenteSQL;
    @Value(value="${sql.deleteFragmente}")
    private String deleteFragmenteSQL;
    @Value(value="${sql.identity}")
    private String identitySQL;

    public List<Fragment> getFragmenteLucrare(int idLucrare) {
        List fragmente = this.template.query(this.listaFragmenteLucrareSQL, Collections.singletonMap("id_lucrare", idLucrare), (rs, rowNum) -> new Fragment(rs.getInt("id"), rs.getString("continut"), rs.getString("continut_detaliat")));
        HashMap map = new HashMap();
        fragmente.forEach(f -> map.put(f.getId(), f));
        this.template.query(this.listaAspecteFragmenteLucrareSQL, Collections.singletonMap("id_lucrare", idLucrare), (rs, rowNum) -> ((Fragment)map.get(rs.getInt("id_fragment"))).getAspecte().add(rs.getInt("id_aspect")));
        return fragmente;
    }

    public List<Fragment> getFragmenteLucrareDeep(int idLucrare) {
        List fragmenteLucrare = this.getFragmenteLucrare(idLucrare);
        for (Fragment fragment : fragmenteLucrare) {
            fragment.setMaxime(this.maximaRepository.getMaximeFragment(fragment.getId()));
        }
        return fragmenteLucrare;
    }

    @Transactional
    public void saveFragmente(int idLucrare, List<Fragment> fragmente) {
        Set deSters = this.getFragmenteLucrare(idLucrare).stream().map(Fragment::getId).collect(Collectors.toSet());
        deSters.removeAll(fragmente.stream().map(Fragment::getId).collect(Collectors.toSet()));
        if (!deSters.isEmpty()) {
            this.template.update(this.deleteAspecteMaximeFragmenteSQL, Collections.singletonMap("ids", deSters));
            this.template.update(this.deleteMaximeFragmenteSQL, Collections.singletonMap("ids", deSters));
            this.template.update(this.deleteAspecteFragmenteSQL, Collections.singletonMap("ids", deSters));
            this.template.update(this.deleteFragmenteSQL, Collections.singletonMap("ids", deSters));
        }
        for (Fragment fragment : fragmente) {
            1 parameters = new /* Unavailable Anonymous Inner Class!! */;
            if (fragment.getId() >= 0) {
                this.template.update(this.updateFragmentSQL, (Map)parameters);
            } else {
                this.template.update(this.insertFragmentSQL, (Map)parameters);
                fragment.setId(((Integer)this.template.queryForObject(this.identitySQL, Collections.emptyMap(), Integer.class)).intValue());
            }
            this.saveAspecteFragment(fragment.getId(), fragment.getAspecte());
            this.maximaRepository.saveMaxime(fragment.getId(), fragment.getMaxime());
        }
    }

    @Transactional
    public void saveAspecteFragment(int idFragment, List<Integer> aspecte) {
        LinkedList<2> parameters = new LinkedList<2>();
        for (Integer aspect : aspecte) {
            parameters.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        this.template.batchUpdate(this.deleteAspecteFragmenteSQL, new Map[]{Collections.singletonMap("ids", Collections.singleton(idFragment))});
        this.template.batchUpdate(this.insertAspecteFragmentSQL, parameters.toArray(new Map[0]));
    }
}

