/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.dao;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cives.fresca.server.dao.AutorRepository;
import org.cives.fresca.server.dao.LucrareRepository;
import org.cives.fresca.server.model.Autor;
import org.cives.fresca.server.model.SintezaBaza;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class AutorRepository {
    @Autowired
    private NamedParameterJdbcTemplate template;
    @Autowired
    private LucrareRepository lucrareRepository;
    @Value(value="${sql.getAutor}")
    private String getAutorSQL;
    @Value(value="${sql.listaAutori}")
    private String listaAutoriSQL;
    @Value(value="${sql.listaAutoriSinteza}")
    private String listaAutoriSintezaSQL;
    @Value(value="${sql.sintezaBaza}")
    private String sintezaBazaSQL;
    @Value(value="${sql.sintezaLucrariAutori}")
    private String sintezaLucrariAutoriSQL;
    @Value(value="${sql.sintezaFragmenteAutori}")
    private String sintezaFragmenteAutoriSQL;
    @Value(value="${sql.sintezaMaximeAutori}")
    private String sintezaMaximeAutoriSQL;
    @Value(value="${sql.updateAutor}")
    private String updateAutorSQL;
    @Value(value="${sql.insertAutor}")
    private String insertAutorSQL;
    @Value(value="${sql.deleteLucrariAutori}")
    private String deleteLucrariAutoriSQL;
    @Value(value="${sql.deleteAspecteMaximeFragmenteLucrariAutor}")
    private String deleteAspecteMaximeFragmenteLucrariAutorSQL;
    @Value(value="${sql.deleteMaximeLucrariAutor}")
    private String deleteMaximeLucrariAutorSQL;
    @Value(value="${sql.deleteAspecteFragmenteLucrariAutor}")
    private String deleteAspecteFragmenteLucrariAutorSQL;
    @Value(value="${sql.deleteFragmenteLucrariAutor}")
    private String deleteFragmenteLucrariAutorSQL;
    @Value(value="${sql.deleteAutori}")
    private String deleteAutoriSQL;
    @Value(value="${sql.identity}")
    private String identitySQL;

    public List<Autor> getAutori() {
        return this.template.query(this.listaAutoriSQL, (rs, rowNum) -> new Autor(rs.getInt("id"), rs.getString("nume"), rs.getString("prenume"), rs.getString("nastere"), rs.getString("deces"), rs.getString("poza"), rs.getString("biografie_explicativa")));
    }

    public Autor getAutor(Integer id, boolean deep) {
        Autor autor = (Autor)this.template.queryForObject(this.getAutorSQL, Collections.singletonMap("id", id), (rs, rowNum) -> new Autor(rs.getInt("id"), rs.getString("nume"), rs.getString("prenume"), rs.getString("nastere"), rs.getString("deces"), rs.getString("poza"), rs.getString("biografie_explicativa")));
        if (autor != null) {
            autor.setLucrari(deep ? this.lucrareRepository.getLucrariAutorDeep(id.intValue()) : this.lucrareRepository.getLucrariAutor(id.intValue()));
        }
        return autor;
    }

    public List<Autor> getAutoriSinteza() {
        return this.template.query(this.listaAutoriSintezaSQL, (rs, rowNum) -> new Autor(rs.getInt("id"), rs.getString("nume"), rs.getString("prenume"), rs.getString("nastere"), rs.getString("deces"), null, null));
    }

    public SintezaBaza getSintezaBaza() {
        return (SintezaBaza)this.template.queryForObject(this.sintezaBazaSQL, Collections.emptyMap(), (rs, rowNum) -> new SintezaBaza(rs.getInt("nr_aspecte"), rs.getInt("nr_autori"), rs.getInt("nr_lucrari"), rs.getInt("nr_fragmente"), rs.getInt("nr_maxime"), rs.getInt("nr_aspecte_fragment"), rs.getInt("nr_aspecte_maxima")));
    }

    @Transactional
    public void saveAutori(List<Autor> autori) {
        for (Autor autor : autori) {
            1 parameters = new /* Unavailable Anonymous Inner Class!! */;
            if (autor.getId() >= 0) {
                this.template.update(this.updateAutorSQL, (Map)parameters);
            } else {
                this.template.update(this.insertAutorSQL, (Map)parameters);
                autor.setId(((Integer)this.template.queryForObject(this.identitySQL, Collections.emptyMap(), Integer.class)).intValue());
            }
            this.lucrareRepository.saveLucrari(autor.getId(), autor.getLucrari());
        }
    }

    public void stergeAutor(Integer id) {
        this.template.update(this.deleteAspecteMaximeFragmenteLucrariAutorSQL, Collections.singletonMap("ids", Collections.singleton(id)));
        this.template.update(this.deleteAspecteFragmenteLucrariAutorSQL, Collections.singletonMap("ids", Collections.singleton(id)));
        this.template.update(this.deleteMaximeLucrariAutorSQL, Collections.singletonMap("ids", Collections.singleton(id)));
        this.template.update(this.deleteFragmenteLucrariAutorSQL, Collections.singletonMap("ids", Collections.singleton(id)));
        this.template.update(this.deleteLucrariAutoriSQL, Collections.singletonMap("ids", Collections.singleton(id)));
        this.template.update(this.deleteAutoriSQL, Collections.singletonMap("ids", Collections.singleton(id)));
    }

    public Map<Integer, Integer> getSintezaLucrari() {
        LinkedHashMap<Integer, Integer> sinteza = new LinkedHashMap<Integer, Integer>();
        this.template.query(this.sintezaLucrariAutoriSQL, Collections.emptyMap(), rs -> sinteza.put(rs.getInt("autor"), rs.getInt("numar")));
        return sinteza;
    }

    public Map<Integer, Integer> getSintezaFragmente() {
        LinkedHashMap<Integer, Integer> sinteza = new LinkedHashMap<Integer, Integer>();
        this.template.query(this.sintezaFragmenteAutoriSQL, Collections.emptyMap(), rs -> sinteza.put(rs.getInt("autor"), rs.getInt("numar")));
        return sinteza;
    }

    public Map<Integer, Integer> getSintezaMaxime() {
        LinkedHashMap<Integer, Integer> sinteza = new LinkedHashMap<Integer, Integer>();
        this.template.query(this.sintezaMaximeAutoriSQL, Collections.emptyMap(), rs -> sinteza.put(rs.getInt("autor"), rs.getInt("numar")));
        return sinteza;
    }
}

