/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.dao;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cives.fresca.server.dao.AspectRepository;
import org.cives.fresca.server.model.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class AspectRepository {
    @Autowired
    private NamedParameterJdbcTemplate template;
    @Value(value="${sql.listaAspecte}")
    private String listaAspecteSQL;
    @Value(value="${sql.updateAspect}")
    private String updateAspectSQL;
    @Value(value="${sql.insertAspect}")
    private String insertAspectSQL;
    @Value(value="${sql.deleteAspecte}")
    private String deleteAspecteSQL;

    public List<Aspect> getAspecte() {
        return this.template.query(this.listaAspecteSQL, (rs, rowNum) -> new Aspect(rs.getInt("id"), rs.getString("cod"), rs.getString("nume"), rs.getString("descriere_scurta"), rs.getString("descriere_lunga")));
    }

    @Transactional
    public void saveAspecte(List<Aspect> aspecte) {
        HashSet<1> updates = new HashSet<1>();
        HashSet inserts = new HashSet();
        Set aspecteDeEliminat = this.getAspecte().stream().map(Aspect::getId).collect(Collectors.toSet());
        aspecteDeEliminat.removeAll(aspecte.stream().map(Aspect::getId).collect(Collectors.toSet()));
        for (Aspect aspect : aspecte) {
            (aspect.getId() >= 0 ? updates : inserts).add(new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!aspecteDeEliminat.isEmpty()) {
            this.template.update(this.deleteAspecteSQL, Collections.singletonMap("ids", aspecteDeEliminat));
        }
        if (!inserts.isEmpty()) {
            this.template.batchUpdate(this.insertAspectSQL, inserts.toArray(new Map[0]));
        }
        if (!updates.isEmpty()) {
            this.template.batchUpdate(this.updateAspectSQL, updates.toArray(new Map[0]));
        }
    }
}

