/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.controllers;

import java.io.IOException;
import org.apache.hc.client5.http.fluent.Content;
import org.apache.hc.client5.http.fluent.Request;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ProxyController {
    @Secured(value={"ADMIN"})
    @RequestMapping(method={RequestMethod.GET}, value={"/proxy/json/{url}"}, produces={"application/json"})
    @ResponseBody
    public String jsonProxyGet(@PathVariable(value="url") String base64URL) throws IOException {
        return this.get(base64URL, MediaType.APPLICATION_JSON);
    }

    @Secured(value={"ADMIN"})
    @RequestMapping(method={RequestMethod.GET}, value={"/proxy/html/{url}"}, produces={"text/html"})
    @ResponseBody
    public String htmlProxyGet(@PathVariable(value="url") String base64URL) throws IOException {
        return this.get(base64URL, MediaType.TEXT_HTML);
    }

    @Secured(value={"ADMIN"})
    @RequestMapping(method={RequestMethod.GET}, value={"/proxy/binary/{url}"})
    @ResponseBody
    public ResponseEntity<byte[]> binaryProxyGet(@PathVariable(value="url") String base64URL) throws IOException {
        Content content = Request.get((String)new String(Base64Utils.decodeFromUrlSafeString((String)base64URL))).execute().returnContent();
        return ResponseEntity.ok().contentType(MediaType.asMediaType((MimeType)MimeType.valueOf((String)content.getType().getMimeType()))).body((Object)content.asBytes());
    }

    private String get(String base64URL, MediaType mediaType) throws IOException {
        return Request.get((String)new String(Base64Utils.decodeFromUrlSafeString((String)base64URL))).addHeader("Accept", mediaType.getType()).execute().returnContent().asString();
    }
}

