/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.controllers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.cives.fresca.server.dao.AspectRepository;
import org.cives.fresca.server.dao.AutorRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdminController {
    @Autowired
    private AspectRepository aspectRepository;
    @Autowired
    private AutorRepository autorRepository;

    @RequestMapping(value={"/admin"})
    public String admin() {
        return "redirect:/admin/";
    }

    @RequestMapping(value={"/admin/"})
    public ModelAndView index() {
        ModelAndView mv = new ModelAndView("admin/index");
        mv.addObject("sintezaBaza", (Object)this.autorRepository.getSintezaBaza());
        return mv;
    }

    @RequestMapping(value={"/admin/aspecte/lista"})
    public ModelAndView listaAspecte() {
        ModelAndView mv = new ModelAndView("admin/aspecte/lista");
        mv.addObject("aspecte", (Object)this.aspectRepository.getAspecte());
        return mv;
    }

    @RequestMapping(value={"/admin/autori/lista"})
    public ModelAndView listaAutori() {
        ModelAndView mv = new ModelAndView("admin/autori/lista");
        mv.addObject("autori", (Object)this.autorRepository.getAutoriSinteza());
        mv.addObject("lucrari", (Object)this.stringifyKey(this.autorRepository.getSintezaLucrari()));
        mv.addObject("fragmente", (Object)this.stringifyKey(this.autorRepository.getSintezaFragmente()));
        mv.addObject("maxime", (Object)this.stringifyKey(this.autorRepository.getSintezaMaxime()));
        return mv;
    }

    @RequestMapping(value={"/admin/autori/{id}/stergere"})
    @Secured(value={"ADMIN"})
    @CacheEvict(value={"summaries"}, allEntries=true)
    public String stergereAutor(@PathVariable(value="id") Integer id) {
        this.autorRepository.stergeAutor(id);
        return "redirect:/admin/autori/lista";
    }

    @RequestMapping(value={"/admin/autori/{id}/editare"})
    public ModelAndView editareAutor(@PathVariable(value="id") Integer id) {
        ModelAndView mv = new ModelAndView("admin/autori/editare");
        mv.addObject("idAutor", (Object)id);
        return mv;
    }

    @RequestMapping(value={"/admin/autori/adaugare"})
    public String adaugareAutor() {
        return "admin/autori/adaugare";
    }

    private Map<String, Integer> stringifyKey(Map<Integer, Integer> m) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        m.forEach((key, value) -> map.put("" + key, (Integer)value));
        return map;
    }

    @RequestMapping(value={"/admin/word-import"})
    public String wordImport() {
        return "admin/word-import";
    }
}

