/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server.controllers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cives.fresca.server.dao.AspectRepository;
import org.cives.fresca.server.dao.AutorRepository;
import org.cives.fresca.server.dao.LucrareRepository;
import org.cives.fresca.server.model.Aspect;
import org.cives.fresca.server.model.Autor;
import org.cives.fresca.server.model.Fragment;
import org.cives.fresca.server.model.L1Autor;
import org.cives.fresca.server.model.L2Autor;
import org.cives.fresca.server.model.Lucrare;
import org.cives.fresca.server.model.Maxima;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class APIController {
    @Autowired
    private AspectRepository aspectRepository;
    @Autowired
    private AutorRepository autorRepository;
    @Autowired
    private LucrareRepository lucrareRepository;

    @ResponseBody
    @GetMapping(value={"/aspecte"})
    public List<Aspect> listaAspecte() {
        return this.aspectRepository.getAspecte();
    }

    @ResponseBody
    @GetMapping(value={"/autor/{id}"})
    public Autor autor(@PathVariable(value="id") Integer idAutor, @RequestParam(value="deep", defaultValue="true") Boolean deep) {
        return this.autorRepository.getAutor(idAutor, deep.booleanValue());
    }

    @ResponseBody
    @GetMapping(value={"/autor/{idAutori}/l1"})
    public Map<Integer, L1Autor> autorL1(@PathVariable(value="idAutori") List<Integer> idAutori) {
        LinkedHashMap<Integer, L1Autor> situatii = new LinkedHashMap<Integer, L1Autor>();
        for (Integer idAutor : idAutori) {
            L1Autor situatieAutor = new L1Autor();
            List lucrariAutor = this.lucrareRepository.getLucrariAutorDeep(idAutor.intValue());
            for (Lucrare lucrare : lucrariAutor) {
                situatieAutor.adaugaLucrare(lucrare);
                for (Fragment fragment : lucrare.getFragmente()) {
                    for (Integer idAspect : fragment.getAspecte()) {
                        situatieAutor.adaugaFragment(idAspect, fragment, lucrare);
                    }
                    for (Maxima maxima : fragment.getMaxime()) {
                        for (Integer idAspect : fragment.getAspecte()) {
                            situatieAutor.adaugaMaxima(idAspect, maxima, fragment, lucrare);
                        }
                    }
                }
            }
            situatii.put(idAutor, situatieAutor);
        }
        return situatii;
    }

    @ResponseBody
    @GetMapping(value={"/autor/{idAutori}/l2"})
    public Map<Integer, L2Autor> autorL2(@PathVariable(value="idAutori") List<Integer> idAutori) {
        LinkedHashMap<Integer, L2Autor> situatii = new LinkedHashMap<Integer, L2Autor>();
        for (Integer idAutor : idAutori) {
            L2Autor situatieAutor = new L2Autor();
            List lucrariAutor = this.lucrareRepository.getLucrariAutorDeep(idAutor.intValue());
            for (Lucrare lucrare : lucrariAutor) {
                situatieAutor.adaugaLucrare(lucrare);
                for (Fragment fragment : lucrare.getFragmente()) {
                    for (Integer idAspect : fragment.getAspecte()) {
                        situatieAutor.adaugaFragment(idAspect, fragment, lucrare);
                    }
                }
            }
            situatii.put(idAutor, situatieAutor);
        }
        return situatii;
    }

    @Secured(value={"ADMIN"})
    @ResponseBody
    @PostMapping(value={"/save/aspecte"})
    @CacheEvict(value={"summaries"}, allEntries=true)
    public String salveazaAspecte(@RequestBody List<Aspect> aspecte) {
        this.aspectRepository.saveAspecte(aspecte);
        return "OK";
    }

    @Secured(value={"ADMIN"})
    @ResponseBody
    @PostMapping(value={"/save/autori"})
    @CacheEvict(value={"summaries"}, allEntries=true)
    public String salveazaAutori(@RequestBody List<Autor> autori) {
        this.autorRepository.saveAutori(autori);
        return "OK";
    }
}

