/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
public class WebSecurityConfiguration {
    @Value(value="${admin.username}")
    private String adminUsername;
    @Value(value="${admin.password}")
    private String adminPassword;
    @Value(value="${admin.enabled}")
    private Boolean adminEnabled;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable()).authorizeRequests().antMatchers(new String[]{"/", "/autor", "/aspecte", "/js/**", "/css/**"})).permitAll().antMatchers(new String[]{"/admin/**"})).hasRole("ADMIN").and()).httpBasic().and()).build();
    }

    @Bean
    public UserDetailsService userDetailsService() {
        UserDetails user = User.withDefaultPasswordEncoder().username(this.adminUsername).password(this.adminPassword).roles(new String[]{"ADMIN"}).build();
        return new InMemoryUserDetailsManager(new UserDetails[]{user});
    }
}

