/*
 * Decompiled with CFR 0.152.
 */
package org.cives.fresca.server;

import freemarker.template.TemplateException;
import java.io.IOException;
import org.cives.fresca.server.util.XContentLengthFilter;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
@EnableWebMvc
@EnableCaching
@PropertySource(value={"classpath:sql.properties"})
public class WebConfiguration
implements WebMvcConfigurer {
    @Bean
    public FreeMarkerConfigurer freeMarkerConfigurer() throws IOException, TemplateException {
        FreeMarkerConfigurer freeMarkerConfigurer = new FreeMarkerConfigurer();
        freeMarkerConfigurer.setTemplateLoaderPath("classpath:/templates");
        freeMarkerConfigurer.setDefaultEncoding("UTF-8");
        freemarker.template.Configuration configuration = freeMarkerConfigurer.createConfiguration();
        configuration.setAPIBuiltinEnabled(true);
        freeMarkerConfigurer.setConfiguration(configuration);
        return freeMarkerConfigurer;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/js/**"}).addResourceLocations(new String[]{"classpath:/static/js/"}).setCacheControl(CacheControl.noCache());
        registry.addResourceHandler(new String[]{"/css/**"}).addResourceLocations(new String[]{"classpath:/static/css/"}).setCacheControl(CacheControl.noCache());
        registry.addResourceHandler(new String[]{"/img/**"}).addResourceLocations(new String[]{"classpath:/static/img/"}).setCacheControl(CacheControl.noCache());
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/"}).setCacheControl(CacheControl.noCache());
    }

    @Bean
    public XContentLengthFilter xContentLengthFilter() {
        return new XContentLengthFilter();
    }
}

