package com.ease.gsms.server.services.dispatch;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertArrayEquals;

public class BinBalancerTest {

    @Test
    public void testBalanceBin1() {

        assertArrayEquals(
                new int[] { 233, 233, 235, 233, 233, 500 },
                BinBalancer.balance(
                        1000,
                        new int[] { 30, 7, 0, 30, 100, 500 }
                )
        );

    }

    @Test
    public void testBalanceBin1Delta() {

        assertArrayEquals(
                new int[] { 203, 226, 235, 203, 133, 0 },
                BinBalancer.balanceDelta(
                        1000,
                        new int[] { 30, 7, 0, 30, 100, 500 }
                )
        );

    }

    @Test
    public void testBalanceBin2() {

        assertArrayEquals(
                new int[] { 140, 140, 140, 140, 140, 500 },
                BinBalancer.balance(
                        533,
                        new int[] { 30, 7, 0, 30, 100, 500 }
                )
        );

    }

    @Test
    public void testBalanceBin3() {

        assertArrayEquals(
                new int[] { 500, 500, 500, 500, 500, 500 },
                BinBalancer.balance(
                        2333,
                        new int[] { 30, 7, 0, 30, 100, 500 }
                )
        );

    }

    @Test
    public void testBalanceBin4() {

        assertArrayEquals(
                new int[] { 500, 500, 501, 500, 500, 500 },
                BinBalancer.balance(
                        2334,
                        new int[] { 30, 7, 0, 30, 100, 500 }
                )
        );

    }

    @Test
    public void testBalanceBin5() {

        assertArrayEquals(
                new int[] { 500, 500, 505, 500, 500, 500 },
                BinBalancer.balance(
                        2338,
                        new int[] { 30, 7, 0, 30, 100, 500 }
                )
        );

    }

    @Test
    public void testBalanceBin6() {

        assertArrayEquals(
                new int[] { 501, 501, 501, 501, 501, 501 },
                BinBalancer.balance(
                        2339,
                        new int[] { 30, 7, 0, 30, 100, 500 }
                )
        );

    }

}
