cordova.define("ease-sms-plugin.Sms", function(require, exports, module) {
'use strict';

var exec = require('cordova/exec');

var sms = {
    handlers: {},
    resultCodeMapToStatusId(statusCodeMap) {

        var combinedStatusId = 0;

        Object.keys(statusCodeMap).forEach(statusCode => {
            statusCode = Number(statusCode);
            combinedStatusId += statusCodeMap[statusCode] > 0 ? 1 << (1 + statusCode) : 0;
        });

        return combinedStatusId;

    },
    enhanceWithStatusId(info) {
        info.statusId = this.resultCodeMapToStatusId(info.resultCodes);
        return info;
    },
    send(phone, subscriptionId, message, sendComplete, sendFailed, requestDeliveryReport, deliveryComplete) {
        console.log("Sending message to subscriptionId: " + subscriptionId + ", phone " + phone + ", requestDeliveryReport " + requestDeliveryReport);
        exec(
            (sendingInfo) => {
                if (requestDeliveryReport) {
                    this.handlers[sendingInfo.messageUUID] = {
                        delivered: (deliveryInfo) => {
                            console.log("SMS delivery info: " + JSON.stringify(deliveryInfo));
                            deliveryComplete(this.enhanceWithStatusId(deliveryInfo));
                            delete this.handlers[deliveryInfo.messageUUID];
                        }
                    };
                }
                console.log("SMS sending info: " + JSON.stringify(sendingInfo));
                sendComplete(this.enhanceWithStatusId(sendingInfo));
            },
            (error) => {
                console.log(error);
                sendFailed({
                    messageUUID: null,
                    error: error,
                    statusId: 1 << 14 // smallint for status id
                });
            },
            'Sms',
            'send', [phone, subscriptionId, message, requestDeliveryReport]
        );
    },
    hasPermission(success, failure) {
        // fire
        exec(
            success,
            failure,
            'Sms',
            'has_permission', []
        );
    },
    requestPermission(success, failure) {
        // fire
        exec(
            success,
            failure,
            'Sms',
            'request_permission', []
        );
    }
};

module.exports = sms;
});
