package com.ease.gsms.server.services.dispatch;

import com.ease.gsms.server.model.Dispatch;
import com.ease.gsms.server.model.Message;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Task implements Iterator<Message> {

    List<Message> messages;

    Iterator<Message> messageIterator;

    Dispatch dispatch;

    boolean exclusive;

    int weight;

    public Task(Dispatch dispatch, boolean exclusive, List<Message> messages) {
        this.dispatch = dispatch;
        this.exclusive = exclusive;
        this.weight = messages.size();
        this.messages = messages;
        messageIterator = messages.iterator();
    }

    public int getWeight() {
        return weight;
    }

    public List<Message> getMessages() {
        return messages;
    }

    public Dispatch getDispatch() {
        return dispatch;
    }

    public boolean isExclusive() {
        return exclusive;
    }

    @Override
    public boolean hasNext() {
        return messageIterator.hasNext();
    }

    @Override
    public Message next() {
        return messageIterator.next();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Task task = (Task) o;
        return exclusive == task.exclusive && weight == task.weight && Objects.equals(messages, task.messages);
    }

}
