package com.ease.gsms.server.services.dispatch;

import java.util.*;

public class Allocation implements Iterator<Task> {

    private List<Task> tasks = new ArrayList<>();

    private MessageSender worker;

    private int weight = 0;

    private UUID uuid;

    private int currentTaskIndex = -1;

    public Allocation(MessageSender worker) {

        this.worker = worker;

        this.uuid = UUID.randomUUID();

    }

    void addTask(Task task) {

        weight += task.getWeight();

        tasks.add(task);

    }

    public int getWeight() {
        return weight;
    }

    public List<Task> getTasks() {

        return tasks;

    }

    public UUID getUuid() {
        return uuid;
    }

    @Override
    public boolean hasNext() {
        return currentTaskIndex < tasks.size() - 1;
    }

    @Override
    public Task next() {
        return tasks.get(++currentTaskIndex);
    }

    public Task current() {
        return tasks.get(currentTaskIndex);
    }

    public MessageSender getWorker() {
        return worker;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Allocation that = (Allocation) o;
        return weight == that.weight && Objects.equals(tasks, that.tasks);
    }

}
