package com.ease.gsms.server.model.util;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Constraint(validatedBy = ICCIDValidator.class)
@Target( {ElementType.METHOD, ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidICCID {
    String message() default "Invalid ICCID number, should start with 89 and have 18-22 digits, see https://en.wikipedia.org/wiki/SIM_card#ICCID";
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}
