package com.ease.gsms.server.model.util;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Constraint(validatedBy = E164NumberValidator.class)
@Target( {ElementType.METHOD, ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidE164Number {
    String message() default "Invalid phone number, please use E164 format (eg +40721111111)";
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}
