package com.ease.gsms.server.model.util;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

public class ICCIDValidator implements ConstraintValidator<ValidICCID, String> {

    @Override
    public void initialize(ValidICCID constraintAnnotation) {
    }

    @Override
    public boolean isValid(String iccid, ConstraintValidatorContext constraintValidatorContext) {
        return iccid == null || (iccid.startsWith("89") && iccid.length() >= 18 && iccid.length() <= 22);
    }
}
