package com.ease.gsms.server.model;

import com.ease.gsms.server.model.util.IDEnum;

import java.util.HashMap;
import java.util.Map;

public enum SimState implements IDEnum {

    SIM_STATE_UNKNOWN (0),
    SIM_STATE_ABSENT (1),
    SIM_STATE_PIN_REQUIRED	 (2),
    SIM_STATE_PUK_REQUIRED (3),
    SIM_STATE_NETWORK_LOCKED (4),
    SIM_STATE_READY (5);

    int id;

    SimState(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }

    private static final Map<Integer, SimState> map = new HashMap<Integer, SimState>(){{
        values().forEach(possibility -> map.put(possibility.getId(), possibility));
    }};

    public static SimState byId(int id) {
        return map.get(id);
    }


}
