package com.ease.gsms.server.controllers.filters;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyAuthenticationProvider implements AuthenticationProvider {

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {

        // TODO: we've allowed the filter to do all the work, check if that's OK

        return new ApiKeyAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), authentication.getAuthorities());

    }

    @Override
    public boolean supports(Class<?> authentication) {

        return ApiKeyAuthenticationToken.class.isAssignableFrom(authentication);
        
    }

}