package com.ease.gsms.server.controllers.api.v1;

import com.ease.gsms.server.services.dispatch.Task;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import java.util.UUID;

@JsonTypeInfo( use=JsonTypeInfo.Id.CLASS)
public class TaskInfo {

    int messageCount;

    boolean exclusive;

    boolean askForDeliveryReport;

    UUID dispatchUUID;

    public TaskInfo() {
    }

    public TaskInfo(Task task) {
        messageCount = task.getWeight();
        exclusive = task.isExclusive();
        askForDeliveryReport = task.getDispatch().getAskForDeliveryReport();
        dispatchUUID = task.getDispatch().getUUID();
    }

    public int getMessageCount() {
        return messageCount;
    }

    public boolean isExclusive() {
        return exclusive;
    }

    public boolean isAskForDeliveryReport() {
        return askForDeliveryReport;
    }

    public UUID getDispatchUUID() {
        return dispatchUUID;
    }

}
