package com.ease.gsms.server.controllers.api.v1;

import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.model.util.ValidE164Number;
import io.swagger.v3.oas.annotations.media.Schema;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import static com.ease.gsms.server.Constants.MAX_MESSAGE_SIZE;

public class SMSMessage {

    @Schema(
            description = "What number should the message be sent to",
            example = "+40721111111",
            required = true
    )
    @ValidE164Number
    @NotNull
    String to;

    @Schema(
            description = "The textual message to send",
            required = true
    )
    @Size(min = 1, max = MAX_MESSAGE_SIZE)
    @NotNull
    String content;

    public SMSMessage() {
    }

    public String getTo() {
        return to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Message toMessage() {

        return new Message(to, content);

    }
}
