package com.ease.gsms.server.controllers;

import com.ease.gsms.server.repositories.ApiKeyRepository;
import com.ease.gsms.server.services.DispatchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.Collections;

@Controller
public class APIKeyController {

    @Autowired
    ApiKeyRepository apiKeyRepository;

    @RequestMapping("/api-keys")
    @PreAuthorize("hasRole('SUBMITTER')")
    public ModelAndView apiKeys(Principal principal) {

        return new ModelAndView(
                "api-keys",
                Collections.singletonMap(
                        "apiKeys",
                        apiKeyRepository.getApiKeysForUsername(principal.getName())
                )
        );

    }

}
