package com.ease.gsms.server;

import freemarker.template.TemplateModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.Scope;
import org.springframework.http.CacheControl;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static com.ease.gsms.server.Constants.MAX_MESSAGE_SIZE;

@Configuration
@EnableWebMvc
@EnableCaching
@EnableScheduling
@EnableAsync
@PropertySource(value="classpath:sql.properties")
public class AppConfiguration implements WebMvcConfigurer {

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
//        CacheControl cacheControl = CacheControl.maxAge(30, TimeUnit.DAYS).mustRevalidate();
        CacheControl cacheControl = CacheControl.noCache();
        registry.addResourceHandler("/apk/**").addResourceLocations("classpath:/static/apk/").setCacheControl(cacheControl);
        registry.addResourceHandler("/js/**").addResourceLocations("classpath:/static/js/").setCacheControl(cacheControl);
        registry.addResourceHandler("/css/**").addResourceLocations("classpath:/static/css/").setCacheControl(cacheControl);
        registry.addResourceHandler("/img/**").addResourceLocations("classpath:/static/img/").setCacheControl(cacheControl);
        registry.addResourceHandler("/native/**").addResourceLocations("classpath:/static/native/").setCacheControl(cacheControl);
        registry.addResourceHandler("/favicon.ico").addResourceLocations("classpath:/static/").setCacheControl(cacheControl);
    }

    @Bean
    public FreeMarkerConfigurer freeMarkerConfigurer() throws TemplateModelException {
        FreeMarkerConfigurer freeMarkerConfigurer = new FreeMarkerConfigurer();
        freeMarkerConfigurer.setTemplateLoaderPath("classpath:/templates");
        freeMarkerConfigurer.setDefaultEncoding("UTF-8");
        freeMarkerConfigurer.setFreemarkerVariables(Collections.singletonMap("MAX_MESSAGE_SIZE", MAX_MESSAGE_SIZE));
        return freeMarkerConfigurer;
    }

    @Bean
    @Scope("prototype")
    public Logger produceLogger(InjectionPoint injectionPoint) {
        Class<?> classOnWired = injectionPoint.getMember().getDeclaringClass();
        return LoggerFactory.getLogger(classOnWired);
    }

}
