importScripts('xlsx.full.min.js');

onmessage = function (event) {
    try {
        var workbook = XLSX.read(event.data.raw, {type: event.data.type});
        var simplifiedWorkbook = {
            SheetNames: Object.assign({}, workbook.SheetNames),
            Sheets: {}
        };
        workbook.SheetNames.forEach(n => {
            var sheet = workbook.Sheets[n];
            var simplifiedSheet = {data: []};
            try {
                var range = XLSX.utils.decode_range(sheet['!ref']);
                for (var rowNum = range.s.r; rowNum <= range.e.r; rowNum++) {
                    var simplifiedRow = [];
                    for (var colNum = range.s.c; colNum <= range.e.c; colNum++) {
                        var cell = sheet[XLSX.utils.encode_cell({r: rowNum, c: colNum})];
                        simplifiedRow.push(cell ? cell.v : null);
                    }
                    simplifiedSheet.data.push(simplifiedRow);
                }
                simplifiedWorkbook.Sheets[n] = simplifiedSheet;
            } catch (e) {
                console.warn(e);
            }
        });
        postMessage(
            {
                state: "finished",
                workbook: simplifiedWorkbook
            }
        );
        self.close();
    } catch(e) {
        postMessage({state: "error", details: e.stack || e});
    }
};

postMessage({state: "ready"});

