drop table if exists authorities;

drop table if exists users;

create table users (
                       username varchar(50) not null primary key,
                       password varchar(100) not null,
                       enabled boolean not null
);

create table authorities (
                             username varchar(50) not null,
                             authority varchar(50) not null,
                             constraint fk_authorities_users foreign key(username) references users(username)
);

drop index if exists ix_auth_username on authorities;

create unique index ix_auth_username on authorities (username,authority);

drop table if exists persistent_logins;

create table persistent_logins (
                                   username varchar(64) not null,
                                   series varchar(64) primary key,
                                   token varchar(64) not null,
                                   last_used timestamp not null
);

INSERT INTO users VALUES (
                             'administrator',
                             '$2y$12$VeMO18.Nwn0oWU2YvSXpK.4tfoMA0QCAmgbLdFmn3UZcXcTGmqQCa',
                             true
                         ); -- gsms2021

INSERT INTO authorities VALUES ('administrator', 'ADMIN');
INSERT INTO authorities VALUES ('administrator', 'MANAGER');
INSERT INTO authorities VALUES ('administrator', 'SUBMITTER');
INSERT INTO authorities VALUES ('administrator', 'SENDER');

INSERT INTO users VALUES (
                             'optisan',
                             '$2y$12$qSimYbUgqDKU4g9Gor7k3.OYeKT0VZspOUmrktneMFSV5ZsFM3qn2',
                             true
                         ); -- zalau2020

INSERT INTO authorities VALUES ('optisan', 'MANAGER');
INSERT INTO authorities VALUES ('optisan', 'SUBMITTER');
INSERT INTO authorities VALUES ('optisan', 'SENDER');

INSERT INTO users VALUES (
                             'zaraza',
                             '$2y$12$JM6GCaVJIcWB0e9uNBB8x.iPQixpfPOB427byNAOxDZn75gwJthK2',
                             true
                         ); -- sestie2021

INSERT INTO authorities VALUES ('zaraza', 'MANAGER');
INSERT INTO authorities VALUES ('zaraza', 'SUBMITTER');
INSERT INTO authorities VALUES ('zaraza', 'SENDER');

INSERT INTO users VALUES (
                             'fingir',
                             '$2y$12$pbKvj0/4cj9u3dRvftZWDut47eBXfnQIzaQYyAbiAAWqs0md3kIYO',
                             true
                         ); -- pitesti1996

INSERT INTO authorities VALUES ('fingir', 'MANAGER');
INSERT INTO authorities VALUES ('fingir', 'SUBMITTER');
INSERT INTO authorities VALUES ('fingir', 'SENDER');