/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.powermanagement;

import android.os.PowerManager;
import android.util.Log;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;

public class PowerManagement
extends CordovaPlugin {
    private PowerManager.WakeLock wakeLock = null;
    private PowerManager powerManager = null;
    private boolean releaseOnPause = true;

    public void initialize(CordovaInterface cordova, CordovaWebView webView) {
        super.initialize(cordova, webView);
        this.powerManager = (PowerManager)cordova.getActivity().getSystemService("power");
    }

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        PluginResult result = null;
        Log.d((String)"PowerManagementPlugin", (String)("Plugin execute called - " + ((Object)((Object)this)).toString()));
        Log.d((String)"PowerManagementPlugin", (String)("Action is " + action));
        try {
            if (action.equals("acquire")) {
                if (args.length() > 0 && args.getBoolean(0)) {
                    Log.d((String)"PowerManagementPlugin", (String)"Only dim lock");
                    result = this.acquire(6);
                } else {
                    result = this.acquire(26);
                }
            } else if (action.equals("release")) {
                result = this.release();
            } else if (action.equals("setReleaseOnPause")) {
                try {
                    this.releaseOnPause = args.getBoolean(0);
                    result = new PluginResult(PluginResult.Status.OK);
                }
                catch (Exception e) {
                    result = new PluginResult(PluginResult.Status.ERROR, "Could not set releaseOnPause");
                }
            }
        }
        catch (JSONException e) {
            result = new PluginResult(PluginResult.Status.JSON_EXCEPTION, e.getMessage());
        }
        callbackContext.sendPluginResult(result);
        return true;
    }

    private PluginResult acquire(int p_flags) {
        PluginResult result = null;
        if (this.wakeLock == null) {
            this.wakeLock = this.powerManager.newWakeLock(p_flags, "PowerManagementPlugin");
            try {
                this.wakeLock.acquire();
                result = new PluginResult(PluginResult.Status.OK);
            }
            catch (Exception e) {
                this.wakeLock = null;
                result = new PluginResult(PluginResult.Status.ERROR, "Can't acquire wake-lock - check your permissions!");
            }
        } else {
            result = new PluginResult(PluginResult.Status.ILLEGAL_ACCESS_EXCEPTION, "WakeLock already active - release first");
        }
        return result;
    }

    private PluginResult release() {
        PluginResult result = null;
        if (this.wakeLock != null) {
            try {
                this.wakeLock.release();
                result = new PluginResult(PluginResult.Status.OK, "OK");
            }
            catch (Exception e) {
                result = new PluginResult(PluginResult.Status.ILLEGAL_ACCESS_EXCEPTION, "WakeLock already released");
            }
            this.wakeLock = null;
        } else {
            result = new PluginResult(PluginResult.Status.ILLEGAL_ACCESS_EXCEPTION, "No WakeLock active - acquire first");
        }
        return result;
    }

    public void onPause(boolean multitasking) {
        if (this.releaseOnPause && this.wakeLock != null) {
            this.wakeLock.release();
        }
        super.onPause(multitasking);
    }

    public void onResume(boolean multitasking) {
        if (this.releaseOnPause && this.wakeLock != null) {
            this.wakeLock.acquire();
        }
        super.onResume(multitasking);
    }
}

