/*
 * Decompiled with CFR 0.152.
 */
package de.appplant.cordova.plugin.background;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import de.appplant.cordova.plugin.background.BackgroundMode;
import org.json.JSONObject;

public class ForegroundService
extends Service {
    public static final int NOTIFICATION_ID = -574543954;
    private static final String NOTIFICATION_TITLE = "App is running in background";
    private static final String NOTIFICATION_TEXT = "Doing heavy tasks.";
    private static final String NOTIFICATION_ICON = "icon";
    private final IBinder binder = new ForegroundBinder();
    private PowerManager.WakeLock wakeLock;

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void onCreate() {
        super.onCreate();
        this.keepAwake();
    }

    public void onDestroy() {
        super.onDestroy();
        this.sleepWell();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    @SuppressLint(value={"WakelockTimeout"})
    private void keepAwake() {
        JSONObject settings = BackgroundMode.getSettings();
        boolean isSilent = settings.optBoolean("silent", false);
        if (!isSilent) {
            this.startForeground(-574543954, this.makeNotification());
        }
        PowerManager pm = (PowerManager)this.getSystemService("power");
        this.wakeLock = pm.newWakeLock(1, "backgroundmode:wakelock");
        this.wakeLock.acquire();
    }

    private void sleepWell() {
        this.stopForeground(true);
        this.getNotificationManager().cancel(-574543954);
        if (this.wakeLock != null) {
            this.wakeLock.release();
            this.wakeLock = null;
        }
    }

    private Notification makeNotification() {
        return this.makeNotification(BackgroundMode.getSettings());
    }

    private Notification makeNotification(JSONObject settings) {
        String CHANNEL_ID = "cordova-plugin-background-mode-id";
        if (Build.VERSION.SDK_INT >= 26) {
            String name = "cordova-plugin-background-mode";
            String description = "cordova-plugin-background-moden notification";
            int importance = 2;
            NotificationChannel mChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)name, importance);
            mChannel.setDescription(description);
            this.getNotificationManager().createNotificationChannel(mChannel);
        }
        String title = settings.optString("title", NOTIFICATION_TITLE);
        String text = settings.optString("text", NOTIFICATION_TEXT);
        boolean bigText = settings.optBoolean("bigText", false);
        Context context = this.getApplicationContext();
        String pkgName = context.getPackageName();
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(pkgName);
        Notification.Builder notification = new Notification.Builder(context).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setOngoing(true).setSmallIcon(this.getIconResId(settings));
        if (Build.VERSION.SDK_INT >= 26) {
            notification.setChannelId(CHANNEL_ID);
        }
        if (settings.optBoolean("hidden", true)) {
            notification.setPriority(-2);
        }
        if (bigText || text.contains("\n")) {
            notification.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)text));
        }
        this.setColor(notification, settings);
        if (intent != null && settings.optBoolean("resume")) {
            intent.addFlags(0x24000000);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)-574543954, (Intent)intent, (int)0x8000000);
            notification.setContentIntent(contentIntent);
        }
        return notification.build();
    }

    protected void updateNotification(JSONObject settings) {
        boolean isSilent = settings.optBoolean("silent", false);
        if (isSilent) {
            this.stopForeground(true);
            return;
        }
        Notification notification = this.makeNotification(settings);
        this.getNotificationManager().notify(-574543954, notification);
    }

    private int getIconResId(JSONObject settings) {
        String icon = settings.optString(NOTIFICATION_ICON, NOTIFICATION_ICON);
        int resId = this.getIconResId(icon, "mipmap");
        if (resId == 0) {
            resId = this.getIconResId(icon, "drawable");
        }
        return resId;
    }

    private int getIconResId(String icon, String type) {
        String pkgName;
        Resources res = this.getResources();
        int resId = res.getIdentifier(icon, type, pkgName = this.getPackageName());
        if (resId == 0) {
            resId = res.getIdentifier(NOTIFICATION_ICON, type, pkgName);
        }
        return resId;
    }

    @TargetApi(value=21)
    private void setColor(Notification.Builder notification, JSONObject settings) {
        String hex = settings.optString("color", null);
        if (Build.VERSION.SDK_INT < 21 || hex == null) {
            return;
        }
        try {
            int aRGB = Integer.parseInt(hex, 16) + -16777216;
            notification.setColor(aRGB);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private NotificationManager getNotificationManager() {
        return (NotificationManager)this.getSystemService("notification");
    }

    class ForegroundBinder
    extends Binder {
        ForegroundBinder() {
        }

        ForegroundService getService() {
            return ForegroundService.this;
        }
    }
}

