/*
 * Decompiled with CFR 0.152.
 */
package de.appplant.cordova.plugin.background;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.view.View;
import java.util.Arrays;
import java.util.List;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONObject;

public class BackgroundModeExt
extends CordovaPlugin {
    private PowerManager.WakeLock wakeLock;

    public boolean execute(String action, JSONArray args, CallbackContext callback) {
        boolean validAction = true;
        switch (action) {
            case "battery": {
                this.disableBatteryOptimizations();
                break;
            }
            case "webview": {
                this.disableWebViewOptimizations();
                break;
            }
            case "appstart": {
                this.openAppStart(args.opt(0));
                break;
            }
            case "background": {
                this.moveToBackground();
                break;
            }
            case "foreground": {
                this.moveToForeground();
                break;
            }
            case "tasklist": {
                this.excludeFromTaskList();
                break;
            }
            case "dimmed": {
                this.isDimmed(callback);
                break;
            }
            case "wakeup": {
                this.wakeup();
                break;
            }
            case "unlock": {
                this.wakeup();
                this.unlock();
                break;
            }
            default: {
                validAction = false;
            }
        }
        if (validAction) {
            callback.success();
        } else {
            callback.error("Invalid action: " + action);
        }
        return validAction;
    }

    private void moveToBackground() {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        this.getApp().startActivity(intent);
    }

    private void moveToForeground() {
        Activity app = this.getApp();
        Intent intent = this.getLaunchIntent();
        intent.addFlags(0x24020000);
        this.clearScreenAndKeyguardFlags();
        app.startActivity(intent);
    }

    private void disableWebViewOptimizations() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    BackgroundModeExt.this.getApp().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            View view = BackgroundModeExt.this.webView.getEngine().getView();
                            try {
                                Class.forName("org.crosswalk.engine.XWalkCordovaView").getMethod("onShow", new Class[0]).invoke((Object)view, new Object[0]);
                            }
                            catch (Exception e) {
                                view.dispatchWindowVisibilityChanged(0);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    @SuppressLint(value={"BatteryLife"})
    private void disableBatteryOptimizations() {
        Activity activity = this.cordova.getActivity();
        Intent intent = new Intent();
        String pkgName = activity.getPackageName();
        PowerManager pm = (PowerManager)this.getService("power");
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (pm.isIgnoringBatteryOptimizations(pkgName)) {
            return;
        }
        intent.setAction("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
        intent.setData(Uri.parse((String)("package:" + pkgName)));
        this.cordova.getActivity().startActivity(intent);
    }

    private void openAppStart(Object arg) {
        final Activity activity = this.cordova.getActivity();
        PackageManager pm = activity.getPackageManager();
        for (final Intent intent : this.getAppStartIntents()) {
            if (pm.resolveActivity(intent, 65536) == null) continue;
            JSONObject spec = arg instanceof JSONObject ? (JSONObject)arg : null;
            intent.addFlags(0x10000000);
            if (arg instanceof Boolean && !((Boolean)arg).booleanValue()) {
                activity.startActivity(intent);
                break;
            }
            final AlertDialog.Builder dialog = new AlertDialog.Builder((Context)activity, 16974130);
            dialog.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface o, int d) {
                    activity.startActivity(intent);
                }
            });
            dialog.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface o, int d) {
                }
            });
            dialog.setCancelable(true);
            if (spec != null && spec.has("title")) {
                dialog.setTitle((CharSequence)spec.optString("title"));
            }
            if (spec != null && spec.has("text")) {
                dialog.setMessage((CharSequence)spec.optString("text"));
            } else {
                dialog.setMessage((CharSequence)"missing text");
            }
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    dialog.show();
                }
            });
            break;
        }
    }

    @TargetApi(value=21)
    private void excludeFromTaskList() {
        ActivityManager am = (ActivityManager)this.getService("activity");
        if (am == null || Build.VERSION.SDK_INT < 21) {
            return;
        }
        List tasks = am.getAppTasks();
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        ((ActivityManager.AppTask)tasks.get(0)).setExcludeFromRecents(true);
    }

    private void isDimmed(CallbackContext callback) {
        boolean status = this.isDimmed();
        PluginResult res = new PluginResult(PluginResult.Status.OK, status);
        callback.sendPluginResult(res);
    }

    private boolean isDimmed() {
        PowerManager pm = (PowerManager)this.getService("power");
        if (Build.VERSION.SDK_INT < 20) {
            return !pm.isScreenOn();
        }
        return !pm.isInteractive();
    }

    private void wakeup() {
        try {
            this.acquireWakeLock();
        }
        catch (Exception e) {
            this.releaseWakeLock();
        }
    }

    private void unlock() {
        this.addScreenAndKeyguardFlags();
        this.getApp().startActivity(this.getLaunchIntent());
    }

    private void acquireWakeLock() {
        PowerManager pm = (PowerManager)this.getService("power");
        this.releaseWakeLock();
        if (!this.isDimmed()) {
            return;
        }
        int level = 0x10000006;
        this.wakeLock = pm.newWakeLock(level, "backgroundmode:wakelock");
        this.wakeLock.setReferenceCounted(false);
        this.wakeLock.acquire(1000L);
    }

    private void releaseWakeLock() {
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            this.wakeLock.release();
            this.wakeLock = null;
        }
    }

    private void addScreenAndKeyguardFlags() {
        this.getApp().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BackgroundModeExt.this.getApp().getWindow().addFlags(6815745);
            }
        });
    }

    private void clearScreenAndKeyguardFlags() {
        this.getApp().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BackgroundModeExt.this.getApp().getWindow().clearFlags(6815745);
            }
        });
    }

    static void clearKeyguardFlags(final Activity app) {
        app.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                app.getWindow().clearFlags(0x400000);
            }
        });
    }

    Activity getApp() {
        return this.cordova.getActivity();
    }

    private Intent getLaunchIntent() {
        Context app = this.getApp().getApplicationContext();
        String pkgName = app.getPackageName();
        return app.getPackageManager().getLaunchIntentForPackage(pkgName);
    }

    private Object getService(String name) {
        return this.getApp().getSystemService(name);
    }

    private List<Intent> getAppStartIntents() {
        return Arrays.asList(new Intent().setComponent(new ComponentName("com.miui.securitycenter", "com.miui.permcenter.autostart.AutoStartManagementActivity")), new Intent().setComponent(new ComponentName("com.letv.android.letvsafe", "com.letv.android.letvsafe.AutobootManageActivity")), new Intent().setComponent(new ComponentName("com.huawei.systemmanager", "com.huawei.systemmanager.appcontrol.activity.StartupAppControlActivity")), new Intent().setComponent(new ComponentName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity")), new Intent().setComponent(new ComponentName("com.coloros.safecenter", "com.coloros.safecenter.permission.startup.StartupAppListActivity")), new Intent().setComponent(new ComponentName("com.coloros.safecenter", "com.coloros.safecenter.startupapp.StartupAppListActivity")), new Intent().setComponent(new ComponentName("com.oppo.safe", "com.oppo.safe.permission.startup.StartupAppListActivity")), new Intent().setComponent(new ComponentName("com.iqoo.secure", "com.iqoo.secure.ui.phoneoptimize.AddWhiteListActivity")), new Intent().setComponent(new ComponentName("com.iqoo.secure", "com.iqoo.secure.ui.phoneoptimize.BgStartUpManager")), new Intent().setComponent(new ComponentName("com.vivo.permissionmanager", "com.vivo.permissionmanager.activity.BgStartUpManagerActivity")), new Intent().setComponent(new ComponentName("com.asus.mobilemanager", "com.asus.mobilemanager.autostart.AutoStartActivity")), new Intent().setComponent(new ComponentName("com.asus.mobilemanager", "com.asus.mobilemanager.entry.FunctionActivity")).setData(Uri.parse((String)"mobilemanager://function/entry/AutoStart")), new Intent().setAction("com.letv.android.permissionautoboot"), new Intent().setComponent(new ComponentName("com.samsung.android.sm_cn", "com.samsung.android.sm.ui.ram.AutoRunActivity")), new Intent().setComponent(ComponentName.unflattenFromString((String)"com.iqoo.secure/.MainActivity")), new Intent().setComponent(ComponentName.unflattenFromString((String)"com.meizu.safe/.permission.SmartBGActivity")), new Intent().setComponent(new ComponentName("com.yulong.android.coolsafe", ".ui.activity.autorun.AutoRunListActivity")), new Intent().setComponent(new ComponentName("cn.nubia.security2", "cn.nubia.security.appmanage.selfstart.ui.SelfStartActivity")), new Intent().setComponent(new ComponentName("com.zui.safecenter", "com.lenovo.safecenter.MainTab.LeSafeMainActivity")));
    }
}

