/*
 * Decompiled with CFR 0.152.
 */
package de.appplant.cordova.plugin.background;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import de.appplant.cordova.plugin.background.BackgroundModeExt;
import de.appplant.cordova.plugin.background.ForegroundService;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.json.JSONArray;
import org.json.JSONObject;

public class BackgroundMode
extends CordovaPlugin {
    private static final String JS_NAMESPACE = "cordova.plugins.backgroundMode";
    private boolean inBackground = false;
    private boolean isDisabled = true;
    private boolean isBind = false;
    private static JSONObject defaultSettings = new JSONObject();
    private ForegroundService service;
    private final ServiceConnection connection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            ForegroundService.ForegroundBinder binder = (ForegroundService.ForegroundBinder)service;
            BackgroundMode.this.service = binder.getService();
        }

        public void onServiceDisconnected(ComponentName name) {
            BackgroundMode.this.fireEvent(Event.FAILURE, "'service disconnected'");
        }
    };

    public boolean execute(String action, JSONArray args, CallbackContext callback) {
        boolean validAction = true;
        switch (action) {
            case "configure": {
                this.configure(args.optJSONObject(0), args.optBoolean(1));
                break;
            }
            case "enable": {
                this.enableMode();
                break;
            }
            case "disable": {
                this.disableMode();
                break;
            }
            default: {
                validAction = false;
            }
        }
        if (validAction) {
            callback.success();
        } else {
            callback.error("Invalid action: " + action);
        }
        return validAction;
    }

    public void onPause(boolean multitasking) {
        try {
            this.inBackground = true;
            this.startService();
        }
        finally {
            BackgroundModeExt.clearKeyguardFlags(this.cordova.getActivity());
        }
    }

    public void onStop() {
        BackgroundModeExt.clearKeyguardFlags(this.cordova.getActivity());
    }

    public void onResume(boolean multitasking) {
        this.inBackground = false;
        this.stopService();
    }

    public void onDestroy() {
        this.stopService();
        Process.killProcess((int)Process.myPid());
    }

    private void enableMode() {
        this.isDisabled = false;
        if (this.inBackground) {
            this.startService();
        }
    }

    private void disableMode() {
        this.stopService();
        this.isDisabled = true;
    }

    private void configure(JSONObject settings, boolean update) {
        if (update) {
            this.updateNotification(settings);
        } else {
            this.setDefaultSettings(settings);
        }
    }

    private void setDefaultSettings(JSONObject settings) {
        defaultSettings = settings;
    }

    static JSONObject getSettings() {
        return defaultSettings;
    }

    private void updateNotification(JSONObject settings) {
        if (this.isBind) {
            this.service.updateNotification(settings);
        }
    }

    private void startService() {
        Activity context = this.cordova.getActivity();
        if (this.isDisabled || this.isBind) {
            return;
        }
        Intent intent = new Intent((Context)context, ForegroundService.class);
        try {
            context.bindService(intent, this.connection, 1);
            this.fireEvent(Event.ACTIVATE, null);
            context.startService(intent);
        }
        catch (Exception e) {
            this.fireEvent(Event.FAILURE, String.format("'%s'", e.getMessage()));
        }
        this.isBind = true;
    }

    private void stopService() {
        Activity context = this.cordova.getActivity();
        Intent intent = new Intent((Context)context, ForegroundService.class);
        if (!this.isBind) {
            return;
        }
        this.fireEvent(Event.DEACTIVATE, null);
        context.unbindService(this.connection);
        context.stopService(intent);
        this.isBind = false;
    }

    private void fireEvent(Event event, String params) {
        String eventName = event.name().toLowerCase();
        Boolean active = event == Event.ACTIVATE;
        String str = String.format("%s._setActive(%b)", JS_NAMESPACE, active);
        str = String.format("%s;%s.on('%s', %s)", str, JS_NAMESPACE, eventName, params);
        final String js = str = String.format("%s;%s.fireEvent('%s',%s);", str, JS_NAMESPACE, eventName, params);
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BackgroundMode.this.webView.loadUrl("javascript:" + js);
            }
        });
    }

    private static enum Event {
        ACTIVATE,
        DEACTIVATE,
        FAILURE;

    }
}

