/*
 * Decompiled with CFR 0.152.
 */
package com.pbakondy;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import java.util.List;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Sim
extends CordovaPlugin {
    private static final String LOG_TAG = "CordovaPluginSim";
    private static final String GET_SIM_INFO = "getSimInfo";
    private static final String HAS_READ_PERMISSION = "hasReadPermission";
    private static final String REQUEST_READ_PERMISSION = "requestReadPermission";
    private CallbackContext callback;

    @SuppressLint(value={"HardwareIds"})
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        this.callback = callbackContext;
        if (GET_SIM_INFO.equals(action)) {
            Context context = this.cordova.getActivity().getApplicationContext();
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            JSONArray sims = null;
            Integer phoneCount = null;
            Integer activeSubscriptionInfoCount = null;
            Integer activeSubscriptionInfoCountMax = null;
            try {
                if (Build.VERSION.SDK_INT >= 23) {
                    phoneCount = manager.getPhoneCount();
                }
                if (Build.VERSION.SDK_INT >= 22 && this.simPermissionGranted("android.permission.READ_PHONE_STATE")) {
                    SubscriptionManager subscriptionManager = (SubscriptionManager)context.getSystemService("telephony_subscription_service");
                    activeSubscriptionInfoCount = subscriptionManager.getActiveSubscriptionInfoCount();
                    activeSubscriptionInfoCountMax = subscriptionManager.getActiveSubscriptionInfoCountMax();
                    sims = new JSONArray();
                    List subscriptionInfos = subscriptionManager.getActiveSubscriptionInfoList();
                    for (SubscriptionInfo subscriptionInfo : subscriptionInfos) {
                        CharSequence carrierName = subscriptionInfo.getCarrierName();
                        String countryIso = subscriptionInfo.getCountryIso();
                        int dataRoaming = subscriptionInfo.getDataRoaming();
                        CharSequence displayName = subscriptionInfo.getDisplayName();
                        String iccId = subscriptionInfo.getIccId();
                        int mcc = subscriptionInfo.getMcc();
                        int mnc = subscriptionInfo.getMnc();
                        String number = subscriptionInfo.getNumber();
                        int simSlotIndex = subscriptionInfo.getSimSlotIndex();
                        int subscriptionId = subscriptionInfo.getSubscriptionId();
                        boolean networkRoaming = subscriptionManager.isNetworkRoaming(simSlotIndex);
                        String deviceId = null;
                        if (Build.VERSION.SDK_INT >= 23) {
                            deviceId = manager.getDeviceId(simSlotIndex);
                        }
                        JSONObject simData = new JSONObject();
                        simData.put("carrierName", (Object)carrierName.toString());
                        simData.put("displayName", (Object)displayName.toString());
                        simData.put("countryCode", (Object)countryIso);
                        simData.put("mcc", mcc);
                        simData.put("mnc", mnc);
                        simData.put("isNetworkRoaming", networkRoaming);
                        simData.put("isDataRoaming", dataRoaming == 1);
                        simData.put("simSlotIndex", simSlotIndex);
                        simData.put("phoneNumber", (Object)number);
                        if (deviceId != null) {
                            simData.put("deviceId", (Object)deviceId);
                        }
                        simData.put("simSerialNumber", (Object)iccId);
                        simData.put("subscriptionId", subscriptionId);
                        sims.put((Object)simData);
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String phoneNumber = null;
            String countryCode = manager.getSimCountryIso();
            String simOperator = manager.getSimOperator();
            String carrierName = manager.getSimOperatorName();
            String deviceId = null;
            String deviceSoftwareVersion = null;
            String simSerialNumber = null;
            String subscriberId = null;
            int callState = manager.getCallState();
            int dataActivity = manager.getDataActivity();
            int networkType = manager.getNetworkType();
            int phoneType = manager.getPhoneType();
            int simState = manager.getSimState();
            boolean isNetworkRoaming = manager.isNetworkRoaming();
            if (this.simPermissionGranted("android.permission.READ_PHONE_STATE")) {
                phoneNumber = manager.getLine1Number();
                deviceId = manager.getDeviceId();
                deviceSoftwareVersion = manager.getDeviceSoftwareVersion();
                simSerialNumber = manager.getSimSerialNumber();
                subscriberId = manager.getSubscriberId();
            }
            String mcc = "";
            String mnc = "";
            if (simOperator.length() >= 3) {
                mcc = simOperator.substring(0, 3);
                mnc = simOperator.substring(3);
            }
            JSONObject result = new JSONObject();
            result.put("carrierName", (Object)carrierName);
            result.put("countryCode", (Object)countryCode);
            result.put("mcc", (Object)mcc);
            result.put("mnc", (Object)mnc);
            result.put("callState", callState);
            result.put("dataActivity", dataActivity);
            result.put("networkType", networkType);
            result.put("phoneType", phoneType);
            result.put("simState", simState);
            result.put("isNetworkRoaming", isNetworkRoaming);
            if (phoneCount != null) {
                result.put("phoneCount", phoneCount.intValue());
            }
            if (activeSubscriptionInfoCount != null) {
                result.put("activeSubscriptionInfoCount", activeSubscriptionInfoCount.intValue());
            }
            if (activeSubscriptionInfoCountMax != null) {
                result.put("activeSubscriptionInfoCountMax", activeSubscriptionInfoCountMax.intValue());
            }
            if (this.simPermissionGranted("android.permission.READ_PHONE_STATE")) {
                result.put("phoneNumber", (Object)phoneNumber);
                result.put("deviceId", (Object)deviceId);
                result.put("deviceSoftwareVersion", (Object)deviceSoftwareVersion);
                result.put("simSerialNumber", (Object)simSerialNumber);
                result.put("subscriberId", (Object)subscriberId);
            }
            if (sims != null && sims.length() != 0) {
                result.put("cards", (Object)sims);
            }
            callbackContext.success(result);
            return true;
        }
        if (HAS_READ_PERMISSION.equals(action)) {
            this.hasReadPermission();
            return true;
        }
        if (REQUEST_READ_PERMISSION.equals(action)) {
            this.requestReadPermission();
            return true;
        }
        return false;
    }

    private void hasReadPermission() {
        this.callback.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.simPermissionGranted("android.permission.READ_PHONE_STATE")));
    }

    private void requestReadPermission() {
        this.requestPermission("android.permission.READ_PHONE_STATE");
    }

    private boolean simPermissionGranted(String type) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return this.cordova.hasPermission(type);
    }

    private void requestPermission(String type) {
        LOG.i((String)LOG_TAG, (String)"requestPermission");
        if (!this.simPermissionGranted(type)) {
            this.cordova.requestPermission((CordovaPlugin)this, 12345, type);
        } else {
            this.callback.success();
        }
    }

    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            this.callback.success();
        } else {
            this.callback.error("Permission denied");
        }
    }
}

