/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.android.plugins;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.SmsManager;
import com.ease.gsms.android.plugins.PartCountingBroadcastReceiver;
import java.util.ArrayList;
import java.util.UUID;
import org.ajwcc.pduUtils.gsm3040.Pdu;
import org.ajwcc.pduUtils.gsm3040.PduParser;
import org.ajwcc.pduUtils.gsm3040.PduUtils;
import org.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=22)
public class Sms
extends CordovaPlugin {
    public final String ACTION_SEND_SMS = "send";
    public final String ACTION_HAS_PERMISSION = "has_permission";
    public final String ACTION_REQUEST_PERMISSION = "request_permission";
    private static final String INTENT_FILTER_SMS_SENT = "SMS_SENT";
    private static final String INTENT_FILTER_SMS_DELIVERED = "SMS_DELIVERED";
    private static final int SEND_SMS_REQ_CODE = 0;
    private static final int REQUEST_PERMISSION_REQ_CODE = 1;
    private CallbackContext callbackContext;
    private JSONArray args;

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        this.callbackContext = callbackContext;
        this.args = args;
        if (action.equals("send")) {
            if (this.hasPermission()) {
                this.sendSMS();
            } else {
                this.requestPermission(0);
            }
            return true;
        }
        if (action.equals("has_permission")) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.hasPermission()));
            return true;
        }
        if (action.equals("request_permission")) {
            this.requestPermission(1);
            return true;
        }
        return false;
    }

    private boolean hasPermission() {
        return this.cordova.hasPermission("android.permission.SEND_SMS");
    }

    private void requestPermission(int requestCode) {
        this.cordova.requestPermission((CordovaPlugin)this, requestCode, "android.permission.SEND_SMS");
    }

    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        for (int r : grantResults) {
            if (r != -1) continue;
            this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, "User has denied permission"));
            return;
        }
        if (requestCode == 0) {
            this.sendSMS();
            return;
        }
        this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, true));
    }

    private boolean sendSMS() {
        this.cordova.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String phoneNumber = Sms.this.args.getString(0);
                    int subscriptionId = Sms.this.args.getInt(1);
                    String message = Sms.this.args.getString(2);
                    Boolean requestDeliveryReport = Sms.this.args.getBoolean(3);
                    if (!Sms.this.checkSupport()) {
                        Sms.this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, "SMS not supported on this platform"));
                        return;
                    }
                    Sms.this.send(Sms.this.callbackContext, subscriptionId, phoneNumber, message, requestDeliveryReport);
                }
                catch (JSONException ex) {
                    Sms.this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
                }
            }
        });
        return true;
    }

    private boolean checkSupport() {
        Activity ctx = this.cordova.getActivity();
        return ctx.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private void send(final CallbackContext callbackContext, int subscriptionId, String phoneNumber, String message, boolean requestDeliveryReport) {
        PendingIntent deliveredIntent;
        SmsManager manager = SmsManager.getSmsManagerForSubscriptionId((int)subscriptionId);
        ArrayList parts = manager.divideMessage(message);
        UUID messageUUID = UUID.randomUUID();
        int partCount = parts.size();
        PartCountingBroadcastReceiver sendingBroadcastReceiver = new PartCountingBroadcastReceiver(this.cordova, partCount, messageUUID){

            @Override
            protected int actOnResultCode(Intent intent) {
                return this.getResultCode();
            }

            @Override
            void onComplete() {
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.getResultCodeJson()));
            }
        };
        PartCountingBroadcastReceiver deliveryBroadcastReceiver = requestDeliveryReport ? new PartCountingBroadcastReceiver(this.cordova, partCount, messageUUID){

            @Override
            protected int actOnResultCode(Intent intent) {
                int resultCode = this.getResultCode();
                if (resultCode == -1) {
                    try {
                        int status;
                        Pdu pdu = new PduParser().parsePdu(PduUtils.bytesToPdu((byte[])intent.getExtras().getByteArray("pdu")));
                        if (pdu instanceof SmsStatusReportPdu && (status = ((SmsStatusReportPdu)pdu).getStatus()) != 0) {
                            resultCode = status - 1;
                            this.unregisterAndComplete();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return resultCode;
            }

            @Override
            void onComplete() {
                this.cordova.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Sms.this.webView.loadUrl("javascript:sms.handlers[\"" + messageUUID + "\"].delivered(JSON.parse(" + JSONObject.quote((String)this.getResultCodeJson().toString()) + "));");
                    }
                });
            }
        } : null;
        String intentFilterActionSent = INTENT_FILTER_SMS_SENT + messageUUID;
        String intentFilterActionDelivered = INTENT_FILTER_SMS_DELIVERED + messageUUID;
        this.cordova.getActivity().registerReceiver((BroadcastReceiver)sendingBroadcastReceiver, new IntentFilter(intentFilterActionSent));
        if (requestDeliveryReport) {
            this.cordova.getActivity().registerReceiver((BroadcastReceiver)deliveryBroadcastReceiver, new IntentFilter(intentFilterActionDelivered));
        }
        PendingIntent sentIntent = PendingIntent.getBroadcast((Context)this.cordova.getActivity(), (int)0, (Intent)new Intent(intentFilterActionSent), (int)0);
        PendingIntent pendingIntent = deliveredIntent = requestDeliveryReport ? PendingIntent.getBroadcast((Context)this.cordova.getActivity(), (int)0, (Intent)new Intent(intentFilterActionDelivered), (int)0) : null;
        if (partCount > 1) {
            ArrayList<PendingIntent> sentIntents = new ArrayList<PendingIntent>();
            ArrayList<PendingIntent> deliveredIntents = requestDeliveryReport ? new ArrayList<PendingIntent>() : null;
            for (int i = 0; i < partCount; ++i) {
                sentIntents.add(sentIntent);
                if (!requestDeliveryReport) continue;
                deliveredIntents.add(deliveredIntent);
            }
            manager.sendMultipartTextMessage(phoneNumber, null, parts, sentIntents, deliveredIntents);
        } else {
            manager.sendTextMessage(phoneNumber, null, message, sentIntent, deliveredIntent);
        }
    }
}

