/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.android.plugins;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cordova.CordovaInterface;
import org.json.JSONObject;

public abstract class PartCountingBroadcastReceiver
extends BroadcastReceiver {
    final int partCount;
    final UUID messageUUID;
    final AtomicInteger partCountdown;
    final CordovaInterface cordova;
    final Map<Integer, Integer> resultCodeStats;
    AtomicBoolean alreadyUnregistered = new AtomicBoolean(false);

    protected PartCountingBroadcastReceiver(CordovaInterface cordova, int partCount, UUID messageUUID) {
        this.cordova = cordova;
        this.partCount = partCount;
        this.messageUUID = messageUUID;
        this.partCountdown = new AtomicInteger(partCount);
        this.resultCodeStats = new HashMap<Integer, Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        int resultCode = this.actOnResultCode(intent);
        Map<Integer, Integer> map = this.resultCodeStats;
        synchronized (map) {
            Integer existing = this.resultCodeStats.get(resultCode);
            this.resultCodeStats.put(resultCode, existing != null ? existing + 1 : 1);
        }
        if (this.partCountdown.decrementAndGet() <= 0) {
            this.unregisterAndComplete();
        }
    }

    void unregisterAndComplete() {
        if (this.alreadyUnregistered.compareAndSet(false, true)) {
            this.cordova.getActivity().unregisterReceiver((BroadcastReceiver)this);
            this.onComplete();
        }
    }

    protected abstract int actOnResultCode(Intent var1);

    public JSONObject getResultCodeJson() {
        try {
            JSONObject object = new JSONObject();
            object.put("messageUUID", (Object)this.messageUUID.toString());
            JSONObject resultCodes = new JSONObject();
            for (Map.Entry<Integer, Integer> entry : this.resultCodeStats.entrySet()) {
                resultCodes.put("" + entry.getKey(), (Object)entry.getValue());
            }
            object.put("resultCodes", (Object)resultCodes);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    abstract void onComplete();
}

