/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.helper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.smslib.helper.ReflectionHelper;
import org.smslib.helper.SerialPort;

public class CommPortIdentifier {
    private static Class<?> classCommPortIdentifier;
    public static final int PORT_SERIAL;
    private Object realObject;

    protected CommPortIdentifier(Object myRealObject) {
        this.realObject = myRealObject;
    }

    public int getPortType() {
        try {
            Method method = classCommPortIdentifier.getMethod("getPortType", null);
            return (Integer)method.invoke(this.realObject, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        try {
            Method method = classCommPortIdentifier.getMethod("getName", null);
            return (String)method.invoke(this.realObject, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SerialPort open(String appname, int timeout) {
        Class[] paramTypes = new Class[]{String.class, Integer.TYPE};
        try {
            Method method = classCommPortIdentifier.getMethod("open", paramTypes);
            return new SerialPort(method.invoke(this.realObject, appname, timeout));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Enumeration<CommPortIdentifier> getPortIdentifiers() {
        Enumeration<Object> list;
        if (classCommPortIdentifier == null) {
            throw new RuntimeException("CommPortIdentifier class not found");
        }
        try {
            Method method = classCommPortIdentifier.getMethod("getPortIdentifiers", null);
            Object type = null;
            list = ReflectionHelper.invokeAndCastEnumeration(type, method, null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Vector<CommPortIdentifier> vec = new Vector<CommPortIdentifier>();
        while (list.hasMoreElements()) {
            vec.add(new CommPortIdentifier(list.nextElement()));
        }
        return vec.elements();
    }

    public static CommPortIdentifier getPortIdentifier(String portName) {
        CommPortIdentifier port;
        if (classCommPortIdentifier == null) {
            throw new RuntimeException("CommPortIdentifier class not found");
        }
        try {
            Method method = classCommPortIdentifier.getMethod("getPortIdentifier", String.class);
            port = new CommPortIdentifier(method.invoke(null, portName));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(new RuntimeException(e.getTargetException().toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return port;
    }

    static {
        try {
            classCommPortIdentifier = Class.forName("javax.comm.CommPortIdentifier");
        }
        catch (ClassNotFoundException e1) {
            try {
                classCommPortIdentifier = Class.forName("gnu.io.CommPortIdentifier");
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("CommPortIdentifier class not found");
            }
        }
        try {
            Field f = classCommPortIdentifier.getField("PORT_SERIAL");
            PORT_SERIAL = f.getInt(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

