/*
 * Decompiled with CFR 0.152.
 */
package org.ajwcc.pduUtils.wappush;

import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ajwcc.pduUtils.gsm3040.PduUtils;
import org.ajwcc.pduUtils.wappush.WapPushUtils;
import org.ajwcc.pduUtils.wappush.WapSiPdu;

public class WapSiUserDataGenerator {
    private WapSiPdu pdu;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public void setWapSiPdu(WapSiPdu pdu) {
        this.pdu = pdu;
    }

    public byte[] generateWapSiUDBytes() {
        try {
            this.baos = new ByteArrayOutputStream();
            this.writeWspHeader();
            this.writeWapSiData();
            return this.baos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeWspHeader() {
        this.baos.write(1);
        this.baos.write(6);
        this.baos.write(4);
        this.baos.write(3);
        this.baos.write(174);
        this.baos.write(129);
        this.baos.write(234);
    }

    private void writeWapSiData() throws Exception {
        this.baos.write(2);
        this.baos.write(5);
        this.baos.write(106);
        this.baos.write(0);
        this.baos.write(69);
        this.baos.write(198);
        this.writeHrefAttribute(this.pdu.getUrl());
        this.writeCreatedAttribute(this.pdu.getCreateDate());
        this.writeExpiresAttribute(this.pdu.getExpireDate());
        this.writeActionAttribute(this.pdu.getWapSignal());
        this.writeSiIdAttribute(this.pdu.getSiId());
        this.baos.write(1);
        this.writeText(this.pdu.getIndicationText());
        this.baos.write(1);
        this.baos.write(1);
    }

    private void writeHrefAttribute(String url) throws Exception {
        if (url == null || url.trim().equals("")) {
            throw new RuntimeException("Invalid URL: '" + url + "'");
        }
        boolean protocolFound = false;
        for (String protocol : WapPushUtils.getProtocols()) {
            if (!url.startsWith(protocol)) continue;
            this.baos.write(WapPushUtils.getProtocolByteFor(protocol));
            protocolFound = true;
            url = url.substring(protocol.length());
            break;
        }
        if (!protocolFound) {
            this.baos.write(11);
        }
        this.baos.write(3);
        int lastPosition = 0;
        block1: for (int i = 0; i < url.length(); ++i) {
            for (String domain : WapPushUtils.getDomains()) {
                String currentPortion;
                if (i + domain.length() > url.length()) {
                    currentPortion = url.substring(lastPosition, url.length());
                    this.baos.write(currentPortion.getBytes("UTF-8"));
                    i += domain.length();
                    continue block1;
                }
                if (!url.substring(i, i + domain.length()).equalsIgnoreCase(domain)) continue;
                if (lastPosition < i) {
                    currentPortion = url.substring(lastPosition, i);
                    this.baos.write(currentPortion.getBytes("UTF-8"));
                }
                this.baos.write(0);
                this.baos.write(WapPushUtils.getDomainByteFor(domain));
                this.baos.write(3);
                lastPosition = i += domain.length();
                continue block1;
            }
        }
        this.baos.write(0);
    }

    private void writeCreatedAttribute(Date createDate) throws Exception {
        if (createDate != null) {
            this.baos.write(10);
            this.writeDate(createDate);
        }
    }

    private void writeExpiresAttribute(Date expireDate) throws Exception {
        if (expireDate != null) {
            this.baos.write(16);
            this.writeDate(expireDate);
        }
    }

    private void writeSiIdAttribute(String siId) {
        if (siId != null && siId.trim().equals("")) {
            this.baos.write(17);
            this.writeText(siId);
        }
    }

    private void writeActionAttribute(int wapSignal) {
        if (wapSignal != 7) {
            this.baos.write(wapSignal);
        }
    }

    private void writeText(String text) {
        try {
            this.baos.write(3);
            this.baos.write(text.getBytes("UTF-8"));
            this.baos.write(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDate(Date date) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMddHHmmss");
        String dateData = sdf.format(date);
        for (int i = 6; i >= 0 && dateData.endsWith("00"); --i) {
            dateData = dateData.substring(0, i * 2);
        }
        byte[] dataBytes = PduUtils.pduToBytes(dateData);
        this.baos.write(195);
        this.baos.write(dataBytes.length);
        this.baos.write(dataBytes);
    }
}

