/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.util;

import com.ease.gsms.server.util.CachedRememberMeTokenInfo;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;

public class RaceAvoidingPersistentTokenBasedRememberMeServices
extends PersistentTokenBasedRememberMeServices {
    private static final int TOKEN_CACHE_MAX_SIZE = 1000;
    private final Map<String, CachedRememberMeTokenInfo> tokenCache = new ConcurrentHashMap();
    private final PersistentTokenRepository tokenRepository;
    private int cachedTokenValidityTime = 30000;

    public RaceAvoidingPersistentTokenBasedRememberMeServices(String key, UserDetailsService userDetailsService, PersistentTokenRepository tokenRepository) {
        super(key, userDetailsService, tokenRepository);
        this.tokenRepository = tokenRepository;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String cookie = this.extractRememberMeCookie(request);
        if (cookie != null) {
            String[] seriesAndToken = this.decodeCookie(cookie);
            super.logout(request, response, authentication);
            this.tokenCache.remove(seriesAndToken[0]);
        }
    }

    protected UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        UserDetails details;
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException("Cookie token did not contain 2 tokens, but contained '" + Arrays.asList(cookieTokens) + "'");
        }
        String presentedSeries = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        PersistentRememberMeToken token = this.tokenRepository.getTokenForSeries(presentedSeries);
        if (token == null) {
            throw new RememberMeAuthenticationException("No persistent token found for series id: " + presentedSeries);
        }
        if (this.isTokenCached(presentedSeries, presentedToken)) {
            details = this.getUserDetailsService().loadUserByUsername(token.getUsername());
            this.setCookie(new String[]{token.getSeries(), token.getTokenValue()}, this.getTokenValiditySeconds(), request, response);
            System.out.println(String.format("%d - %s - Found a cached token with series: %s, token: %s - setting cookie value to %s - %s", System.currentTimeMillis(), request.getRemoteHost(), presentedSeries, presentedToken, token.getTokenValue(), request.getRequestURI()));
        } else {
            System.out.println(String.format("%d - %s - Haven't found a cached token with series: %s, token: %s - caching token and doing processAutoLoginCookie - %s", System.currentTimeMillis(), request.getRemoteHost(), presentedSeries, presentedToken, request.getRequestURI()));
            this.cacheToken(token);
            try {
                details = super.processAutoLoginCookie(cookieTokens, request, response);
            }
            catch (RememberMeAuthenticationException ex) {
                System.out.println(String.format("%d - %s - Cookie theft crap with series: %s, token: %s - removing series from cache - %s", System.currentTimeMillis(), request.getRemoteHost(), presentedSeries, presentedToken, request.getRequestURI()));
                this.tokenCache.remove(token.getSeries());
                throw ex;
            }
        }
        this.validateTokenCache();
        return details;
    }

    private void cacheToken(PersistentRememberMeToken token) {
        if (this.tokenCache.size() >= 1000) {
            this.validateTokenCache();
        }
        CachedRememberMeTokenInfo tokenInfo = new CachedRememberMeTokenInfo(token.getTokenValue(), System.currentTimeMillis());
        this.tokenCache.put(token.getSeries(), tokenInfo);
    }

    @Scheduled(fixedRate=30000L)
    private void validateTokenCache() {
        for (Map.Entry entry : this.tokenCache.entrySet()) {
            if (this.isTokenInfoValid((CachedRememberMeTokenInfo)entry.getValue())) continue;
            this.tokenCache.remove(entry.getKey());
        }
    }

    private boolean isTokenInfoValid(CachedRememberMeTokenInfo tokenInfo) {
        return System.currentTimeMillis() - tokenInfo.getCachingTime() < (long)this.cachedTokenValidityTime;
    }

    private boolean isTokenCached(String series, String value) {
        CachedRememberMeTokenInfo tokenInfo = (CachedRememberMeTokenInfo)this.tokenCache.get(series);
        return tokenInfo != null && this.isTokenInfoValid(tokenInfo) && value.equals(tokenInfo.getValue());
    }

    public void setCachedTokenValidityTime(int cachedTokenValidityTime) {
        this.cachedTokenValidityTime = cachedTokenValidityTime;
    }
}

