/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.services.dispatch;

import com.ease.gsms.server.model.Dispatch;
import com.ease.gsms.server.model.DispatchStatus;
import com.ease.gsms.server.model.MessageStatus;
import com.ease.gsms.server.repositories.DispatchRepository;
import com.ease.gsms.server.services.DispatchUpdateObserver;
import com.ease.gsms.server.services.dispatch.DispatchStatusHolder;
import com.ease.gsms.server.services.dispatch.MessageSender;
import com.ease.gsms.server.services.dispatch.WorkAllocator;
import com.ease.gsms.server.services.dispatch.WorkBalancingService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class WorkBalancingService {
    @Autowired
    DispatchRepository dispatchRepository;
    @Autowired
    WorkAllocator allocator;
    @Autowired
    Logger logger;
    private Map<String, MessageSender> workers;
    private Map<String, Map<Long, Dispatch>> work;
    private Map<UUID, Long> dispatchIdByUuidMap;
    private Set<DispatchUpdateObserver> dispatchUpdateObservers;

    @PostConstruct
    private void init() {
        this.workers = new ConcurrentHashMap();
        this.work = new ConcurrentHashMap();
        this.dispatchIdByUuidMap = new ConcurrentHashMap();
        this.dispatchUpdateObservers = ConcurrentHashMap.newKeySet();
        List activeDispatches = this.dispatchRepository.getActiveDispatches();
        for (Dispatch dispatch : activeDispatches) {
            this.addDispatch(dispatch, false);
        }
        this.allocator.setWorkerContainer(this.workers);
        this.allocator.setWorkContainer(this.work);
        this.pruneDispatches();
        this.allocator.doAllocations(activeDispatches.stream().map(Dispatch::getSubmitter).collect(Collectors.toSet()));
    }

    public boolean addDispatchUpdateObserver(DispatchUpdateObserver observer) {
        return this.dispatchUpdateObservers.add(observer);
    }

    public boolean removeDispatchUpdateObserver(DispatchUpdateObserver observer) {
        return this.dispatchUpdateObservers.remove(observer);
    }

    @Scheduled(cron="0 0 * ? * ?", zone="Etc/UTC")
    private void scheduledReallocation() {
        this.allocator.doAllocations(this.work.values().stream().flatMap(longDispatchMap -> longDispatchMap.values().stream()).map(Dispatch::getSubmitter).collect(Collectors.toSet()));
    }

    @Scheduled(cron="0 0 0 ? * ?", zone="Etc/UTC")
    private void pruneDispatches() {
        LinkedList<Dispatch> toPrune = new LinkedList<Dispatch>();
        for (Map userActiveDispatches : this.work.values()) {
            for (Dispatch dispatch : userActiveDispatches.values()) {
                boolean shouldPrune = dispatch.getStatus() == DispatchStatus.COMPLETED || dispatch.getStatus() == DispatchStatus.CANCELLED;
                if (shouldPrune) continue;
                if (dispatch.getMessages().isEmpty()) {
                    shouldPrune = true;
                } else {
                    DispatchStatusHolder holder = new DispatchStatusHolder(dispatch, Collections.emptySet(), false);
                    Map messagesCountsByStatus = holder.getMessagesCountsByStatus();
                    if (messagesCountsByStatus.getOrDefault(MessageStatus.CREATED, 0) + messagesCountsByStatus.getOrDefault(MessageStatus.ALLOCATED, 0) + messagesCountsByStatus.getOrDefault(MessageStatus.RESERVED, 0) == 0) {
                        shouldPrune = true;
                    }
                }
                if (!shouldPrune) continue;
                this.dispatchRepository.updateDispatchStatus(dispatch.getId(), new Date(), Integer.valueOf(DispatchStatus.COMPLETED.getId()));
                toPrune.add(dispatch);
            }
        }
        for (Dispatch dispatch : toPrune) {
            this.removeDispatch(dispatch, false);
        }
    }

    public void addDispatch(Dispatch dispatch) {
        this.addDispatch(dispatch, true);
    }

    public void addDispatch(Dispatch dispatch, boolean triggerAllocations) {
        this.dispatchIdByUuidMap.put(dispatch.getUUID(), dispatch.getId());
        this.work.computeIfAbsent(dispatch.getSubmitter(), s -> new ConcurrentHashMap()).put(dispatch.getId(), dispatch);
        if (dispatch.getDispatchStatusHolder() == null) {
            dispatch.setDispatchStatusHolder(new DispatchStatusHolder(dispatch, Collections.singleton((userName, dispatchStatusHolder) -> {
                int totalMessageCount = dispatchStatusHolder.getTotalMessageCount();
                Map messagesCountsByStatus = dispatchStatusHolder.getMessagesCountsByStatus();
                DispatchStatus originalStatus = dispatch.getStatus();
                int sent = messagesCountsByStatus.getOrDefault(MessageStatus.SENT, 0);
                int sentFailed = messagesCountsByStatus.getOrDefault(MessageStatus.SENDING_FAILED, 0);
                int deliveryFailed = messagesCountsByStatus.getOrDefault(MessageStatus.DELIVERY_FAILED, 0);
                int delivered = messagesCountsByStatus.getOrDefault(MessageStatus.DELIVERED, 0);
                int sentSum = sent + sentFailed + deliveryFailed + delivered;
                switch (1.$SwitchMap$com$ease$gsms$server$model$DispatchStatus[dispatchStatusHolder.getStatus().ordinal()]) {
                    case 1: {
                        if (sentSum > 0) {
                            dispatch.setStatus(DispatchStatus.IN_PROGRESS);
                        }
                    }
                    case 2: {
                        if (totalMessageCount != sentSum) break;
                        dispatch.setStatus(DispatchStatus.COMPLETED);
                    }
                }
                if (dispatch.getStatus() != originalStatus) {
                    this.dispatchRepository.updateDispatchStatus(dispatch.getId(), new Date(), Integer.valueOf(dispatch.getStatus().getId()));
                }
                this.dispatchUpdateObservers.forEach(observer -> observer.updated(dispatch.getSubmitter(), dispatchStatusHolder));
            }), true));
        }
        if (triggerAllocations) {
            this.allocator.doAllocations(Collections.singleton(dispatch.getSubmitter()));
        }
    }

    public void removeDispatch(Dispatch dispatch) {
        this.removeDispatch(dispatch, true);
    }

    public void removeDispatch(Dispatch dispatch, boolean triggerAllocations) {
        this.dispatchIdByUuidMap.remove(dispatch.getUUID());
        this.work.computeIfAbsent(dispatch.getSubmitter(), s -> new ConcurrentHashMap()).remove(dispatch.getId());
        if (triggerAllocations) {
            this.allocator.doAllocations(Collections.singleton(dispatch.getSubmitter()));
        }
    }

    public MessageSender getWorker(String id) {
        return (MessageSender)this.workers.get(id);
    }

    public MessageSender getWorker(String id, String userName) {
        MessageSender worker = this.getWorker(id);
        if (worker != null && worker.getUser().equals(userName)) {
            return worker;
        }
        return null;
    }

    public void registerWorker(MessageSender worker) {
        worker.setRepository(this.dispatchRepository);
        worker.setAllocator(this.allocator);
        this.workers.put(worker.getId(), worker);
        this.allocator.doAllocations(Collections.singleton(worker.getUser()));
    }

    public boolean unregisterWorker(String id) {
        return this.unregisterWorkers(Collections.singleton(id));
    }

    public boolean unregisterWorkers(Set<String> ids) {
        boolean changed = false;
        String user = null;
        for (String id : ids) {
            MessageSender worker = (MessageSender)this.workers.remove(id);
            if (worker == null) continue;
            user = worker.getUser();
            changed = true;
        }
        if (changed) {
            this.allocator.doAllocations(Collections.singleton(user));
        }
        return changed;
    }

    public Dispatch getLiveDispatch(UUID requestId, String userName) {
        Long dispatchId = (Long)this.dispatchIdByUuidMap.get(requestId);
        if (dispatchId == null) {
            return null;
        }
        return (Dispatch)((Map)this.work.get(userName)).get(dispatchId);
    }

    public Collection<Dispatch> getLiveDispatches(String userName) {
        Map dispatchMapForUser = (Map)this.work.get(userName);
        return dispatchMapForUser != null ? dispatchMapForUser.values() : Collections.emptySet();
    }

    public Dispatch pauseDispatch(Dispatch dispatch) {
        switch (1.$SwitchMap$com$ease$gsms$server$model$DispatchStatus[dispatch.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                dispatch.setStatus(DispatchStatus.PAUSED);
                this.dispatchRepository.updateDispatchStatus(dispatch.getId(), new Date(), Integer.valueOf(DispatchStatus.PAUSED.getId()));
                dispatch.getDispatchStatusHolder().notifyObservers();
                this.allocator.doAllocations(Collections.singleton(dispatch.getSubmitter()));
            }
        }
        return dispatch;
    }

    public Dispatch resumeDispatch(Dispatch dispatch) {
        switch (1.$SwitchMap$com$ease$gsms$server$model$DispatchStatus[dispatch.getStatus().ordinal()]) {
            case 3: 
            case 4: {
                dispatch.setStatus(DispatchStatus.IN_PROGRESS);
                this.dispatchRepository.updateDispatchStatus(dispatch.getId(), new Date(), Integer.valueOf(DispatchStatus.IN_PROGRESS.getId()));
                dispatch.getDispatchStatusHolder().notifyObservers();
                this.allocator.doAllocations(Collections.singleton(dispatch.getSubmitter()));
            }
        }
        return dispatch;
    }

    public Dispatch cancel(Dispatch dispatch) {
        switch (1.$SwitchMap$com$ease$gsms$server$model$DispatchStatus[dispatch.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                dispatch.setStatus(DispatchStatus.CANCELLED);
                this.dispatchRepository.updateDispatchStatus(dispatch.getId(), new Date(), Integer.valueOf(DispatchStatus.CANCELLED.getId()));
                dispatch.getDispatchStatusHolder().notifyObservers();
                this.allocator.doAllocations(Collections.singleton(dispatch.getSubmitter()));
            }
        }
        return dispatch;
    }
}

