/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.services.dispatch;

import com.ease.gsms.server.model.Dispatch;
import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.services.dispatch.Allocation;
import com.ease.gsms.server.services.dispatch.BinBalancer;
import com.ease.gsms.server.services.dispatch.MessageSender;
import com.ease.gsms.server.services.dispatch.Task;
import com.ease.gsms.server.services.dispatch.WorkAllocator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Controller;

@Controller
public class WorkAllocator {
    @Autowired
    Logger logger;
    private Map<String, MessageSender> workerContainer;
    private Map<String, Map<Long, Dispatch>> workContainer;

    @Async
    void doAllocations(Set<String> usersWithChanges) {
        for (String user : usersWithChanges) {
            this.doAllocations(user);
        }
    }

    private void doAllocations(String user) {
        Map newAllocations = this.computeAllocations(user);
        Set referencedWorkers = newAllocations.values().stream().map(Allocation::getWorker).collect(Collectors.toSet());
        Set workersToDeallocate = this.workerContainer.values().stream().filter(worker -> user.equals(worker.getUser())).collect(Collectors.toSet());
        workersToDeallocate.removeAll(referencedWorkers);
        for (MessageSender worker2 : workersToDeallocate) {
            worker2.deallocate();
        }
        newAllocations.entrySet().forEach(entry -> ((MessageSender)this.workerContainer.get(entry.getKey())).allocate((Allocation)entry.getValue()));
    }

    private synchronized Map<String, Allocation> computeAllocations(String user) {
        Map dispatchesById = this.workContainer.getOrDefault(user, Collections.emptyMap());
        Set workers = this.workerContainer.values().stream().filter(worker -> user.equals(worker.getUser())).collect(Collectors.toSet());
        Map workersBySimId = workers.stream().collect(Collectors.toMap(MessageSender::getId, Function.identity()));
        Map<String, Allocation> allocationsBySimId = workersBySimId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new Allocation((MessageSender)entry.getValue())));
        Set dispatches = dispatchesById.values().stream().filter(dispatch -> {
            switch (1.$SwitchMap$com$ease$gsms$server$model$DispatchStatus[dispatch.getStatus().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toSet());
        for (Dispatch dispatch2 : dispatches) {
            String iccid = dispatch2.getFromICCID();
            if (iccid == null || !allocationsBySimId.containsKey(iccid)) continue;
            allocationsBySimId.get(iccid).addTask(new Task(dispatch2, true, dispatch2.unsent().collect(Collectors.toList())));
        }
        int[] bins = allocationsBySimId.values().stream().mapToInt(Allocation::getWeight).toArray();
        int[] unsentMessageCounts = dispatches.stream().mapToInt(dispatch -> dispatch.getFromICCID() != null ? -1 : dispatch.getUnsentMessageCount()).toArray();
        int totalUnallocatedMessageCount = 0;
        int i = 0;
        for (Dispatch dispatch3 : dispatches) {
            if (dispatch3.getFromICCID() == null) {
                totalUnallocatedMessageCount += unsentMessageCounts[i];
            }
            ++i;
        }
        int[] addToBin = BinBalancer.balanceDelta((int)totalUnallocatedMessageCount, (int[])bins);
        if (!allocationsBySimId.isEmpty()) {
            Iterator<Allocation> allocationIterator = allocationsBySimId.values().iterator();
            Allocation currentAllocation = allocationIterator.next();
            i = 0;
            for (Dispatch dispatch4 : dispatches) {
                if (dispatch4.getFromICCID() != null) continue;
                LinkedList<Message> currentMessageList = new LinkedList<Message>();
                for (Message message : dispatch4.getMessages()) {
                    if (!message.isUnsent()) continue;
                    int n = i;
                    int n2 = addToBin[n];
                    addToBin[n] = n2 - 1;
                    if (n2 > 0) {
                        currentMessageList.add(message);
                        continue;
                    }
                    if (!currentMessageList.isEmpty()) {
                        currentAllocation.addTask(new Task(dispatch4, false, currentMessageList));
                        currentMessageList = new LinkedList();
                    }
                    currentMessageList.add(message);
                    currentAllocation = allocationIterator.hasNext() ? allocationIterator.next() : null;
                    ++i;
                }
                if (currentMessageList.isEmpty()) continue;
                currentAllocation.addTask(new Task(dispatch4, false, currentMessageList));
            }
        }
        if (!(allocationsBySimId = allocationsBySimId.entrySet().stream().filter(entry -> ((Allocation)entry.getValue()).hasNext()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            this.logger.info("Allocations for {}", (Object)user);
            for (Allocation allocation : allocationsBySimId.values()) {
                this.logger.info("{}: {} tasks, {} messages", new Object[]{allocation.getUuid(), allocation.getTasks().size(), allocation.getWeight()});
                for (Task task : allocation.getTasks()) {
                    this.logger.info("{}: task with {} messages, depleted: {}", new Object[]{allocation.getUuid(), task.getWeight(), !task.hasNext()});
                }
            }
        }
        return allocationsBySimId;
    }

    void setWorkerContainer(Map<String, MessageSender> workerContainer) {
        this.workerContainer = workerContainer;
    }

    void setWorkContainer(Map<String, Map<Long, Dispatch>> workContainer) {
        this.workContainer = workContainer;
    }

    public Map<String, MessageSender> getWorkerContainer() {
        return this.workerContainer;
    }

    public Map<String, Map<Long, Dispatch>> getWorkContainer() {
        return this.workContainer;
    }
}

