/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.services.dispatch;

import com.ease.gsms.server.model.Dispatch;
import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.model.MessageStatus;
import com.ease.gsms.server.repositories.DispatchRepository;
import com.ease.gsms.server.services.dispatch.Allocation;
import com.ease.gsms.server.services.dispatch.DispatchStatusHolder;
import com.ease.gsms.server.services.dispatch.Task;
import com.ease.gsms.server.services.dispatch.WorkAllocator;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class MessageSender {
    private String id;
    private String user;
    private volatile Allocation allocation;
    private transient DispatchRepository repository;
    private transient WorkAllocator allocator;
    private ExecutorService messageSender = Executors.newSingleThreadExecutor();

    protected MessageSender(String id, String user) {
        this.id = id;
        this.user = user;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setRepository(DispatchRepository repository) {
        this.repository = repository;
    }

    public void setAllocator(WorkAllocator allocator) {
        this.allocator = allocator;
    }

    public void allocate(Allocation allocation) {
        if (!allocation.equals((Object)this.allocation)) {
            this.allocation = allocation;
            this.announceAllocation(allocation);
        }
    }

    public void deallocate() {
        this.announceDeallocation(this.allocation);
        this.allocation = null;
    }

    public abstract void announceAllocation(Allocation var1);

    public abstract void announceDeallocation(Allocation var1);

    public abstract void sendMessage(Message var1);

    private void sendNextMessage() {
        Task task = this.allocation.current();
        if (task.hasNext()) {
            this.messageSender.submit(() -> {
                Integer pauseBetweenMessagesSeconds = task.getDispatch().getPauseBetweenMessagesSeconds();
                if (pauseBetweenMessagesSeconds > 0) {
                    try {
                        Thread.sleep(pauseBetweenMessagesSeconds * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.sendMessage(task.next());
            });
        } else if (this.allocation.hasNext()) {
            this.allocation.next();
            this.sendNextMessage();
        }
    }

    public void allocationConfirmed(UUID allocationId) {
        if (this.allocation.getUuid().equals(allocationId)) {
            LinkedList<Long> allocatedMessageIds = new LinkedList<Long>();
            Date allocationDate = new Date();
            String iccid = this.allocation.getWorker().getId();
            for (Task task : this.allocation.getTasks()) {
                for (Message message : task.getMessages()) {
                    MessageStatus existingStatus = message.getStatus();
                    message.setFromICCID(iccid);
                    message.setAllocationDate(allocationDate);
                    task.getDispatch().getDispatchStatusHolder().updateMessageStatus(existingStatus, message.getStatus());
                    allocatedMessageIds.add(message.getId());
                }
            }
            this.repository.allocateMessages(allocatedMessageIds, iccid, allocationDate);
            if (this.allocation.hasNext()) {
                this.allocation.next();
                this.sendNextMessage();
            }
        }
    }

    public void messageSent(UUID allocationId, Long dispatchId, Long messageId, Integer sendingStatusId, Date sentDate) {
        Map dispatchMap = (Map)this.allocator.getWorkContainer().get(this.user);
        Dispatch dispatch = (Dispatch)dispatchMap.get(dispatchId);
        if (dispatch != null) {
            Message message;
            Map messagesById = dispatch.getMessagesById();
            if (messagesById != null && (message = (Message)messagesById.get(messageId)) != null) {
                MessageStatus existingStatus = message.getStatus();
                message.setFromICCID(this.id);
                message.setSentDate(sentDate);
                message.setSendingStatus(sendingStatusId);
                this.repository.updateMessageSentInformation(messageId, this.id, sentDate, sendingStatusId);
                DispatchStatusHolder dispatchStatusHolder = dispatch.getDispatchStatusHolder();
                if (dispatchStatusHolder != null) {
                    dispatchStatusHolder.updateMessageStatus(existingStatus, message.getStatus());
                }
            }
            if (this.allocation != null && this.allocation.getUuid().equals(allocationId) && (this.allocation.hasNext() || this.allocation.current().hasNext())) {
                this.sendNextMessage();
            }
        } else {
            Message message = this.repository.getMessageByIdForUser(messageId, this.user);
            if (message != null) {
                this.repository.updateMessageSentInformation(messageId, this.id, sentDate, sendingStatusId);
            }
        }
    }

    public void messageDelivered(UUID allocation, Long dispatchId, Long messageId, Date deliveryDate, Integer deliveryStatusId) {
        Map dispatchMap = (Map)this.allocator.getWorkContainer().get(this.user);
        Dispatch dispatch = (Dispatch)dispatchMap.get(dispatchId);
        if (dispatch != null) {
            Message message;
            Map messagesById = dispatch.getMessagesById();
            if (messagesById != null && (message = (Message)messagesById.get(messageId)) != null) {
                MessageStatus existingStatus = message.getStatus();
                message.setDeliveredDate(deliveryDate);
                message.setDeliveryStatus(deliveryStatusId);
                this.repository.updateMessageDeliveryInformation(messageId, deliveryDate, deliveryStatusId);
                DispatchStatusHolder dispatchStatusHolder = dispatch.getDispatchStatusHolder();
                if (dispatchStatusHolder != null) {
                    dispatchStatusHolder.updateMessageStatus(existingStatus, message.getStatus());
                }
            }
        } else {
            Message message = this.repository.getMessageByIdForUser(messageId, this.user);
            if (message != null) {
                this.repository.updateMessageDeliveryInformation(messageId, deliveryDate, deliveryStatusId);
            }
        }
    }
}

