/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.services.dispatch;

import com.ease.gsms.server.model.Dispatch;
import com.ease.gsms.server.model.DispatchStatus;
import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.model.MessageStatus;
import com.ease.gsms.server.services.DispatchUpdateObserver;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DispatchStatusHolder {
    boolean live;
    int totalMessageCount;
    Map<MessageStatus, AtomicInteger> messagesCountsByStatus;
    transient Set<DispatchUpdateObserver> observers;
    transient Dispatch dispatch;

    public DispatchStatusHolder(Dispatch dispatch, Set<DispatchUpdateObserver> observers, boolean live) {
        this.dispatch = dispatch;
        this.live = live;
        this.observers = observers;
        this.messagesCountsByStatus = new ConcurrentHashMap();
        for (Message message : dispatch.getMessages()) {
            this.messagesCountsByStatus.computeIfAbsent(message.getStatus(), s -> new AtomicInteger()).incrementAndGet();
            ++this.totalMessageCount;
        }
    }

    public Long getId() {
        return this.dispatch.getId();
    }

    public UUID getUUID() {
        return this.dispatch.getUUID();
    }

    public String getFromICCID() {
        return this.dispatch.getFromICCID();
    }

    public String getSubmitter() {
        return this.dispatch.getSubmitter();
    }

    public Date getSubmissionDate() {
        return this.dispatch.getSubmissionDate();
    }

    public Date getModificationDate() {
        return this.dispatch.getModificationDate();
    }

    public Boolean getSendToInternationalNumbers() {
        return this.dispatch.getSendToInternationalNumbers();
    }

    public Boolean getSendToNationalLandlines() {
        return this.dispatch.getSendToNationalLandlines();
    }

    public Boolean getSendToNationalMobiles() {
        return this.dispatch.getSendToNationalMobiles();
    }

    public Boolean getResendIdenticalSuccessfullyDeliveredMessages() {
        return this.dispatch.getResendIdenticalSuccessfullyDeliveredMessages();
    }

    public Boolean getResendIdenticalSuccessfullySentMessages() {
        return this.dispatch.getResendIdenticalSuccessfullySentMessages();
    }

    public Boolean getResendIdenticalUnsuccessfullySentMessages() {
        return this.dispatch.getResendIdenticalUnsuccessfullySentMessages();
    }

    public Boolean getResendUnsentMessages() {
        return this.dispatch.getResendUnsentMessages();
    }

    public DispatchStatus getStatus() {
        return this.dispatch.getStatus();
    }

    public Boolean getAskForDeliveryReport() {
        return this.dispatch.getAskForDeliveryReport();
    }

    public Integer getPauseBetweenMessagesSeconds() {
        return this.dispatch.getPauseBetweenMessagesSeconds();
    }

    public Map<MessageStatus, Integer> getMessagesCountsByStatus() {
        return this.messagesCountsByStatus.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AtomicInteger)entry.getValue()).get()));
    }

    public int getTotalMessageCount() {
        return this.totalMessageCount;
    }

    public void updateMessageStatus(MessageStatus existingStatus, MessageStatus status) {
        AtomicInteger before = (AtomicInteger)this.messagesCountsByStatus.get(existingStatus);
        AtomicInteger after = this.messagesCountsByStatus.computeIfAbsent(status, s -> new AtomicInteger());
        before.decrementAndGet();
        after.incrementAndGet();
        this.notifyObservers();
    }

    public void notifyObservers() {
        for (DispatchUpdateObserver observer : this.observers) {
            observer.updated(this.dispatch.getSubmitter(), this);
        }
    }
}

