/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.services.dispatch;

/*
 * Exception performing whole class analysis ignored.
 */
public class BinBalancer {
    public static int[] balance(int additional, int[] bins) {
        int binCount = bins.length;
        if (binCount == 0) {
            return new int[0];
        }
        if (binCount == 1) {
            return new int[]{bins[0] + additional};
        }
        if (additional < 0) {
            throw new IllegalArgumentException("Algorithm only works with natural (positive) numbers");
        }
        int[] copiedBins = new int[binCount];
        System.arraycopy(bins, 0, copiedBins, 0, binCount);
        bins = copiedBins;
        int[] permutations = new int[binCount];
        for (int i = 0; i < binCount; ++i) {
            permutations[i] = i;
        }
        BinBalancer.permutationAwareQuickSort((int[])bins, (int[])permutations);
        int lastAdditional = -1;
        while (lastAdditional != additional) {
            int consecutiveEqualBins;
            int startingValue = bins[0];
            for (consecutiveEqualBins = 0; consecutiveEqualBins < binCount && bins[consecutiveEqualBins] == startingValue; ++consecutiveEqualBins) {
            }
            int maxDelta = additional / consecutiveEqualBins;
            int delta = consecutiveEqualBins < binCount ? Math.min(bins[consecutiveEqualBins] - startingValue, maxDelta) : maxDelta;
            int i = 0;
            while (i < consecutiveEqualBins) {
                int n = i++;
                bins[n] = bins[n] + delta;
            }
            lastAdditional = additional;
            additional -= delta * consecutiveEqualBins;
        }
        bins[0] = bins[0] + additional;
        int[] inInitialOrder = new int[binCount];
        for (int i = 0; i < binCount; ++i) {
            inInitialOrder[permutations[i]] = bins[i];
        }
        return inInitialOrder;
    }

    public static int[] balanceDelta(int additional, int[] bins) {
        int binCount = bins.length;
        int[] delta = new int[binCount];
        int[] distributed = BinBalancer.balance((int)additional, (int[])bins);
        for (int i = 0; i < binCount; ++i) {
            delta[i] = distributed[i] - bins[i];
        }
        return delta;
    }

    private static void permutationAwareQuickSort(int[] array, int[] permutations) {
        int high = array.length - 1;
        boolean inOrder = true;
        for (int i = 0; inOrder && i < high; ++i) {
            inOrder = array[i] <= array[i + 1];
        }
        if (!inOrder) {
            BinBalancer.permutationAwareQuickSort((int[])array, (int[])permutations, (int)0, (int)high);
        }
    }

    private static void permutationAwareQuickSort(int[] array, int[] permutations, int low, int high) {
        if (low < high) {
            int pivot = array[high];
            int i = low - 1;
            for (int j = low; j <= high - 1; ++j) {
                if (array[j] >= pivot) continue;
                BinBalancer.swap((int[])array, (int[])permutations, (int)(++i), (int)j);
            }
            BinBalancer.swap((int[])array, (int[])permutations, (int)(i + 1), (int)high);
            BinBalancer.permutationAwareQuickSort((int[])array, (int[])permutations, (int)low, (int)i);
            BinBalancer.permutationAwareQuickSort((int[])array, (int[])permutations, (int)(i + 2), (int)high);
        }
    }

    private static void swap(int[] array, int[] permutations, int i, int j) {
        int t = array[j];
        int tp = permutations[j];
        array[j] = array[i];
        permutations[j] = permutations[i];
        array[i] = t;
        permutations[i] = tp;
    }
}

