/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.services.dispatch;

import com.ease.gsms.server.services.dispatch.MessageSender;
import com.ease.gsms.server.services.dispatch.Task;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class Allocation
implements Iterator<Task> {
    private List<Task> tasks = new ArrayList();
    private MessageSender worker;
    private int weight = 0;
    private UUID uuid;
    private int currentTaskIndex = -1;

    public Allocation(MessageSender worker) {
        this.worker = worker;
        this.uuid = UUID.randomUUID();
    }

    void addTask(Task task) {
        this.weight += task.getWeight();
        this.tasks.add(task);
    }

    public int getWeight() {
        return this.weight;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public boolean hasNext() {
        return this.currentTaskIndex < this.tasks.size() - 1;
    }

    @Override
    public Task next() {
        return (Task)this.tasks.get(++this.currentTaskIndex);
    }

    public Task current() {
        return (Task)this.tasks.get(this.currentTaskIndex);
    }

    public MessageSender getWorker() {
        return this.worker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Allocation that = (Allocation)o;
        return this.weight == that.weight && Objects.equals(this.tasks, that.tasks);
    }
}

